/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.JiraTestResultReporter;

import com.atlassian.jira.rest.client.api.GetCreateIssueMetadataOptions;
import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.MetadataRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import com.atlassian.jira.rest.client.api.domain.CimIssueType;
import com.atlassian.jira.rest.client.api.domain.CimProject;
import com.atlassian.jira.rest.client.api.domain.ServerInfo;
import hudson.util.ListBoxModel;
import io.atlassian.util.concurrent.Promise;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraUtils;

public class MetadataCache {
    HashMap<String, HashMap<String, CacheEntry>> fieldConfigCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheEntry(String projectKey, String issueType) {
        if (this.fieldConfigCache.containsKey(projectKey) && this.fieldConfigCache.get(projectKey).containsKey(issueType)) {
            HashMap<String, CacheEntry> hashMap = this.fieldConfigCache.get(projectKey);
            synchronized (hashMap) {
                this.fieldConfigCache.get(projectKey).remove(issueType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry getCacheEntry(String projectKey, String issueType) {
        HashMap<String, CacheEntry> issueTypeToFields;
        CacheEntry cacheEntry;
        try {
            cacheEntry = this.fieldConfigCache.get(projectKey).get(issueType);
            if (cacheEntry != null) {
                return cacheEntry;
            }
            this.fieldConfigCache.get(projectKey).remove(issueType);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!this.fieldConfigCache.containsKey(projectKey)) {
            HashMap<String, HashMap<String, CacheEntry>> hashMap = this.fieldConfigCache;
            synchronized (hashMap) {
                if (!this.fieldConfigCache.containsKey(projectKey)) {
                    this.fieldConfigCache.put(projectKey, new HashMap());
                }
            }
        }
        if ((cacheEntry = (issueTypeToFields = this.fieldConfigCache.get(projectKey)).get(issueType)) == null) {
            HashMap<String, CacheEntry> hashMap = issueTypeToFields;
            synchronized (hashMap) {
                if (!issueTypeToFields.containsKey(issueType)) {
                    Iterable metadata;
                    IssueRestClient issueRestClient = JiraUtils.getJiraDescriptor().getRestClient().getIssueClient();
                    try {
                        metadata = (Iterable)issueRestClient.getCreateIssueMetadata(new GetCreateIssueMetadataOptions(Collections.singletonList("projects.issuetypes.fields"), null, Collections.singletonList(Long.parseLong(issueType)), Collections.singletonList(projectKey), null)).claim();
                    }
                    catch (RestClientException e) {
                        MetadataRestClient client = JiraUtils.getJiraDescriptor().getRestClient().getMetadataClient();
                        Promise serverInfoPromise = client.getServerInfo();
                        ServerInfo serverInfo = (ServerInfo)serverInfoPromise.claim();
                        JiraUtils.log("ERROR: RestClientException for getCacheEntry projectKey:" + projectKey + " issueType:" + issueType + "JIRA Version" + serverInfo.getVersion());
                        JiraUtils.logError("ERROR: RestClientException error", (Exception)((Object)e));
                        return null;
                    }
                    catch (Exception e) {
                        JiraUtils.logError("ERROR: Unknown error", e);
                        return null;
                    }
                    cacheEntry = new CacheEntry(metadata);
                    issueTypeToFields.put(issueType, cacheEntry);
                    return cacheEntry;
                }
            }
            cacheEntry = issueTypeToFields.get(issueType);
        }
        return cacheEntry;
    }

    private void listInfo(Map.Entry<String, CimFieldInfo> entry) {
        System.out.println(entry.getValue().getName() + " :: " + entry.getValue().getSchema().getType());
        Iterable allowedValues = entry.getValue().getAllowedValues();
        if (allowedValues != null) {
            for (Object o : allowedValues) {
                System.out.println("\t" + String.valueOf(o));
            }
        }
    }

    public static class CacheEntry {
        private Map<String, CimFieldInfo> fieldInfoMap;
        private ListBoxModel stringFieldBox = new ListBoxModel();
        private ListBoxModel selectableFieldBox = new ListBoxModel();
        private ListBoxModel stringArrayFieldBox = new ListBoxModel();
        private ListBoxModel selectableArrayFieldBox;
        private ListBoxModel userFieldBox;

        public CacheEntry(Iterable<CimProject> metadata) {
            CimProject project;
            Iterator iterator;
            this.selectableFieldBox = new ListBoxModel();
            this.selectableArrayFieldBox = new ListBoxModel();
            this.userFieldBox = new ListBoxModel();
            Iterator<CimProject> iterator2 = metadata.iterator();
            if (iterator2.hasNext() && (iterator = (project = iterator2.next()).getIssueTypes().iterator()).hasNext()) {
                CimIssueType cimIssueType = (CimIssueType)iterator.next();
                this.fieldInfoMap = cimIssueType.getFields();
                Set<Map.Entry<String, CimFieldInfo>> entrySet = this.fieldInfoMap.entrySet();
                for (Map.Entry<String, CimFieldInfo> entry : entrySet) {
                    if (entry.getValue().getSchema().getType().equals("string") && entry.getValue().getAllowedValues() == null) {
                        this.stringFieldBox.add((Object)new ListBoxModel.Option(entry.getValue().getName(), entry.getKey(), false));
                        continue;
                    }
                    if (!entry.getValue().getSchema().getType().equals("array") && entry.getValue().getAllowedValues() != null) {
                        this.selectableFieldBox.add((Object)new ListBoxModel.Option(entry.getValue().getName(), entry.getKey(), false));
                        continue;
                    }
                    if (entry.getValue().getSchema().getType().equals("array") && entry.getValue().getAllowedValues() == null) {
                        this.stringArrayFieldBox.add((Object)new ListBoxModel.Option(entry.getValue().getName(), entry.getKey(), false));
                        continue;
                    }
                    if (entry.getValue().getSchema().getType().equals("array") && entry.getValue().getAllowedValues() != null) {
                        this.selectableArrayFieldBox.add((Object)new ListBoxModel.Option(entry.getValue().getName(), entry.getKey(), false));
                        continue;
                    }
                    if (!entry.getValue().getSchema().getType().equals("user")) continue;
                    this.userFieldBox.add((Object)new ListBoxModel.Option(entry.getValue().getName(), entry.getKey(), false));
                }
            }
        }

        public ListBoxModel getStringFieldBox() {
            return this.stringFieldBox;
        }

        public ListBoxModel getSelectableFieldBox() {
            return this.selectableFieldBox;
        }

        public ListBoxModel getStringArrayFieldBox() {
            return this.stringArrayFieldBox;
        }

        public ListBoxModel getSelectableArrayFieldBox() {
            return this.selectableArrayFieldBox;
        }

        public ListBoxModel getUserFieldBox() {
            return this.userFieldBox;
        }

        public Map<String, CimFieldInfo> getFieldInfoMap() {
            return this.fieldInfoMap;
        }

        private void listInfo(Map.Entry<String, CimFieldInfo> entry) {
            System.out.println(entry.getValue().getName() + " :: " + entry.getValue().getSchema().getType());
            Iterable allowedValues = entry.getValue().getAllowedValues();
            if (allowedValues != null) {
                for (Object o : allowedValues) {
                    System.out.println("\t" + String.valueOf(o));
                }
            }
        }
    }
}

