/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.JiraTestResultReporter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Job;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraTestDataPublisher;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraUtils;
import org.jenkinsci.plugins.JiraTestResultReporter.config.AbstractFields;
import org.jenkinsci.plugins.JiraTestResultReporter.config.FieldConfigsJsonAdapter;
import org.jenkinsci.plugins.JiraTestResultReporter.config.StringFields;

public class JobConfigMapping {
    private static JobConfigMapping instance = new JobConfigMapping();
    private static final String CONFIGS_FILE = "JiraIssueJobConfigs";
    private HashMap<String, JobConfigEntry> configMap = new HashMap();

    public static JobConfigMapping getInstance() {
        return instance;
    }

    private JobConfigMapping() {
        for (Job project : Jenkins.get().getItems(Job.class)) {
            JobConfigEntry entry = this.load(project);
            if (entry == null) continue;
            this.configMap.put(project.getFullName(), entry);
        }
    }

    private String getPathToFile(Job<?, ?> project) {
        return project.getRootDir().toPath().resolve(CONFIGS_FILE).toString();
    }

    private String getPathToJsonFile(Job<?, ?> project) {
        return project.getRootDir().toPath().resolve(CONFIGS_FILE).toString() + ".json";
    }

    private JobConfigEntry loadBackwardsCompatible(Job<?, ?> project) {
        try {
            FileInputStream fileIn = new FileInputStream(this.getPathToFile(project));
            ObjectInputStream in = new ObjectInputStream(fileIn);
            JobConfigEntry entry = (JobConfigEntry)in.readObject();
            in.close();
            fileIn.close();
            JiraUtils.log("Found and successfully loaded configs from a previous version for job: " + project.getFullName());
            this.save(project, entry);
            return entry;
        }
        catch (FileNotFoundException fileIn) {
        }
        catch (Exception e) {
            JiraUtils.logError("ERROR: Found configs from a previous version, but was unable to load them for project " + project.getFullName(), e);
        }
        return null;
    }

    private JobConfigEntry load(Job<?, ?> project) {
        JobConfigEntry entry = null;
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(AbstractFields.class, (Object)new FieldConfigsJsonAdapter()).create();
            FileInputStream fileIn = new FileInputStream(this.getPathToJsonFile(project));
            JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)fileIn, "UTF-8"));
            entry = (JobConfigEntry)gson.fromJson(reader, JobConfigEntry.class);
            reader.close();
            fileIn.close();
            return (JobConfigEntry)entry.readResolve();
        }
        catch (FileNotFoundException e) {
            entry = this.loadBackwardsCompatible(project);
            if (entry == null) {
                JiraUtils.log("No configs found for project " + project.getFullName());
            }
        }
        catch (Exception e) {
            JiraUtils.logError("ERROR: Could not load configs for project " + project.getFullName(), e);
        }
        return entry;
    }

    private void save(Job<?, ?> project, JobConfigEntry entry) {
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(AbstractFields.class, (Object)new FieldConfigsJsonAdapter()).create();
            FileOutputStream fileOut = new FileOutputStream(this.getPathToJsonFile(project));
            JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)fileOut, "UTF-8"));
            writer.setIndent("  ");
            gson.toJson((Object)entry, JobConfigEntry.class, writer);
            writer.close();
            fileOut.close();
        }
        catch (Exception e) {
            JiraUtils.logError("ERROR: Could not save project map", e);
        }
    }

    public synchronized void saveConfig(Job<?, ?> project, String projectKey, Long issueType, List<AbstractFields> configs, boolean autoRaiseIssue, boolean autoResolveIssue, boolean autoUnlinkIssue, boolean overrideResolvedIssues, boolean additionalAttachments, boolean manualAddIssue) {
        JobConfigEntry entry = new JobConfigEntry(projectKey, issueType, configs, autoRaiseIssue, autoResolveIssue, autoUnlinkIssue, overrideResolvedIssues, additionalAttachments, manualAddIssue);
        this.saveConfig(project, entry);
    }

    public synchronized void saveConfig(Job<?, ?> project, JobConfigEntry entry) {
        if (project == null) {
            return;
        }
        if (entry instanceof JobConfigEntryBuilder) {
            entry = ((JobConfigEntryBuilder)entry).build();
        }
        this.configMap.put(project.getFullName(), entry);
        this.save(project, entry);
    }

    private JobConfigEntry getJobConfigEntry(@CheckForNull Job<?, ?> project) {
        JobConfigEntry entry;
        if (project == null) {
            return null;
        }
        if (!this.configMap.containsKey(project.getFullName()) && (entry = this.load(project)) != null) {
            this.configMap.put(project.getFullName(), entry);
        }
        return this.configMap.get(project.getFullName());
    }

    public List<AbstractFields> getConfig(Job<?, ?> project) {
        JobConfigEntry entry = this.getJobConfigEntry(project);
        return entry != null ? entry.getConfigs() : null;
    }

    public Long getIssueType(Job<?, ?> project) {
        JobConfigEntry entry = this.getJobConfigEntry(project);
        return entry != null ? entry.getIssueType() : null;
    }

    public String getProjectKey(Job<?, ?> project) {
        JobConfigEntry entry = this.getJobConfigEntry(project);
        return entry != null ? entry.getProjectKey() : null;
    }

    public boolean getAutoRaiseIssue(Job<?, ?> project) {
        JobConfigEntry entry = this.getJobConfigEntry(project);
        return entry != null ? entry.getAutoRaiseIssue() : false;
    }

    public boolean getAutoResolveIssue(Job<?, ?> project) {
        JobConfigEntry entry = this.getJobConfigEntry(project);
        return entry != null ? entry.getAutoResolveIssue() : false;
    }

    public boolean getAutoUnlinkIssue(Job<?, ?> project) {
        JobConfigEntry entry = this.getJobConfigEntry(project);
        return entry != null ? entry.getAutoUnlinkIssue() : false;
    }

    public boolean getAdditionalAttachments(Job<?, ?> project) {
        JobConfigEntry entry = this.getJobConfigEntry(project);
        return entry != null ? entry.getAdditionalAttachments() : false;
    }

    public boolean getOverrideResolvedIssues(Job<?, ?> project) {
        JobConfigEntry entry = this.getJobConfigEntry(project);
        return entry != null ? entry.getOverrideResolvedIssues() : false;
    }

    public boolean getManualAddIssue(Job<?, ?> project) {
        JobConfigEntry entry = this.getJobConfigEntry(project);
        return entry != null ? entry.getManualAddIssue() : false;
    }

    public Pattern getIssueKeyPattern(Job<?, ?> project) {
        JobConfigEntry entry = this.getJobConfigEntry(project);
        return entry != null ? entry.getIssueKeyPattern() : null;
    }

    public static class JobConfigEntry
    implements Serializable {
        public static final long serialVersionUID = 6509568994710878311L;
        protected String projectKey;
        protected Long issueType;
        protected List<AbstractFields> configs;
        protected boolean autoRaiseIssue;
        protected boolean overrideResolvedIssues;
        protected boolean autoResolveIssue;
        protected boolean autoUnlinkIssue;
        protected boolean additionalAttachments;
        protected boolean manualAddIssue;
        protected transient Pattern issueKeyPattern;

        public JobConfigEntry(String projectKey, Long issueType, List<AbstractFields> configs, boolean autoRaiseIssue, boolean autoResolveIssue, boolean autoUnlinkIssue, boolean overrideResolvedIssues, boolean additionalAttachments, boolean manualAddIssue) {
            this.projectKey = projectKey;
            this.issueType = issueType;
            this.configs = configs;
            this.autoRaiseIssue = autoRaiseIssue;
            this.autoResolveIssue = autoResolveIssue;
            this.autoUnlinkIssue = autoUnlinkIssue;
            this.overrideResolvedIssues = overrideResolvedIssues;
            this.additionalAttachments = additionalAttachments;
            this.manualAddIssue = manualAddIssue;
            this.compileIssueKeyPattern();
        }

        public Long getIssueType() {
            return this.issueType;
        }

        public String getProjectKey() {
            return this.projectKey;
        }

        public List<AbstractFields> getConfigs() {
            return this.configs;
        }

        public boolean getAutoRaiseIssue() {
            return this.autoRaiseIssue;
        }

        public boolean getAutoResolveIssue() {
            return this.autoResolveIssue;
        }

        public boolean getAutoUnlinkIssue() {
            return this.autoUnlinkIssue;
        }

        public boolean getAdditionalAttachments() {
            return this.additionalAttachments;
        }

        public boolean getOverrideResolvedIssues() {
            return this.overrideResolvedIssues;
        }

        public boolean getManualAddIssue() {
            return this.manualAddIssue;
        }

        public Pattern getIssueKeyPattern() {
            return this.issueKeyPattern;
        }

        @SuppressFBWarnings(value={"SE_PRIVATE_READ_RESOLVE_NOT_INHERITED"}, justification="TODO needs triage")
        private Object readResolve() {
            this.compileIssueKeyPattern();
            return this;
        }

        protected void compileIssueKeyPattern() {
            this.issueKeyPattern = this.projectKey != null ? Pattern.compile(this.projectKey + "-\\d+") : null;
        }
    }

    public static class JobConfigEntryBuilder
    extends JobConfigEntry {
        public JobConfigEntryBuilder() {
            super(null, null, new ArrayList<AbstractFields>(), false, false, false, false, false, false);
        }

        public JobConfigEntryBuilder withProjectKey(String projectKey) {
            this.projectKey = projectKey;
            this.compileIssueKeyPattern();
            return this;
        }

        public JobConfigEntryBuilder withIssueType(Long issueType) {
            this.issueType = issueType;
            return this;
        }

        public JobConfigEntryBuilder withConfigs(List<AbstractFields> configs) {
            this.configs = configs;
            return this;
        }

        public JobConfigEntryBuilder withAutoRaiseIssues(boolean autoRaiseIssues) {
            this.autoRaiseIssue = autoRaiseIssues;
            return this;
        }

        public JobConfigEntryBuilder withAutoResolveIssues(boolean autoResolveIssue) {
            this.autoResolveIssue = autoResolveIssue;
            return this;
        }

        public JobConfigEntryBuilder withAutoUnlinkIssues(boolean autoUnlinkIssues) {
            this.autoUnlinkIssue = autoUnlinkIssues;
            return this;
        }

        public JobConfigEntryBuilder withAdditionalAttachments(boolean additionalAttachments) {
            this.additionalAttachments = additionalAttachments;
            return this;
        }

        public JobConfigEntryBuilder withOverrideResolvedIssues(boolean overrideResolvedIssues) {
            this.overrideResolvedIssues = overrideResolvedIssues;
            return this;
        }

        public JobConfigEntryBuilder withManualAddIssues(boolean manualAddIssue) {
            this.manualAddIssue = manualAddIssue;
            return this;
        }

        public JobConfigEntry build() {
            if (this.projectKey == null) {
                throw new IllegalStateException("The Project Key may not be null");
            }
            if (this.issueType == null) {
                throw new IllegalStateException("The Issue Type may not be null");
            }
            StringFields summary = null;
            StringFields description = null;
            for (AbstractFields field : this.getConfigs()) {
                if (!(field instanceof StringFields)) continue;
                StringFields stringField = (StringFields)field;
                if (stringField.getFieldKey().equals("summary")) {
                    summary = stringField;
                }
                if (!stringField.getFieldKey().equals("description")) continue;
                description = stringField;
            }
            if (summary == null) {
                this.getConfigs().add(JiraTestDataPublisher.JiraTestDataPublisherDescriptor.DEFAULT_SUMMARY_FIELD);
            }
            if (description == null) {
                this.getConfigs().add(JiraTestDataPublisher.JiraTestDataPublisherDescriptor.DEFAULT_DESCRIPTION_FIELD);
            }
            return this;
        }
    }
}

