/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.JiraTestResultReporter;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.ResponseTransformationException;
import com.atlassian.httpclient.api.UnexpectedResponseException;
import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.MetadataRestClient;
import com.atlassian.jira.rest.client.api.OptionalIterable;
import com.atlassian.jira.rest.client.api.ProjectRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Project;
import com.atlassian.jira.rest.client.api.domain.ServerInfo;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.auth.BasicHttpAuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.AsynchronousHttpClientFactory;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixConfiguration;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.junitattachments.GetTestDataMethodObject;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.ClassResult;
import hudson.tasks.junit.PackageResult;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.atlassian.util.concurrent.Promise;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.JiraTestResultReporter.BearerAuthenticationHandler;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraIssueTrigger;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraTestDataRegistry;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraUtils;
import org.jenkinsci.plugins.JiraTestResultReporter.JobConfigMapping;
import org.jenkinsci.plugins.JiraTestResultReporter.MetadataCache;
import org.jenkinsci.plugins.JiraTestResultReporter.TestToIssueMapping;
import org.jenkinsci.plugins.JiraTestResultReporter.config.AbstractFields;
import org.jenkinsci.plugins.JiraTestResultReporter.config.StringFields;
import org.jenkinsci.plugins.JiraTestResultReporter.restclientextensions.FullStatus;
import org.jenkinsci.plugins.JiraTestResultReporter.restclientextensions.JiraRestClientExtension;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class JiraTestDataPublisher
extends TestDataPublisher {
    public static final boolean DEBUG = false;
    private Map<String, Map<String, List<String>>> attachments = new HashMap<String, Map<String, List<String>>>();
    private boolean pipelineInvocation = false;
    private JobConfigMapping.JobConfigEntry jobConfig;

    public List<AbstractFields> getConfigs() {
        return JobConfigMapping.getInstance().getConfig((Job<?, ?>)this.getJobName());
    }

    public String getIssueType() {
        Long issueType = JobConfigMapping.getInstance().getIssueType((Job<?, ?>)this.getJobName());
        if (issueType == null) {
            issueType = 1L;
        }
        return Long.toString(issueType);
    }

    public String getProjectKey() {
        return JobConfigMapping.getInstance().getProjectKey((Job<?, ?>)this.getJobName());
    }

    public boolean getAutoRaiseIssue() {
        return JobConfigMapping.getInstance().getAutoRaiseIssue((Job<?, ?>)this.getJobName());
    }

    public boolean getAutoResolveIssue() {
        return JobConfigMapping.getInstance().getAutoResolveIssue((Job<?, ?>)this.getJobName());
    }

    public boolean getAutoUnlinkIssue() {
        return JobConfigMapping.getInstance().getAutoUnlinkIssue((Job<?, ?>)this.getJobName());
    }

    public boolean getOverrideResolvedIssues() {
        return JobConfigMapping.getInstance().getOverrideResolvedIssues((Job<?, ?>)this.getJobName());
    }

    public boolean getManualAddIssue() {
        return JobConfigMapping.getInstance().getManualAddIssue((Job<?, ?>)this.getJobName());
    }

    public List<String> getAttachments(String className, String name) {
        if (!this.attachments.containsKey(className)) {
            return Collections.emptyList();
        }
        Map<String, List<String>> attachmentsByClassname = this.attachments.get(className);
        if (!attachmentsByClassname.containsKey(name)) {
            return Collections.emptyList();
        }
        return attachmentsByClassname.get(name);
    }

    @CheckForNull
    private AbstractProject<?, ?> getJobName() {
        StaplerRequest2 currentRequest = Stapler.getCurrentRequest2();
        return currentRequest != null ? (AbstractProject)currentRequest.findAncestorObject(AbstractProject.class) : null;
    }

    private boolean isPipelineInvocation() {
        return this.pipelineInvocation;
    }

    private JobConfigMapping.JobConfigEntry getJobConfig() {
        return this.jobConfig;
    }

    @CheckForNull
    public boolean getAdditionalAttachments() {
        return this.jobConfig.getAdditionalAttachments();
    }

    @DataBoundSetter
    public void setAdditionalAttachments(boolean additionalAttachments) {
        JiraUtils.log(String.format("Additional attachments field configured as %s", additionalAttachments));
        this.jobConfig = new JobConfigMapping.JobConfigEntryBuilder().withProjectKey(this.jobConfig.getProjectKey()).withIssueType(this.jobConfig.getIssueType()).withAutoRaiseIssues(this.jobConfig.getAutoRaiseIssue()).withAutoResolveIssues(this.jobConfig.getAutoResolveIssue()).withAutoUnlinkIssues(this.jobConfig.getAutoUnlinkIssue()).withAdditionalAttachments(additionalAttachments).withOverrideResolvedIssues(this.jobConfig.getOverrideResolvedIssues()).withManualAddIssues(this.jobConfig.getManualAddIssue()).withConfigs(this.jobConfig.getConfigs()).build();
    }

    @DataBoundConstructor
    public JiraTestDataPublisher(List<AbstractFields> configs, String projectKey, String issueType, boolean autoRaiseIssue, boolean autoResolveIssue, boolean autoUnlinkIssue, boolean overrideResolvedIssues, boolean manualAddIssue) {
        long defaultIssueType;
        try {
            defaultIssueType = Long.parseLong(issueType);
        }
        catch (NumberFormatException e) {
            defaultIssueType = 1L;
        }
        if (configs == null) {
            configs = new ArrayList<AbstractFields>();
        }
        this.jobConfig = new JobConfigMapping.JobConfigEntryBuilder().withProjectKey(Util.fixNull((String)projectKey)).withIssueType(defaultIssueType).withAutoRaiseIssues(autoRaiseIssue).withAutoResolveIssues(autoResolveIssue).withAutoUnlinkIssues(autoUnlinkIssue).withOverrideResolvedIssues(overrideResolvedIssues).withManualAddIssues(manualAddIssue).withConfigs(Util.fixNull(configs)).build();
        if (Stapler.getCurrentRequest2() != null) {
            AbstractProject project = (AbstractProject)Stapler.getCurrentRequest2().findAncestorObject(AbstractProject.class);
            TestToIssueMapping.getInstance().register((Job<?, ?>)project);
            JobConfigMapping.getInstance().saveConfig((Job<?, ?>)project, this.getJobConfig());
        } else {
            this.pipelineInvocation = true;
        }
    }

    public TestResultAction.Data contributeTestData(Run<?, ?> run, @NonNull FilePath workspace, Launcher launcher, TaskListener listener, TestResult testResult) throws IOException, InterruptedException {
        EnvVars envVars = run.getEnvironment(listener);
        Job job = run.getParent();
        Object project = job instanceof MatrixConfiguration ? ((MatrixConfiguration)job).getParent() : job;
        if (this.isPipelineInvocation()) {
            TestToIssueMapping.getInstance().register((Job<?, ?>)project);
            JobConfigMapping.getInstance().saveConfig((Job<?, ?>)project, this.getJobConfig());
        }
        boolean hasTestData = false;
        if (JobConfigMapping.getInstance().getOverrideResolvedIssues((Job<?, ?>)project)) {
            hasTestData |= this.cleanJobCacheFile(listener, job, this.getTestCaseResults(testResult));
        }
        if (JobConfigMapping.getInstance().getAutoRaiseIssue((Job<?, ?>)project)) {
            if (JobConfigMapping.getInstance().getAdditionalAttachments((Job<?, ?>)project)) {
                JiraUtils.log("Obtaining junit-attachments ...");
                GetTestDataMethodObject methodObject = new GetTestDataMethodObject(run, workspace, launcher, listener, testResult);
                this.attachments = methodObject.getAttachments();
                JiraUtils.log("junit-attachments successfully retrieved");
            }
            hasTestData |= this.raiseIssues(listener, (Job<?, ?>)project, (Job<?, ?>)job, envVars, this.getTestCaseResults(testResult));
        }
        if (JobConfigMapping.getInstance().getAutoResolveIssue((Job<?, ?>)project)) {
            hasTestData |= this.resolveIssues(listener, (Job<?, ?>)project, (Job<?, ?>)job, envVars, this.getTestCaseResults(testResult));
        }
        if (JobConfigMapping.getInstance().getAutoUnlinkIssue((Job<?, ?>)project)) {
            hasTestData |= this.unlinkIssuesForPassedTests(listener, (Job<?, ?>)project, (Job<?, ?>)job, envVars, this.getTestCaseResults(testResult));
        }
        if (JobConfigMapping.getInstance().getManualAddIssue((Job<?, ?>)project)) {
            hasTestData |= true;
        }
        if (hasTestData) {
            if (!this.reportedTestDataBefore(envVars)) {
                JiraTestDataRegistry.getInstance().putJiraTestData(envVars);
                return JiraTestDataRegistry.getInstance().getJiraTestData(envVars);
            }
            return null;
        }
        return null;
    }

    private boolean reportedTestDataBefore(EnvVars envVars) {
        return JiraTestDataRegistry.getInstance().getJiraTestData(envVars) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unlinkIssuesForPassedTests(TaskListener listener, Job<?, ?> project, Job<?, ?> job, EnvVars envVars, List<CaseResult> testCaseResults) {
        boolean unlinked = false;
        for (CaseResult test : testCaseResults) {
            if (!test.isPassed() || TestToIssueMapping.getInstance().getTestIssueKey(job, test.getId()) == null) continue;
            String string = test.getId();
            synchronized (string) {
                String issueKey = TestToIssueMapping.getInstance().getTestIssueKey(job, test.getId());
                TestToIssueMapping.getInstance().removeTestToIssueMapping(job, test.getId(), issueKey);
                unlinked = true;
            }
        }
        return unlinked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean resolveIssues(TaskListener listener, Job<?, ?> project, Job<?, ?> job, EnvVars envVars, List<CaseResult> testCaseResults) {
        boolean solved = false;
        try {
            Iterator<CaseResult> iterator = testCaseResults.iterator();
            while (iterator.hasNext()) {
                CaseResult test = iterator.next();
                if (!test.isPassed() || test.getPreviousResult() == null || !test.getPreviousResult().isFailed()) continue;
                String string = test.getId();
                synchronized (string) {
                    for (String issueKey : JiraUtils.searchIssueKeys(job, envVars, test)) {
                        IssueRestClient issueRestClient = this.getDescriptor().getRestClient().getIssueClient();
                        Issue issue = (Issue)issueRestClient.getIssue(issueKey).claim();
                        boolean transitionExecuted = false;
                        for (Transition transition : (Iterable)issueRestClient.getTransitions(issue).claim()) {
                            if (!transition.getName().toLowerCase().contains("resolve")) continue;
                            issueRestClient.transition(issue, new TransitionInput(transition.getId()));
                            transitionExecuted = true;
                            solved = true;
                            break;
                        }
                        if (transitionExecuted) continue;
                        listener.getLogger().println("Could not find transition to resolve issue " + issueKey);
                    }
                }
            }
            return solved;
        }
        catch (ResponseTransformationException | UnexpectedResponseException | RestClientException e) {
            listener.error("Could not connect properly to Jira server. Please review config details\n");
            e.printStackTrace(listener.getLogger());
            return false;
        }
    }

    private boolean cleanJobCacheFile(TaskListener listener, Job<?, ?> job, List<CaseResult> testCaseResults) {
        boolean cleanUp = false;
        try {
            cleanUp = JiraUtils.cleanJobCacheFile(testCaseResults, job);
        }
        catch (RestClientException e) {
            listener.error("Could not do the clean up of the JiraIssueJobConfigs.json\n");
            e.printStackTrace(listener.getLogger());
            throw e;
        }
        return cleanUp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean raiseIssues(TaskListener listener, Job<?, ?> project, Job<?, ?> job, EnvVars envVars, List<CaseResult> testCaseResults) {
        boolean raised = false;
        try {
            Iterator<CaseResult> iterator = testCaseResults.iterator();
            while (iterator.hasNext()) {
                CaseResult test = iterator.next();
                if (!test.isFailed()) continue;
                try {
                    JiraUtils.createIssue(job, project, envVars, test, JiraIssueTrigger.JOB, this.getAttachments(test.getClassName(), test.getName()));
                    raised = true;
                }
                catch (RestClientException e) {
                    listener.error("Could not create issue for test " + test.getFullDisplayName() + "\n");
                    e.printStackTrace(listener.getLogger());
                    throw e;
                }
            }
            return raised;
        }
        catch (ResponseTransformationException | UnexpectedResponseException | RestClientException e) {
            listener.error("Could not connect properly to Jira server. Please review config details\n");
            e.printStackTrace(listener.getLogger());
            return false;
        }
    }

    private List<CaseResult> getTestCaseResults(TestResult testResult) {
        ArrayList<CaseResult> results = new ArrayList<CaseResult>();
        Collection packageResults = testResult.getChildren();
        for (PackageResult pkgResult : packageResults) {
            Collection classResults = pkgResult.getChildren();
            for (ClassResult cr : classResults) {
                results.addAll(cr.getChildren());
            }
        }
        return results;
    }

    public JiraTestDataPublisherDescriptor getDescriptor() {
        return (JiraTestDataPublisherDescriptor)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    public String getJiraUrl() {
        return this.getDescriptor().getJiraUrl();
    }

    @Symbol(value={"jiraTestResultReporter"})
    @Extension
    public static class JiraTestDataPublisherDescriptor
    extends Descriptor<TestDataPublisher> {
        public static final String SUMMARY_FIELD_NAME = "summary";
        public static final String DESCRIPTION_FIELD_NAME = "description";
        private static final String DEFAULT_SUMMARY = "${TEST_FULL_NAME} : ${TEST_ERROR_DETAILS}";
        private static final String DEFAULT_DESCRIPTION = "${BUILD_URL}${CRLF}${TEST_STACK_TRACE}";
        public static final List<AbstractFields> templates = new ArrayList<AbstractFields>();
        public static final StringFields DEFAULT_SUMMARY_FIELD = new StringFields("summary", "${DEFAULT_SUMMARY}");
        public static final StringFields DEFAULT_DESCRIPTION_FIELD = new StringFields("description", "${DEFAULT_DESCRIPTION}");
        private transient HashMap<String, FullStatus> statuses;
        private transient JiraRestClient restClient;
        private transient JiraRestClientExtension restClientExtension;
        private transient MetadataCache metadataCache = new MetadataCache();
        private URI jiraUri = null;
        private String username = null;
        private Secret password = null;
        private boolean useBearerAuth = false;
        private String defaultSummary;
        private String defaultDescription;

        public JiraTestDataPublisherDescriptor() {
            this.load();
        }

        public URI getJiraUri() {
            return this.jiraUri;
        }

        public String getUsername() {
            return this.username;
        }

        public Secret getPassword() {
            return this.password;
        }

        public boolean getUseBearerAuth() {
            return this.useBearerAuth;
        }

        public String getJiraUrl() {
            return this.jiraUri != null ? this.jiraUri.toString() : null;
        }

        public JiraRestClient getRestClient() {
            return this.restClient;
        }

        public String getDefaultSummary() {
            return this.defaultSummary != null && !this.defaultSummary.equals("") ? this.defaultSummary : DEFAULT_SUMMARY;
        }

        public String getDefaultDescription() {
            return this.defaultDescription != null && !this.defaultDescription.equals("") ? this.defaultDescription : DEFAULT_DESCRIPTION;
        }

        public HashMap<String, FullStatus> getStatusesMap() {
            return this.statuses;
        }

        public MetadataCache.CacheEntry getCacheEntry(String projectKey, String issueType) {
            return this.metadataCache.getCacheEntry(projectKey, issueType);
        }

        public Object readResolve() {
            if (this.jiraUri != null && this.username != null && this.password != null) {
                AsynchronousJiraRestClientFactory factory = new AsynchronousJiraRestClientFactory();
                if (this.useBearerAuth) {
                    BearerAuthenticationHandler handler = new BearerAuthenticationHandler(this.password.getPlainText());
                    this.restClient = factory.create(this.jiraUri, (AuthenticationHandler)handler);
                    this.restClientExtension = new JiraRestClientExtension(this.jiraUri, (HttpClient)new AsynchronousHttpClientFactory().createClient(this.jiraUri, (AuthenticationHandler)new BearerAuthenticationHandler(this.password.getPlainText())));
                } else {
                    this.restClient = factory.createWithBasicHttpAuthentication(this.jiraUri, this.username, this.password.getPlainText());
                    this.restClientExtension = new JiraRestClientExtension(this.jiraUri, (HttpClient)new AsynchronousHttpClientFactory().createClient(this.jiraUri, (AuthenticationHandler)new BasicHttpAuthenticationHandler(this.username, this.password.getPlainText())));
                }
                this.tryCreatingStatusToCategoryMap();
            }
            return this;
        }

        public String getDisplayName() {
            return "JiraTestResultReporter";
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            try {
                this.jiraUri = new URI(json.getString("jiraUrl"));
            }
            catch (URISyntaxException e) {
                JiraUtils.logError("Invalid server URI", e);
            }
            this.username = json.getString("username");
            this.password = Secret.fromString((String)json.getString("password"));
            this.useBearerAuth = json.getBoolean("useBearerAuth");
            this.defaultSummary = json.getString(SUMMARY_FIELD_NAME);
            this.defaultDescription = json.getString(DESCRIPTION_FIELD_NAME);
            if (json.getString("jiraUrl").equals("") || json.getString("username").equals("") || json.getString("password").equals("")) {
                this.useBearerAuth = false;
                this.restClient = null;
                this.restClientExtension = null;
                this.save();
                return true;
            }
            AsynchronousJiraRestClientFactory factory = new AsynchronousJiraRestClientFactory();
            if (this.useBearerAuth) {
                BearerAuthenticationHandler handler = new BearerAuthenticationHandler(this.password.getPlainText());
                this.restClient = factory.create(this.jiraUri, (AuthenticationHandler)handler);
                this.restClientExtension = new JiraRestClientExtension(this.jiraUri, (HttpClient)new AsynchronousHttpClientFactory().createClient(this.jiraUri, (AuthenticationHandler)new BearerAuthenticationHandler(this.password.getPlainText())));
            } else {
                this.restClient = factory.createWithBasicHttpAuthentication(this.jiraUri, this.username, this.password.getPlainText());
                this.restClientExtension = new JiraRestClientExtension(this.jiraUri, (HttpClient)new AsynchronousHttpClientFactory().createClient(this.jiraUri, (AuthenticationHandler)new BasicHttpAuthenticationHandler(this.username, this.password.getPlainText())));
            }
            this.tryCreatingStatusToCategoryMap();
            this.save();
            return super.configure(req, json);
        }

        private void tryCreatingStatusToCategoryMap() {
            try {
                Iterable statuses = (Iterable)this.restClientExtension.getStatuses().claim();
                HashMap<String, FullStatus> statusHashMap = new HashMap<String, FullStatus>();
                for (FullStatus status : statuses) {
                    statusHashMap.put(status.getName(), status);
                }
                this.statuses = statusHashMap;
            }
            catch (RestClientException e) {
                JiraUtils.logWarning("Jira server does not support status categories", (Exception)((Object)e));
            }
        }

        public TestDataPublisher newInstance(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            String projectKey = json.getString("projectKey");
            String issueType = json.getString("issueType");
            this.metadataCache.removeCacheEntry(projectKey, issueType);
            return (TestDataPublisher)super.newInstance(req, json);
        }

        @RequirePOST
        public FormValidation doValidateGlobal(@QueryParameter String jiraUrl, @QueryParameter String username, @QueryParameter String password, @QueryParameter boolean useBearerAuth) {
            String serverName;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                JiraRestClient restClient;
                new URL(jiraUrl);
                URI uri = new URI(jiraUrl);
                if (uri == null) {
                    return FormValidation.error((String)"Invalid URL");
                }
                Secret pass = Secret.fromString((String)password);
                AsynchronousJiraRestClientFactory factory = new AsynchronousJiraRestClientFactory();
                if (useBearerAuth) {
                    BearerAuthenticationHandler handler = new BearerAuthenticationHandler(pass.getPlainText());
                    restClient = factory.create(uri, (AuthenticationHandler)handler);
                } else {
                    restClient = factory.createWithBasicHttpAuthentication(uri, username, pass.getPlainText());
                }
                MetadataRestClient client = restClient.getMetadataClient();
                Promise serverInfoPromise = client.getServerInfo();
                ServerInfo serverInfo = (ServerInfo)serverInfoPromise.claim();
                serverName = serverInfo.getServerTitle();
                String serverVersion = serverInfo.getVersion();
                JiraUtils.logError("INFO: JIRA Version" + serverVersion);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"Invalid URL");
            }
            catch (URISyntaxException e) {
                return FormValidation.error((String)"Invalid URL");
            }
            catch (RestClientException e) {
                JiraUtils.logError("ERROR: Unknown error", (Exception)((Object)e));
                return FormValidation.error((String)("ERROR " + String.valueOf(e.getStatusCode().get())));
            }
            catch (Exception e) {
                JiraUtils.logError("ERROR: Unknown error", e);
                return FormValidation.error((String)("ERROR Unknown: " + e.getMessage()));
            }
            return FormValidation.ok((String)serverName);
        }

        public FormValidation doValidateProjectKey(@QueryParameter String projectKey) {
            Project project;
            if (projectKey == null || projectKey.length() == 0) {
                return FormValidation.error((String)"Invalid Project Key");
            }
            if (this.getRestClient() == null) {
                return FormValidation.error((String)"No jira site configured");
            }
            ProjectRestClient projectClient = this.getRestClient().getProjectClient();
            try {
                project = (Project)projectClient.getProject(projectKey).claim();
                if (project == null) {
                    return FormValidation.error((String)"Invalid Project Key");
                }
            }
            catch (RestClientException e) {
                JiraUtils.logWarning("Invalid Project Key", (Exception)((Object)e));
                return FormValidation.error((String)"Invalid Project Key");
            }
            return FormValidation.ok((String)project.getName());
        }

        public ListBoxModel doFillIssueTypeItems(@QueryParameter String projectKey) {
            ListBoxModel m = new ListBoxModel();
            if (projectKey.equals("")) {
                return m;
            }
            ProjectRestClient projectRestClient = this.getRestClient().getProjectClient();
            try {
                Promise projectPromise = projectRestClient.getProject(projectKey);
                Project project = (Project)projectPromise.claim();
                OptionalIterable issueTypes = project.getIssueTypes();
                for (IssueType issueType : issueTypes) {
                    m.add((Object)new ListBoxModel.Option(issueType.getName(), issueType.getId().toString(), issueType.getName() == "Bug"));
                }
            }
            catch (Exception e) {
                JiraUtils.logError("ERROR: Unknown error", e);
                return m;
            }
            return m;
        }

        @JavaScriptMethod
        public FormValidation validateFieldConfigs(String jsonForm) throws Descriptor.FormException {
            BasicIssue newCreatedIssue;
            StaplerRequest2 req = Stapler.getCurrentRequest2();
            JSONObject jsonObject = JSONObject.fromObject((Object)jsonForm);
            JSONObject publishers = null;
            try {
                publishers = jsonObject.getJSONObject("publisher");
            }
            catch (JSONException e) {
                JiraUtils.log("Error finding key publisher, try with array as format changed");
                JSONArray publisherArray = jsonObject.getJSONArray("publisher");
                block6: for (int i = 0; i < publisherArray.size(); ++i) {
                    JSONObject arrayObject = publisherArray.getJSONObject(i);
                    for (Object o : arrayObject.keySet()) {
                        if (!o.toString().equals("testDataPublishers")) continue;
                        publishers = arrayObject;
                        continue block6;
                    }
                }
            }
            if (publishers == null) {
                return FormValidation.error((String)"publisher object not found in json.\n");
            }
            JSONObject jiraPublisherJSON = null;
            for (Object o : publishers.keySet()) {
                if (!o.toString().equals("testDataPublishers")) continue;
                jiraPublisherJSON = (JSONObject)publishers.get(o);
                break;
            }
            if (jiraPublisherJSON == null) {
                return FormValidation.error((String)"jiraPublisherJSON is null.\n");
            }
            List configs = JiraTestDataPublisherDescriptor.newInstancesFromHeteroList((StaplerRequest2)req, (Object)jiraPublisherJSON.get("configs"), this.getListDescriptors());
            if (configs == null) {
                return FormValidation.ok((String)"OK! No validation done.");
            }
            String projectKey = jiraPublisherJSON.getString("projectKey");
            Long issueType = jiraPublisherJSON.getLong("issueType");
            IssueRestClient issueClient = this.getRestClient().getIssueClient();
            IssueInputBuilder newIssueBuilder = new IssueInputBuilder(projectKey, issueType);
            newIssueBuilder.setSummary("Test summary");
            newIssueBuilder.setDescription("Test Description");
            for (AbstractFields f : configs) {
                newIssueBuilder.setFieldInput(f.getFieldInput(null, null));
            }
            try {
                IssueInput newIssue = newIssueBuilder.build();
                newCreatedIssue = (BasicIssue)issueClient.createIssue(newIssue).claim();
            }
            catch (RestClientException e) {
                JiraUtils.logError("Error when creating issue", (Exception)((Object)e));
                return FormValidation.error((String)JiraUtils.getErrorMessage(e, "\n"));
            }
            try {
                this.restClientExtension.deteleIssue(newCreatedIssue.getKey()).claim();
            }
            catch (RestClientException e) {
                JiraUtils.logError("Error when deleting issue", (Exception)((Object)e));
                return FormValidation.warning((String)JiraUtils.getErrorMessage(e, "\n"));
            }
            return FormValidation.ok((String)"OK!");
        }

        public DescriptorExtensionList<AbstractFields, ?> getListDescriptors() {
            return Jenkins.get().getDescriptorList(AbstractFields.class);
        }

        static {
            templates.add(DEFAULT_SUMMARY_FIELD);
            templates.add(DEFAULT_DESCRIPTION_FIELD);
        }
    }
}

