/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.JiraTestResultReporter;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.Issue;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestAction;
import hudson.util.FormValidation;
import io.atlassian.util.concurrent.Promise;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraIssueTrigger;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraTestData;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraTestDataPublisher;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraUtils;
import org.jenkinsci.plugins.JiraTestResultReporter.JobConfigMapping;
import org.jenkinsci.plugins.JiraTestResultReporter.TestToIssueMapping;
import org.jenkinsci.plugins.JiraTestResultReporter.restclientextensions.FullStatus;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class JiraTestAction
extends TestAction
implements ExtensionPoint,
Describable<JiraTestAction> {
    private String issueKey = null;
    private CaseResult test;
    private JiraTestData testData;
    private String issueStatus;
    private String statusColor;
    private String issueSummary;
    private Job<?, ?> job;
    private Job<?, ?> project = this.initProject();

    public String getIssueStatus() {
        return this.issueStatus;
    }

    public String getStatusColor() {
        return this.statusColor;
    }

    public EnvVars getEnvVars() {
        return this.testData.getEnvVars();
    }

    public CaseResult getTest() {
        return this.test;
    }

    public JiraTestAction(JiraTestData testData, CaseResult test) {
        this.job = this.project instanceof MatrixProject ? (Job)Jenkins.get().getItemByFullName((String)testData.getEnvVars().get((Object)"JOB_NAME")) : this.project;
        if (this.project == null || this.job == null) {
            return;
        }
        this.testData = testData;
        this.test = test;
        Iterator<String> iterator = JiraUtils.searchIssueKeys(this.job, testData.getEnvVars(), test).iterator();
        while (iterator.hasNext()) {
            String key;
            this.issueKey = key = iterator.next();
            IssueRestClient issueRestClient = JiraUtils.getJiraDescriptor().getRestClient().getIssueClient();
            try {
                Issue issue = (Issue)issueRestClient.getIssue(key).claim();
                this.issueStatus = issue.getStatus().getName();
                this.issueSummary = issue.getSummary();
                JiraTestDataPublisher.JiraTestDataPublisherDescriptor jiraDescriptor = JiraUtils.getJiraDescriptor();
                if (jiraDescriptor.getStatusesMap() == null) continue;
                FullStatus status = jiraDescriptor.getStatusesMap().get(this.issueStatus);
                this.statusColor = status != null ? status.getColorName() : null;
            }
            catch (Exception e) {
                JiraUtils.logError("The issue might be deleted, or there is no internet connection, etc.", e);
            }
        }
    }

    private Job<?, ?> initProject() {
        if (Stapler.getCurrentRequest2() == null) {
            return null;
        }
        List ancestors = Stapler.getCurrentRequest2().getAncestors();
        for (Ancestor ancestor : ancestors) {
            if (!(ancestor.getObject() instanceof AbstractProject)) continue;
            return (AbstractProject)ancestor.getObject();
        }
        Job lastAncestor = null;
        for (Ancestor ancestor : ancestors) {
            if (!(ancestor.getObject() instanceof Job)) continue;
            lastAncestor = (Job)ancestor.getObject();
        }
        return lastAncestor;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public String getIssueUrl() {
        return JiraUtils.getIssueURL(JiraUtils.getJiraDescriptor().getJiraUrl(), this.issueKey);
    }

    public boolean isTestFailing() {
        return this.test.isFailed();
    }

    public String getIssueSummary() {
        return this.issueSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JavaScriptMethod
    public FormValidation setIssueKey(String issueKey) {
        String string = this.test.getId();
        synchronized (string) {
            if (TestToIssueMapping.getInstance().getTestIssueKey(this.job, this.test.getId()) != null) {
                return null;
            }
            if (this.isValidIssueKey(issueKey)) {
                this.issueKey = issueKey;
                TestToIssueMapping.getInstance().addTestToIssueMapping(this.job, this.test.getId(), issueKey);
                return null;
            }
            return FormValidation.error((String)"Not a valid issue key");
        }
    }

    @JavaScriptMethod
    public void clearIssueKey() {
        TestToIssueMapping.getInstance().removeTestToIssueMapping(this.job, this.test.getId(), this.issueKey);
        this.issueKey = null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getDisplayName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public Descriptor<JiraTestAction> getDescriptor() {
        return (JiraTestActionDescriptor)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @JavaScriptMethod
    public FormValidation createIssue() {
        try {
            String id = JiraUtils.createIssue(this.job, this.project, this.testData.getEnvVars(), this.test, JiraIssueTrigger.UI, Collections.emptyList());
            return StringUtils.isBlank((CharSequence)id) ? FormValidation.error((String)"Duplicate already exists") : this.setIssueKey(id);
        }
        catch (RestClientException e) {
            JiraUtils.logError("Error when creating issue", (Exception)((Object)e));
            return FormValidation.error((String)JiraUtils.getErrorMessage(e, "\n"));
        }
    }

    public boolean isValidIssueKey(String issueKey) {
        if (!JobConfigMapping.getInstance().getIssueKeyPattern(this.project).matcher(issueKey).matches()) {
            return false;
        }
        IssueRestClient restClient = JiraUtils.getJiraDescriptor().getRestClient().getIssueClient();
        try {
            Promise issuePromise = restClient.getIssue(issueKey);
            issuePromise.claim();
        }
        catch (RestClientException e) {
            JiraUtils.logError("Error when validating issue", (Exception)((Object)e));
            return false;
        }
        return true;
    }

    @Extension
    public static class JiraTestActionDescriptor
    extends Descriptor<JiraTestAction> {
        public String getDisplayName() {
            return this.clazz.getSimpleName();
        }
    }
}

