/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.JiraTestResultReporter.restclientextensions;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import io.atlassian.util.concurrent.Promise;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.jenkinsci.plugins.JiraTestResultReporter.restclientextensions.FullStatus;
import org.jenkinsci.plugins.JiraTestResultReporter.restclientextensions.FullStatusJsonParser;

public class JiraRestClientExtension
extends AbstractAsynchronousRestClient {
    private URI baseUri;

    public JiraRestClientExtension(URI serverUri, HttpClient client) {
        super(client);
        this.baseUri = UriBuilder.fromUri((URI)serverUri).path("/rest/api/latest").build(new Object[0]);
    }

    public Promise<Iterable<FullStatus>> getStatuses() {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri);
        uriBuilder.path("status");
        return this.getAndParse(uriBuilder.build(new Object[0]), (JsonParser)new GenericJsonArrayParser((JsonObjectParser)new FullStatusJsonParser()));
    }

    public Promise<Void> deteleIssue(String issueKey) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri);
        uriBuilder.path("issue").path(issueKey);
        return this.delete(uriBuilder.build(new Object[0]));
    }
}

