/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.JiraTestResultReporter;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.Job;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraUtils;

public class TestToIssueMapping {
    private static TestToIssueMapping instance = new TestToIssueMapping();
    private static final Gson GSON = new Gson();
    private static final String MAP_FILE_NAME = "JiraIssueKeyToTestMap";
    private HashMap<String, HashMap<String, String>> jobsMap = new HashMap();

    public static TestToIssueMapping getInstance() {
        return instance;
    }

    private TestToIssueMapping() {
        for (Job job : Jenkins.get().getItems(Job.class)) {
            this.register(job);
        }
    }

    private void saveMap(Job<?, ?> job, HashMap<String, String> map) {
        try {
            Gson gson = new Gson();
            FileOutputStream fileOut = new FileOutputStream(this.getPathToFileMap(job) + ".json");
            JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)fileOut, "UTF-8"));
            writer.setIndent("  ");
            gson.toJson(map, HashMap.class, writer);
            writer.close();
            fileOut.close();
        }
        catch (Exception e) {
            JiraUtils.log("ERROR: Could not save job map");
        }
    }

    private String getPathToFileMap(Job<?, ?> job) {
        return job.getRootDir().toPath().resolve(MAP_FILE_NAME).toString();
    }

    private HashMap<String, String> loadBackwardsCompatible(Job<?, ?> job) {
        try {
            FileInputStream fileIn = new FileInputStream(this.getPathToFileMap(job));
            ObjectInputStream in = new ObjectInputStream(fileIn);
            HashMap testToIssue = (HashMap)in.readObject();
            JiraUtils.log("Found and successfully loaded issue map from a previous version for job: " + job.getFullName());
            this.saveMap(job, testToIssue);
            in.close();
            fileIn.close();
            return testToIssue;
        }
        catch (FileNotFoundException fileIn) {
        }
        catch (Exception e) {
            JiraUtils.logError("ERROR: Found issue map from a previous version, but was unable to load it for job " + job.getFullName(), e);
        }
        return null;
    }

    private HashMap<String, String> loadMap(Job<?, ?> job) {
        HashMap testToIssue = null;
        try {
            Gson gson = new Gson();
            FileInputStream fileIn = new FileInputStream(this.getPathToFileMap(job) + ".json");
            JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)fileIn, "UTF-8"));
            testToIssue = (HashMap)gson.fromJson(reader, HashMap.class);
            reader.close();
            fileIn.close();
            return testToIssue;
        }
        catch (FileNotFoundException e) {
            testToIssue = this.loadBackwardsCompatible(job);
            if (testToIssue == null) {
                JiraUtils.log("No map found for job " + job.getFullName());
            }
            return testToIssue;
        }
        catch (Exception e) {
            JiraUtils.log("ERROR: Could not load map for job " + job.getFullName());
            e.printStackTrace();
        }
        return new HashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Job<?, ?> job) {
        if (job == null) {
            return;
        }
        if (job instanceof MatrixProject) {
            for (Job child : ((MatrixProject)job).getAllJobs()) {
                if (child instanceof MatrixProject) continue;
                this.register(child);
            }
            return;
        }
        if (this.jobsMap.containsKey(job.getFullName())) {
            return;
        }
        HashMap<String, HashMap<String, String>> hashMap = this.jobsMap;
        synchronized (hashMap) {
            if (this.jobsMap.containsKey(job.getFullName())) {
                return;
            }
            this.jobsMap.put(job.getFullName(), this.loadMap(job));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTestToIssueMapping(Job<?, ?> job, String testId, String issueKey) {
        HashMap<String, String> jobMap = this.jobsMap.get(job.getFullName());
        if (jobMap == null) {
            JiraUtils.log("ERROR: Unregistered job " + job.getFullName());
            this.register(job);
            jobMap = this.jobsMap.get(job.getFullName());
        }
        HashMap<String, String> hashMap = jobMap;
        synchronized (hashMap) {
            jobMap.put(testId, issueKey);
            this.saveMap(job, jobMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTestToIssueMapping(Job<?, ?> job, String testId, String issueKey) {
        HashMap<String, String> jobMap = this.jobsMap.get(job.getFullName());
        if (jobMap == null) {
            JiraUtils.log("ERROR: Unregistered job " + job.getFullName());
            return;
        }
        HashMap<String, String> hashMap = jobMap;
        synchronized (hashMap) {
            if (jobMap.get(testId) != null && jobMap.get(testId).equals(issueKey)) {
                jobMap.remove(testId);
                this.saveMap(job, jobMap);
            }
        }
    }

    public String getTestIssueKey(Job<?, ?> job, String testId) {
        HashMap<String, String> jobMap = this.jobsMap.get(job.getFullName());
        if (jobMap == null) {
            JiraUtils.logWarning("ERROR: Unregistered job " + job.getFullName());
            this.register(job);
            return this.jobsMap.get(job.getFullName()) != null ? this.jobsMap.get(job.getFullName()).get(testId) : null;
        }
        return jobMap.get(testId);
    }

    public JsonElement getMap(MatrixProject matrixProject, String subJobName) {
        MatrixConfiguration job = matrixProject.getItem(subJobName);
        if (job == null) {
            return null;
        }
        return this.getMap((Job<?, ?>)job);
    }

    public JsonElement getMap(MatrixProject matrixProject) {
        JsonObject jsonObject = new JsonObject();
        for (Job job : matrixProject.getAllJobs()) {
            if (matrixProject == job) continue;
            jsonObject.add(job.getName(), this.getMap(job));
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonElement getMap(Job<?, ?> job) {
        if (job instanceof MatrixProject) {
            return this.getMap((MatrixProject)job);
        }
        HashMap<String, String> jobMap = this.jobsMap.get(job.getFullName());
        if (jobMap == null) {
            jobMap = new HashMap();
        }
        HashMap<String, String> hashMap = jobMap;
        synchronized (hashMap) {
            return GSON.toJsonTree(jobMap);
        }
    }
}

