/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.JiraTestResultReporter.config;

import com.atlassian.jira.rest.client.api.IdentifiableEntity;
import com.atlassian.jira.rest.client.api.NamedEntity;
import com.atlassian.jira.rest.client.api.domain.CustomFieldOption;
import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import hudson.EnvVars;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Descriptor;
import hudson.tasks.test.TestResult;
import hudson.util.ListBoxModel;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraTestDataPublisher;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraUtils;
import org.jenkinsci.plugins.JiraTestResultReporter.config.AbstractFields;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SelectableFields
extends AbstractFields {
    public static final long serialVersionUID = 7570781225890517710L;
    private String fieldKey;
    private String value;
    private transient FieldInput fieldInput;

    @DataBoundConstructor
    public SelectableFields(String fieldKey, String value) {
        this.fieldKey = fieldKey;
        this.value = value;
        this.fieldInput = new FieldInput(fieldKey, (Object)ComplexIssueInputFieldValue.with((String)"id", (Object)value));
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public Object readResolve() {
        this.fieldInput = new FieldInput(this.fieldKey, (Object)ComplexIssueInputFieldValue.with((String)"id", (Object)this.value));
        return this;
    }

    public String toString() {
        return this.getClass().getName() + " #" + this.fieldKey + " : " + this.value + "#";
    }

    @Override
    public FieldInput getFieldInput(TestResult test, EnvVars envVars) {
        return this.fieldInput;
    }

    @Symbol(value={"jiraSelectableField"})
    @Extension
    public static class SelectableFieldsDescriptor
    extends Descriptor<AbstractFields> {
        public String getDisplayName() {
            return "Selectable Field";
        }

        public ListBoxModel doFillFieldKeyItems(@QueryParameter @RelativePath(value="..") String projectKey, @QueryParameter @RelativePath(value="..") String issueType) {
            JiraTestDataPublisher.JiraTestDataPublisherDescriptor jiraDescriptor = JiraUtils.getJiraDescriptor();
            try {
                return jiraDescriptor.getCacheEntry(projectKey, issueType).getSelectableFieldBox();
            }
            catch (NullPointerException e) {
                return new ListBoxModel();
            }
        }

        public ListBoxModel doFillValueItems(@QueryParameter @RelativePath(value="..") String projectKey, @QueryParameter @RelativePath(value="..") String issueType, @QueryParameter String fieldKey) {
            ListBoxModel listBox = new ListBoxModel();
            JiraTestDataPublisher.JiraTestDataPublisherDescriptor jiraDescriptor = JiraUtils.getJiraDescriptor();
            try {
                Iterable values = jiraDescriptor.getCacheEntry(projectKey, issueType).getFieldInfoMap().get(fieldKey).getAllowedValues();
                if (values != null) {
                    for (Object o : values) {
                        if (o instanceof CustomFieldOption) {
                            CustomFieldOption option = (CustomFieldOption)o;
                            listBox.add(option.getValue(), option.getId().toString());
                            continue;
                        }
                        if (!(o instanceof IdentifiableEntity) || !(o instanceof NamedEntity)) continue;
                        listBox.add(((NamedEntity)o).getName(), ((Long)((IdentifiableEntity)o).getId()).toString());
                    }
                }
                return listBox;
            }
            catch (NullPointerException e) {
                return listBox;
            }
        }
    }
}

