/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.sshd;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.PageDecorator;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.main.modules.sshd.SSHD;

@Extension
public class PortAdvertiser
extends PageDecorator {
    public String host = System.getProperty(SSHD.class.getName() + ".hostName");
    private static final Logger LOGGER = Logger.getLogger(PortAdvertiser.class.getName());

    @CheckForNull
    public String getEndpoint() {
        try {
            int p = SSHD.get().getActualPort();
            if (p > 0) {
                Jenkins jenkins = Jenkins.get();
                return (this.host != null ? this.host : new URL(jenkins.getRootUrl()).getHost()) + ":" + p;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to advertise SSH port", e);
        }
        return null;
    }
}

