/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.sshd;

import java.time.Duration;
import java.util.logging.Logger;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.SshServer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class IdleTimeout {
    private static final Logger LOGGER = Logger.getLogger(IdleTimeout.class.getName());
    public static final long ADDITIONAL_TIME_FOR_TIMEOUT = 60000L;
    private final Long timeoutInMilliseconds;

    IdleTimeout(Long timeoutInMilliseconds) {
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    public static IdleTimeout fromSystemProperty(String propertyName) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue == null) {
            return new IdleTimeout(null);
        }
        try {
            return new IdleTimeout(Long.parseLong(propertyValue));
        }
        catch (NumberFormatException nfe) {
            LOGGER.warning("SSHD Idle Timeout configuration skipped. " + propertyName + " value (" + propertyValue + ") isn't a long.");
            return new IdleTimeout(null);
        }
    }

    public void apply(SshServer sshd) {
        if (this.timeoutInMilliseconds == null) {
            return;
        }
        CoreModuleProperties.IDLE_TIMEOUT.set((PropertyResolver)sshd, (Object)Duration.ofMillis(this.timeoutInMilliseconds));
        long readTimeout = 0L;
        if (this.timeoutInMilliseconds != 0L) {
            readTimeout = 60000L + this.timeoutInMilliseconds;
        }
        CoreModuleProperties.NIO2_READ_TIMEOUT.set((PropertyResolver)sshd, (Object)Duration.ofSeconds(readTimeout));
    }
}

