/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.sshd;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.util.ServerTcpPort;
import jenkins.util.SystemProperties;
import jenkins.util.Timer;
import net.jcip.annotations.GuardedBy;
import net.sf.json.JSONObject;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.command.CommandFactory;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.jenkinsci.main.modules.sshd.CommandFactoryImpl;
import org.jenkinsci.main.modules.sshd.IdleTimeout;
import org.jenkinsci.main.modules.sshd.PublicKeyAuthenticatorImpl;
import org.jenkinsci.main.modules.sshd.UserAuthNamedFactory;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class SSHD
extends GlobalConfiguration {
    private static final List<NamedFactory<Cipher>> ENABLED_CIPHERS = Arrays.asList(BuiltinCiphers.aes128ctr, BuiltinCiphers.aes192ctr, BuiltinCiphers.aes256ctr);
    private static final String EXCLUDED_KEY_EXCHANGES = SystemProperties.getString((String)(SSHD.class.getName() + ".excludedKeyExchanges"), (String)"diffie-hellman-group-exchange-sha1, diffie-hellman-group14-sha1, diffie-hellman-group1-sha1");
    private static final String EXCLUDED_MACS = SystemProperties.getString((String)(SSHD.class.getName() + ".excludedMacs"), (String)"hmac-md5, hmac-md5-96, hmac-sha1-96");
    @GuardedBy(value="this")
    private transient SshServer sshd;
    private volatile int port = -1;
    public static final String IDLE_TIMEOUT_KEY = "idle-timeout";
    private static final Logger LOGGER = Logger.getLogger(SSHD.class.getName());
    private static Logger MINA_LOGGER = Logger.getLogger("org.apache.sshd");

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public SSHD() {
        this.load();
    }

    public int getPort() {
        return this.port;
    }

    public synchronized int getActualPort() {
        if (this.port == -1) {
            return -1;
        }
        if (this.sshd != null) {
            return this.sshd.getPort();
        }
        return this.port;
    }

    public void setPort(int port) {
        if (this.port != port) {
            this.port = port;
            Timer.get().submit(new Runnable(){

                @Override
                public void run() {
                    SSHD.this.restart();
                }
            });
            this.save();
        }
    }

    @NonNull
    static List<NamedFactory<Cipher>> getActivatedCiphers() {
        ArrayList<NamedFactory<Cipher>> activatedCiphers = new ArrayList<NamedFactory<Cipher>>(ENABLED_CIPHERS.size());
        for (NamedFactory<Cipher> cipher : ENABLED_CIPHERS) {
            if (cipher instanceof BuiltinCiphers) {
                BuiltinCiphers c = (BuiltinCiphers)cipher;
                if (c.isSupported()) {
                    activatedCiphers.add(cipher);
                    continue;
                }
                LOGGER.log(Level.FINE, "Discovered unsupported built-in Cipher: {0}. It will not be enabled", c);
                continue;
            }
            activatedCiphers.add(cipher);
        }
        return activatedCiphers;
    }

    public synchronized void start() throws IOException, InterruptedException {
        int port = this.port;
        if (port < 0) {
            return;
        }
        LOGGER.fine("starting SSHD");
        this.stop();
        this.sshd = SshServer.setUpDefaultServer();
        this.sshd.setUserAuthFactories(Arrays.asList(new UserAuthNamedFactory()));
        this.sshd.setCipherFactories(SSHD.getActivatedCiphers());
        this.sshd.setKeyExchangeFactories(this.filterKeyExchanges(this.sshd.getKeyExchangeFactories()));
        this.sshd.setMacFactories(this.filterMacs(this.sshd.getMacFactories()));
        this.sshd.setPort(port);
        this.sshd.setKeyPairProvider((KeyPairProvider)new AbstractKeyPairProvider(){

            public Iterable<KeyPair> loadKeys(SessionContext session) throws IOException, GeneralSecurityException {
                InstanceIdentity identity = InstanceIdentity.get();
                return Collections.singletonList(new KeyPair(identity.getPublic(), identity.getPrivate()));
            }
        });
        this.sshd.setShellFactory(null);
        this.sshd.setCommandFactory((CommandFactory)new CommandFactoryImpl());
        this.sshd.setPublickeyAuthenticator((PublickeyAuthenticator)new PublicKeyAuthenticatorImpl());
        String idleTimeoutPropertyName = SSHD.class.getName() + ".idle-timeout";
        IdleTimeout.fromSystemProperty(idleTimeoutPropertyName).apply(this.sshd);
        this.sshd.start();
        LOGGER.info("Started SSHD at port " + this.sshd.getPort());
    }

    private List<NamedFactory<Mac>> filterMacs(List<NamedFactory<Mac>> macFactories) {
        if (EXCLUDED_MACS == null || EXCLUDED_MACS.isBlank()) {
            return macFactories;
        }
        List excludedNames = Arrays.stream(EXCLUDED_MACS.split(",")).filter(s -> !s.isBlank()).map(String::trim).collect(Collectors.toList());
        ArrayList<NamedFactory<Mac>> filtered = new ArrayList<NamedFactory<Mac>>();
        for (NamedFactory<Mac> macFactory : macFactories) {
            String name = macFactory.getName();
            if (excludedNames.contains(name)) {
                LOGGER.log(Level.CONFIG, "Excluding " + name);
                continue;
            }
            LOGGER.log(Level.FINE, "Not excluding " + name);
            filtered.add(macFactory);
        }
        return filtered;
    }

    private List<KeyExchangeFactory> filterKeyExchanges(List<KeyExchangeFactory> keyExchangeFactories) {
        if (EXCLUDED_KEY_EXCHANGES == null || EXCLUDED_KEY_EXCHANGES.isBlank()) {
            return keyExchangeFactories;
        }
        List excludedNames = Arrays.stream(EXCLUDED_KEY_EXCHANGES.split(",")).filter(s -> !s.isBlank()).map(String::trim).collect(Collectors.toList());
        ArrayList<KeyExchangeFactory> filtered = new ArrayList<KeyExchangeFactory>();
        for (KeyExchangeFactory keyExchangeNamedFactory : keyExchangeFactories) {
            String name = keyExchangeNamedFactory.getName();
            if (excludedNames.contains(name)) {
                LOGGER.log(Level.CONFIG, "Excluding " + name);
                continue;
            }
            LOGGER.log(Level.FINE, "Not excluding " + name);
            filtered.add(keyExchangeNamedFactory);
        }
        return filtered;
    }

    public synchronized void restart() {
        try {
            if (this.sshd != null) {
                this.sshd.stop(false);
                this.sshd = null;
            }
            this.start();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to restart SSHD", e);
        }
    }

    public synchronized void stop() throws IOException, InterruptedException {
        if (this.sshd != null) {
            this.sshd.stop(true);
            this.sshd = null;
        }
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        this.setPort(new ServerTcpPort(json.getJSONObject("port")).getPort());
        return true;
    }

    public static SSHD get() {
        return (SSHD)((Object)ExtensionList.lookupSingleton(SSHD.class));
    }

    @Initializer(after=InitMilestone.JOB_LOADED, fatal=false)
    public static void init() throws IOException, InterruptedException {
        SSHD.get().start();
    }

    static {
        if (MINA_LOGGER.getLevel() == null) {
            MINA_LOGGER.setLevel(Level.WARNING);
        }
    }
}

