/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.actions;

import hudson.model.Action;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.jcip.annotations.GuardedBy;
import org.jenkins.plugins.lockableresources.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class LockedResourcesBuildAction
implements Action {
    @GuardedBy(value="logs")
    private final List<LogEntry> logs = new ArrayList<LogEntry>();
    @GuardedBy(value="resourcesInUse")
    private final List<String> resourcesInUse = new ArrayList<String>();

    public String getIconFileName() {
        return "symbol-lock-closed";
    }

    public String getDisplayName() {
        return Messages.LockedResourcesBuildAction_displayName();
    }

    public String getUrlName() {
        return "locked-resources";
    }

    public List<String> getCurrentUsedResourceNames() {
        return this.resourcesInUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUsedResources(List<String> resourceNames) {
        List<String> list = this.resourcesInUse;
        synchronized (list) {
            this.resourcesInUse.addAll(resourceNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUsedResources(List<String> resourceNames) {
        List<String> list = this.resourcesInUse;
        synchronized (list) {
            this.resourcesInUse.removeAll(resourceNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LockedResourcesBuildAction findAndInitAction(Run<?, ?> build) {
        LockedResourcesBuildAction action;
        String lock;
        if (build == null) {
            return null;
        }
        String string = lock = build.getId();
        synchronized (string) {
            List actions = build.getActions(LockedResourcesBuildAction.class);
            if (actions.isEmpty()) {
                action = new LockedResourcesBuildAction();
                build.addAction((Action)action);
            } else {
                action = (LockedResourcesBuildAction)actions.get(0);
            }
        }
        return action;
    }

    public static void addLog(Run<?, ?> build, List<String> resourceNames, String step, String action) {
        for (String resourceName : resourceNames) {
            LockedResourcesBuildAction.addLog(build, resourceName, step, action);
        }
    }

    public static void addLog(Run<?, ?> build, String resourceName, String step, String action) {
        LockedResourcesBuildAction buildAction = LockedResourcesBuildAction.findAndInitAction(build);
        buildAction.addLog(resourceName, step, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLog(String resourceName, String step, String action) {
        List<LogEntry> list = this.logs;
        synchronized (list) {
            this.logs.add(new LogEntry(step, action, resourceName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    public List<LogEntry> getReadOnlyLogs() {
        List<LogEntry> list = this.logs;
        synchronized (list) {
            return new ArrayList<LogEntry>(Collections.unmodifiableCollection(this.logs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    public List<String> getReadOnlyResourcesInUse() {
        List<String> list = this.resourcesInUse;
        synchronized (list) {
            return new ArrayList<String>(Collections.unmodifiableCollection(this.resourcesInUse));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object writeReplace() {
        LockedResourcesBuildAction lockedResourcesBuildAction = this;
        synchronized (lockedResourcesBuildAction) {
            LockedResourcesBuildAction toSave = new LockedResourcesBuildAction();
            toSave.logs.addAll(this.getReadOnlyLogs());
            toSave.resourcesInUse.addAll(this.getReadOnlyResourcesInUse());
            return toSave;
        }
    }

    public static class LogEntry {
        private final String step;
        private final String action;
        private final String resourceName;
        private final long timeStamp;

        @Restricted(value={NoExternalUse.class})
        public LogEntry(String step, String action, String resourceName) {
            this.step = step;
            this.action = action;
            this.resourceName = resourceName;
            this.timeStamp = new Date().getTime();
        }

        @Restricted(value={NoExternalUse.class})
        public String getName() {
            return this.resourceName;
        }

        @Restricted(value={NoExternalUse.class})
        public String getStep() {
            return this.step;
        }

        @Restricted(value={NoExternalUse.class})
        public String getAction() {
            return this.action;
        }

        @Restricted(value={NoExternalUse.class})
        public Date getTimeStamp() {
            return new Date(this.timeStamp);
        }
    }
}

