// CHECKSTYLE:OFF

package org.jenkins.plugins.lockableresources;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code LockableResourcesRootAction.StealPermission.Description}:

     * {@code This permission grants the ability to manually "steal"

     * resources that have been locked by builds or "reassign" those reserved

     * by users.}.
     * 
     * @return
     *     {@code This permission grants the ability to manually "steal"

     *     resources that have been locked by builds or "reassign" those reserved

     *     by users.}
     */
    public static String LockableResourcesRootAction_StealPermission_Description() {
        return holder.format("LockableResourcesRootAction.StealPermission.Description");
    }

    /**
     * Key {@code LockableResourcesRootAction.StealPermission.Description}:

     * {@code This permission grants the ability to manually "steal"

     * resources that have been locked by builds or "reassign" those reserved

     * by users.}.
     * 
     * @return
     *     {@code This permission grants the ability to manually "steal"

     *     resources that have been locked by builds or "reassign" those reserved

     *     by users.}
     */
    public static Localizable _LockableResourcesRootAction_StealPermission_Description() {
        return new Localizable(holder, "LockableResourcesRootAction.StealPermission.Description");
    }

    /**
     * Key {@code error.labelDoesNotExist}: {@code The resource label does

     * not exist: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The resource label does not exist: {0}.}
     */
    public static String error_labelDoesNotExist(Object arg0) {
        return holder.format("error.labelDoesNotExist", arg0);
    }

    /**
     * Key {@code error.labelDoesNotExist}: {@code The resource label does

     * not exist: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The resource label does not exist: {0}.}
     */
    public static Localizable _error_labelDoesNotExist(Object arg0) {
        return new Localizable(holder, "error.labelDoesNotExist", arg0);
    }

    /**
     * Key {@code LockedResourcesBuildAction.displayName}: {@code Lockable

     * resources}.
     * 
     * @return
     *     {@code Lockable resources}
     */
    public static String LockedResourcesBuildAction_displayName() {
        return holder.format("LockedResourcesBuildAction.displayName");
    }

    /**
     * Key {@code LockedResourcesBuildAction.displayName}: {@code Lockable

     * resources}.
     * 
     * @return
     *     {@code Lockable resources}
     */
    public static Localizable _LockedResourcesBuildAction_displayName() {
        return new Localizable(holder, "LockedResourcesBuildAction.displayName");
    }

    /**
     * Key {@code error.inversePrecedenceAndPriorityAreSet}: {@code The

     * "inverse precedence" option is not compatible with "queue priority"

     * option!}.
     * 
     * @return
     *     {@code The "inverse precedence" option is not compatible with "queue

     *     priority" option!}
     */
    public static String error_inversePrecedenceAndPriorityAreSet() {
        return holder.format("error.inversePrecedenceAndPriorityAreSet");
    }

    /**
     * Key {@code error.inversePrecedenceAndPriorityAreSet}: {@code The

     * "inverse precedence" option is not compatible with "queue priority"

     * option!}.
     * 
     * @return
     *     {@code The "inverse precedence" option is not compatible with "queue

     *     priority" option!}
     */
    public static Localizable _error_inversePrecedenceAndPriorityAreSet() {
        return new Localizable(holder, "error.inversePrecedenceAndPriorityAreSet");
    }

    /**
     * Key {@code LockableResourcesManager.displayName}: {@code External

     * Resources}.
     * 
     * @return
     *     {@code External Resources}
     */
    public static String LockableResourcesManager_displayName() {
        return holder.format("LockableResourcesManager.displayName");
    }

    /**
     * Key {@code LockableResourcesManager.displayName}: {@code External

     * Resources}.
     * 
     * @return
     *     {@code External Resources}
     */
    public static Localizable _LockableResourcesManager_displayName() {
        return new Localizable(holder, "LockableResourcesManager.displayName");
    }

    /**
     * Key {@code error.givenAmountIsGreaterThatResourcesAmount}: {@code

     * Given amount %d is greater than amount of resources: %d.}.
     * 
     * @return
     *     {@code Given amount %d is greater than amount of resources: %d.}
     */
    public static String error_givenAmountIsGreaterThatResourcesAmount() {
        return holder.format("error.givenAmountIsGreaterThatResourcesAmount");
    }

    /**
     * Key {@code error.givenAmountIsGreaterThatResourcesAmount}: {@code

     * Given amount %d is greater than amount of resources: %d.}.
     * 
     * @return
     *     {@code Given amount %d is greater than amount of resources: %d.}
     */
    public static Localizable _error_givenAmountIsGreaterThatResourcesAmount() {
        return new Localizable(holder, "error.givenAmountIsGreaterThatResourcesAmount");
    }

    /**
     * Key {@code RequiredResourcesProperty.displayName}: {@code Required

     * Lockable Resources}.
     * 
     * @return
     *     {@code Required Lockable Resources}
     */
    public static String RequiredResourcesProperty_displayName() {
        return holder.format("RequiredResourcesProperty.displayName");
    }

    /**
     * Key {@code RequiredResourcesProperty.displayName}: {@code Required

     * Lockable Resources}.
     * 
     * @return
     *     {@code Required Lockable Resources}
     */
    public static Localizable _RequiredResourcesProperty_displayName() {
        return new Localizable(holder, "RequiredResourcesProperty.displayName");
    }

    /**
     * Key {@code LockStep.displayName}: {@code Lock shared resource}.
     * 
     * @return
     *     {@code Lock shared resource}
     */
    public static String LockStep_displayName() {
        return holder.format("LockStep.displayName");
    }

    /**
     * Key {@code LockStep.displayName}: {@code Lock shared resource}.
     * 
     * @return
     *     {@code Lock shared resource}
     */
    public static Localizable _LockStep_displayName() {
        return new Localizable(holder, "LockStep.displayName");
    }

    /**
     * Key {@code LockableResourcesRootAction.UnlockPermission.Description}:

     * {@code This permission grants the ability to manually unlock resources

     * that have been locked by builds.}.
     * 
     * @return
     *     {@code This permission grants the ability to manually unlock resources

     *     that have been locked by builds.}
     */
    public static String LockableResourcesRootAction_UnlockPermission_Description() {
        return holder.format("LockableResourcesRootAction.UnlockPermission.Description");
    }

    /**
     * Key {@code LockableResourcesRootAction.UnlockPermission.Description}:

     * {@code This permission grants the ability to manually unlock resources

     * that have been locked by builds.}.
     * 
     * @return
     *     {@code This permission grants the ability to manually unlock resources

     *     that have been locked by builds.}
     */
    public static Localizable _LockableResourcesRootAction_UnlockPermission_Description() {
        return new Localizable(holder, "LockableResourcesRootAction.UnlockPermission.Description");
    }

    /**
     * Key {@code error.resourceDoesNotExist}: {@code The resource does not

     * exist: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The resource does not exist: {0}.}
     */
    public static String error_resourceDoesNotExist(Object arg0) {
        return holder.format("error.resourceDoesNotExist", arg0);
    }

    /**
     * Key {@code error.resourceDoesNotExist}: {@code The resource does not

     * exist: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The resource does not exist: {0}.}
     */
    public static Localizable _error_resourceDoesNotExist(Object arg0) {
        return new Localizable(holder, "error.resourceDoesNotExist", arg0);
    }

    /**
     * Key {@code LockableResourcesRootAction.PermissionGroup}: {@code

     * Lockable Resources}.
     * 
     * @return
     *     {@code Lockable Resources}
     */
    public static String LockableResourcesRootAction_PermissionGroup() {
        return holder.format("LockableResourcesRootAction.PermissionGroup");
    }

    /**
     * Key {@code LockableResourcesRootAction.PermissionGroup}: {@code

     * Lockable Resources}.
     * 
     * @return
     *     {@code Lockable Resources}
     */
    public static Localizable _LockableResourcesRootAction_PermissionGroup() {
        return new Localizable(holder, "LockableResourcesRootAction.PermissionGroup");
    }

    /**
     * Key {@code error.resourceAlreadyLocked}: {@code Resource {0} already

     * reserved or locked!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Resource {0} already reserved or locked!}
     */
    public static String error_resourceAlreadyLocked(Object arg0) {
        return holder.format("error.resourceAlreadyLocked", arg0);
    }

    /**
     * Key {@code error.resourceAlreadyLocked}: {@code Resource {0} already

     * reserved or locked!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Resource {0} already reserved or locked!}
     */
    public static Localizable _error_resourceAlreadyLocked(Object arg0) {
        return new Localizable(holder, "error.resourceAlreadyLocked", arg0);
    }

    /**
     * Key {@code error.labelOrNameMustBeSpecified}: {@code Either resource

     * label or resource name must be specified.}.
     * 
     * @return
     *     {@code Either resource label or resource name must be specified.}
     */
    public static String error_labelOrNameMustBeSpecified() {
        return holder.format("error.labelOrNameMustBeSpecified");
    }

    /**
     * Key {@code error.labelOrNameMustBeSpecified}: {@code Either resource

     * label or resource name must be specified.}.
     * 
     * @return
     *     {@code Either resource label or resource name must be specified.}
     */
    public static Localizable _error_labelOrNameMustBeSpecified() {
        return new Localizable(holder, "error.labelOrNameMustBeSpecified");
    }

    /**
     * Key {@code error.invalidResourceSelectionStrategy}: {@code The

     * strategy "{0}" is not supported. Valid options are {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The strategy "{0}" is not supported. Valid options are {1}.}
     */
    public static String error_invalidResourceSelectionStrategy(Object arg0, Object arg1) {
        return holder.format("error.invalidResourceSelectionStrategy", arg0, arg1);
    }

    /**
     * Key {@code error.invalidResourceSelectionStrategy}: {@code The

     * strategy "{0}" is not supported. Valid options are {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The strategy "{0}" is not supported. Valid options are {1}.}
     */
    public static Localizable _error_invalidResourceSelectionStrategy(Object arg0, Object arg1) {
        return new Localizable(holder, "error.invalidResourceSelectionStrategy", arg0, arg1);
    }

    /**
     * Key {@code error.queuePositionOutOfRange}: {@code The queue position

     * {0} is out of range (1 - {1})!}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The queue position {0} is out of range (1 - {1})!}
     */
    public static String error_queuePositionOutOfRange(Object arg0, Object arg1) {
        return holder.format("error.queuePositionOutOfRange", arg0, arg1);
    }

    /**
     * Key {@code error.queuePositionOutOfRange}: {@code The queue position

     * {0} is out of range (1 - {1})!}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The queue position {0} is out of range (1 - {1})!}
     */
    public static Localizable _error_queuePositionOutOfRange(Object arg0, Object arg1) {
        return new Localizable(holder, "error.queuePositionOutOfRange", arg0, arg1);
    }

    /**
     * Key {@code error.isNotANumber}: {@code The queue position must be a

     * number. Given: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The queue position must be a number. Given: {0}}
     */
    public static String error_isNotANumber(Object arg0) {
        return holder.format("error.isNotANumber", arg0);
    }

    /**
     * Key {@code error.isNotANumber}: {@code The queue position must be a

     * number. Given: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The queue position must be a number. Given: {0}}
     */
    public static Localizable _error_isNotANumber(Object arg0) {
        return new Localizable(holder, "error.isNotANumber", arg0);
    }

    /**
     * Key {@code LockStepResource.displayName}: {@code Resource}.
     * 
     * @return
     *     {@code Resource}
     */
    public static String LockStepResource_displayName() {
        return holder.format("LockStepResource.displayName");
    }

    /**
     * Key {@code LockStepResource.displayName}: {@code Resource}.
     * 
     * @return
     *     {@code Resource}
     */
    public static Localizable _LockStepResource_displayName() {
        return new Localizable(holder, "LockStepResource.displayName");
    }

    /**
     * Key {@code LockableResource.displayName}: {@code Resource}.
     * 
     * @return
     *     {@code Resource}
     */
    public static String LockableResource_displayName() {
        return holder.format("LockableResource.displayName");
    }

    /**
     * Key {@code LockableResource.displayName}: {@code Resource}.
     * 
     * @return
     *     {@code Resource}
     */
    public static Localizable _LockableResource_displayName() {
        return new Localizable(holder, "LockableResource.displayName");
    }

    /**
     * Key {@code LockableResourcesRootAction.ViewPermission.Description}:

     * {@code This permission grants the ability to view lockable

     * resources.}.
     * 
     * @return
     *     {@code This permission grants the ability to view lockable resources.}
     */
    public static String LockableResourcesRootAction_ViewPermission_Description() {
        return holder.format("LockableResourcesRootAction.ViewPermission.Description");
    }

    /**
     * Key {@code LockableResourcesRootAction.ViewPermission.Description}:

     * {@code This permission grants the ability to view lockable

     * resources.}.
     * 
     * @return
     *     {@code This permission grants the ability to view lockable resources.}
     */
    public static Localizable _LockableResourcesRootAction_ViewPermission_Description() {
        return new Localizable(holder, "LockableResourcesRootAction.ViewPermission.Description");
    }

    /**
     * Key {@code error.labelAndNameSpecified}: {@code Resource label and

     * resource name cannot be specified simultaneously.}.
     * 
     * @return
     *     {@code Resource label and resource name cannot be specified

     *     simultaneously.}
     */
    public static String error_labelAndNameSpecified() {
        return holder.format("error.labelAndNameSpecified");
    }

    /**
     * Key {@code error.labelAndNameSpecified}: {@code Resource label and

     * resource name cannot be specified simultaneously.}.
     * 
     * @return
     *     {@code Resource label and resource name cannot be specified

     *     simultaneously.}
     */
    public static Localizable _error_labelAndNameSpecified() {
        return new Localizable(holder, "error.labelAndNameSpecified");
    }

    /**
     * Key {@code error.labelAndNameOrGroovySpecified}: {@code Only resource

     * label, groovy expression, or resource names can be defined, not more

     * than one.}.
     * 
     * @return
     *     {@code Only resource label, groovy expression, or resource names can

     *     be defined, not more than one.}
     */
    public static String error_labelAndNameOrGroovySpecified() {
        return holder.format("error.labelAndNameOrGroovySpecified");
    }

    /**
     * Key {@code error.labelAndNameOrGroovySpecified}: {@code Only resource

     * label, groovy expression, or resource names can be defined, not more

     * than one.}.
     * 
     * @return
     *     {@code Only resource label, groovy expression, or resource names can

     *     be defined, not more than one.}
     */
    public static Localizable _error_labelAndNameOrGroovySpecified() {
        return new Localizable(holder, "error.labelAndNameOrGroovySpecified");
    }

    /**
     * Key {@code error.queueDoesNotExist}: {@code The queue {0} does not

     * (anymore) exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The queue {0} does not (anymore) exist.}
     */
    public static String error_queueDoesNotExist(Object arg0) {
        return holder.format("error.queueDoesNotExist", arg0);
    }

    /**
     * Key {@code error.queueDoesNotExist}: {@code The queue {0} does not

     * (anymore) exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The queue {0} does not (anymore) exist.}
     */
    public static Localizable _error_queueDoesNotExist(Object arg0) {
        return new Localizable(holder, "error.queueDoesNotExist", arg0);
    }

    /**
     * Key {@code LockableResourcesRootAction.ReservePermission.Description}:

     * {@code This permission grants the ability to manually reserve lockable

     * resources outside of a build.}.
     * 
     * @return
     *     {@code This permission grants the ability to manually reserve lockable

     *     resources outside of a build.}
     */
    public static String LockableResourcesRootAction_ReservePermission_Description() {
        return holder.format("LockableResourcesRootAction.ReservePermission.Description");
    }

    /**
     * Key {@code LockableResourcesRootAction.ReservePermission.Description}:

     * {@code This permission grants the ability to manually reserve lockable

     * resources outside of a build.}.
     * 
     * @return
     *     {@code This permission grants the ability to manually reserve lockable

     *     resources outside of a build.}
     */
    public static Localizable _LockableResourcesRootAction_ReservePermission_Description() {
        return new Localizable(holder, "LockableResourcesRootAction.ReservePermission.Description");
    }

    /**
     * Key {@code

     * LockableResourcesRootAction.QueueChangeOrderPermission.Description}:

     * {@code This permission grants the ability to manually manipulate the

     * lockable resources queue..}.
     * 
     * @return
     *     {@code This permission grants the ability to manually manipulate the

     *     lockable resources queue..}
     */
    public static String LockableResourcesRootAction_QueueChangeOrderPermission_Description() {
        return holder.format("LockableResourcesRootAction.QueueChangeOrderPermission.Description");
    }

    /**
     * Key {@code

     * LockableResourcesRootAction.QueueChangeOrderPermission.Description}:

     * {@code This permission grants the ability to manually manipulate the

     * lockable resources queue..}.
     * 
     * @return
     *     {@code This permission grants the ability to manually manipulate the

     *     lockable resources queue..}
     */
    public static Localizable _LockableResourcesRootAction_QueueChangeOrderPermission_Description() {
        return new Localizable(holder, "LockableResourcesRootAction.QueueChangeOrderPermission.Description");
    }

    /**
     * Key {@code error.couldNotParseToint}: {@code Could not parse the given

     * value as integer.}.
     * 
     * @return
     *     {@code Could not parse the given value as integer.}
     */
    public static String error_couldNotParseToint() {
        return holder.format("error.couldNotParseToint");
    }

    /**
     * Key {@code error.couldNotParseToint}: {@code Could not parse the given

     * value as integer.}.
     * 
     * @return
     *     {@code Could not parse the given value as integer.}
     */
    public static Localizable _error_couldNotParseToint() {
        return new Localizable(holder, "error.couldNotParseToint");
    }

}
