/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import hudson.init.InitMilestone;
import hudson.init.Initializer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkins.plugins.lockableresources.ExcludeFromJacocoGeneratedReport;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;

@ExcludeFromJacocoGeneratedReport
public final class FreeDeadJobs {
    private static final Logger LOG = Logger.getLogger(FreeDeadJobs.class.getName());

    private FreeDeadJobs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void freePostMortemResources() {
        LockableResourcesManager lrm = LockableResourcesManager.get();
        Object object = LockableResourcesManager.syncResources;
        synchronized (object) {
            ArrayList<LockableResource> orphan = new ArrayList<LockableResource>();
            LOG.log(Level.FINE, "lockable-resources-plugin free post mortem task run");
            for (LockableResource resource : lrm.getResources()) {
                if (resource.getBuild() == null || resource.getBuild().isInProgress()) continue;
                orphan.add(resource);
            }
            for (LockableResource resource : orphan) {
                LOG.log(Level.INFO, "lockable-resources-plugin reset resource " + resource.getName() + " due post mortem job: " + resource.getBuildName());
                resource.recycle();
            }
        }
    }
}

