/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkins.plugins.lockableresources.LockStepExecution;
import org.jenkins.plugins.lockableresources.LockStepResource;
import org.jenkins.plugins.lockableresources.Messages;
import org.jenkins.plugins.lockableresources.RequiredResourcesProperty;
import org.jenkins.plugins.lockableresources.ResourceSelectStrategy;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class LockStep
extends Step
implements Serializable {
    private static final Logger LOG = Logger.getLogger(LockStep.class.getName());
    private static final long serialVersionUID = -953609907239674360L;
    @CheckForNull
    public String resource = null;
    @CheckForNull
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public String label = null;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public int quantity = 0;
    @CheckForNull
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public String variable = null;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public boolean inversePrecedence = false;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public String resourceSelectStrategy = ResourceSelectStrategy.SEQUENTIAL.name();
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public boolean skipIfLocked = false;
    @CheckForNull
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public List<LockStepResource> extra = null;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public int priority = 0;

    @DataBoundConstructor
    public LockStep(@Nullable String resource) {
        if (resource != null && !resource.trim().isEmpty()) {
            if (!resource.equals(resource.trim())) {
                LOG.warning("The provided 'resource' should not start or end with spaces.");
            }
            this.resource = resource.trim();
        }
    }

    @DataBoundSetter
    public void setInversePrecedence(boolean inversePrecedence) {
        this.inversePrecedence = inversePrecedence;
    }

    @DataBoundSetter
    public void setResourceSelectStrategy(String resourceSelectStrategy) {
        if (resourceSelectStrategy != null && !resourceSelectStrategy.isEmpty()) {
            this.resourceSelectStrategy = resourceSelectStrategy;
        }
    }

    @DataBoundSetter
    public void setSkipIfLocked(boolean skipIfLocked) {
        this.skipIfLocked = skipIfLocked;
    }

    @DataBoundSetter
    public void setLabel(String label) {
        if (label != null && !label.trim().isEmpty()) {
            if (!label.equals(label.trim())) {
                LOG.warning("The provided 'label' should not start or end with spaces.");
            }
            this.label = label.trim();
        }
    }

    @DataBoundSetter
    public void setVariable(String variable) {
        if (variable != null && !variable.trim().isEmpty()) {
            if (!variable.equals(variable.trim())) {
                LOG.warning("The provided 'variable' should not start or end with spaces.");
            }
            this.variable = variable.trim();
        }
    }

    @DataBoundSetter
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    @DataBoundSetter
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @DataBoundSetter
    public void setExtra(@CheckForNull List<LockStepResource> extra) {
        this.extra = extra;
    }

    public String toString() {
        if (this.extra != null && !this.extra.isEmpty()) {
            return this.getResources().stream().map(res -> "{" + res.toString() + "}").collect(Collectors.joining(","));
        }
        if (this.resource != null || this.label != null) {
            Object ret = LockStepResource.toString(this.resource, this.label, this.quantity);
            if (this.priority != 0) {
                ret = (String)ret + ", Priority: " + this.priority;
            }
            return ret;
        }
        return "nothing";
    }

    public void validate(boolean allowEmptyOrNullValues) {
        LockStepResource.validate(this.resource, this.label, this.resourceSelectStrategy, this.extra, this.priority, this.inversePrecedence, allowEmptyOrNullValues);
    }

    public List<LockStepResource> getResources() {
        ArrayList<LockStepResource> resources = new ArrayList<LockStepResource>();
        if (this.resource != null || this.label != null) {
            resources.add(new LockStepResource(this.resource, this.label, this.quantity));
        }
        if (this.extra != null) {
            resources.addAll(this.extra);
        }
        return resources;
    }

    public StepExecution start(StepContext context) {
        return new LockStepExecution(this, context);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "lock";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.LockStep_displayName();
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        @RequirePOST
        public AutoCompletionCandidates doAutoCompleteResource(@QueryParameter String value, @AncestorInPath Item item) {
            return RequiredResourcesProperty.DescriptorImpl.doAutoCompleteResourceNames(value, item);
        }

        @RequirePOST
        public ListBoxModel doFillResourceSelectStrategyItems() {
            ListBoxModel items = new ListBoxModel();
            for (ResourceSelectStrategy resSelStrategy : ResourceSelectStrategy.values()) {
                items.add(resSelStrategy.name());
            }
            return items;
        }

        @RequirePOST
        public static FormValidation doCheckLabel(@QueryParameter String value, @QueryParameter String resource, @AncestorInPath Item item) {
            return LockStepResource.DescriptorImpl.doCheckLabel(value, resource, item);
        }

        @RequirePOST
        public static FormValidation doCheckResource(@QueryParameter String value, @QueryParameter String label, @AncestorInPath Item item) {
            return LockStepResource.DescriptorImpl.doCheckLabel(label, value, item);
        }

        @RequirePOST
        public static FormValidation doCheckResourceSelectStrategy(@QueryParameter String resourceSelectStrategy, @AncestorInPath Item item) {
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
            } else {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            }
            if (resourceSelectStrategy != null && !resourceSelectStrategy.isEmpty()) {
                try {
                    ResourceSelectStrategy.valueOf(resourceSelectStrategy.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    return FormValidation.error((String)Messages.error_invalidResourceSelectionStrategy(resourceSelectStrategy, Arrays.stream(ResourceSelectStrategy.values()).map(Enum::toString).map(strategy -> strategy.toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(", "))));
                }
            }
            return FormValidation.ok();
        }

        public Set<Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }
    }
}

