/*
 * Decompiled with CFR 0.152.
 */
package net.plavcak.jenkins.plugins.scmskip;

import hudson.Extension;
import hudson.model.listeners.RunListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.plavcak.jenkins.plugins.scmskip.SCMSkipTools;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension
public class SCMSkipWorkflowRunListener
extends RunListener<WorkflowRun> {
    private static final Logger LOGGER = Logger.getLogger(SCMSkipWorkflowRunListener.class.getName());

    public void onFinalized(WorkflowRun workflowRun) {
        try {
            if (SCMSkipTools.isBuildToDelete(workflowRun)) {
                LOGGER.log(Level.FINE, () -> "Deleting build: " + workflowRun.getId());
                SCMSkipTools.deleteRun(workflowRun);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "SCM Skip Run Listener", e);
        }
    }
}

