/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.jenkins;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import jenkins.tasks.SimpleBuildStep;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.Reportable;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.presentation.PresentationMode;
import net.masterthought.cucumber.reducers.ReducingMethod;
import net.masterthought.cucumber.sorting.SortingMethod;
import net.masterthought.jenkins.CucumberReportDescriptor;
import net.masterthought.jenkins.Messages;
import net.masterthought.jenkins.SafeArchiveServingRunAction;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CucumberReportPublisher
extends Recorder
implements SimpleBuildStep {
    private static final String DEFAULT_FILE_INCLUDE_PATTERN_JSONS = "**/*.json";
    private static final String DEFAULT_FILE_INCLUDE_PATTERN_CLASSIFICATIONS = "**/*.properties";
    private static final String TRENDS_DIR = "cucumber-reports";
    private static final String TRENDS_FILE = "cucumber-trends.json";
    private final String fileIncludePattern;
    private String fileExcludePattern = "";
    private String jsonReportDirectory = "";
    private String reportTitle = "";
    private int failedStepsNumber;
    private int skippedStepsNumber;
    private int pendingStepsNumber;
    private int undefinedStepsNumber;
    private int failedScenariosNumber;
    private int failedFeaturesNumber;
    private double failedStepsPercentage;
    private double skippedStepsPercentage;
    private double pendingStepsPercentage;
    private double undefinedStepsPercentage;
    private double failedScenariosPercentage;
    private double failedFeaturesPercentage;
    private String buildStatus;
    private boolean stopBuildOnFailedReport;
    private boolean failedAsNotFailingStatus;
    private boolean skippedAsNotFailingStatus;
    private boolean pendingAsNotFailingStatus;
    private boolean undefinedAsNotFailingStatus;
    private int trendsLimit;
    private String sortingMethod;
    private List<Classification> classifications;
    private String customJsFiles;
    private String customCssFiles;
    private boolean mergeFeaturesById;
    private boolean mergeFeaturesWithRetest;
    private boolean hideEmptyHooks;
    private boolean skipEmptyJSONFiles;
    private boolean expandAllSteps;
    private String classificationsFilePattern = "";
    private int maxStreamStringLength;

    @DataBoundConstructor
    public CucumberReportPublisher(String fileIncludePattern) {
        this.fileIncludePattern = fileIncludePattern;
    }

    protected void keepBackwardCompatibility() {
        if (this.classifications == null) {
            this.classifications = new ArrayList<Classification>();
        }
        if (this.sortingMethod == null) {
            this.sortingMethod = SortingMethod.NATURAL.name();
        }
        this.reportTitle = StringUtils.defaultString((String)this.reportTitle);
    }

    private static void log(TaskListener listener, String message) {
        listener.getLogger().println("[CucumberReport] " + message);
    }

    public String getFileIncludePattern() {
        return this.fileIncludePattern;
    }

    public List<Classification> getClassifications() {
        return this.classifications;
    }

    @DataBoundSetter
    public void setClassifications(List<Classification> classifications) {
        if (CollectionUtils.isNotEmpty(classifications)) {
            this.classifications = classifications;
        }
    }

    @DataBoundSetter
    public void setCustomJsFiles(String customJsFiles) {
        this.customJsFiles = customJsFiles;
    }

    public String getCustomJsFiles() {
        return this.customJsFiles;
    }

    @DataBoundSetter
    public void setCustomCssFiles(String customCssFiles) {
        this.customCssFiles = customCssFiles;
    }

    public String getCustomCssFiles() {
        return this.customCssFiles;
    }

    public int getTrendsLimit() {
        return this.trendsLimit;
    }

    @DataBoundSetter
    public void setTrendsLimit(int trendsLimit) {
        this.trendsLimit = trendsLimit;
    }

    public String getFileExcludePattern() {
        return this.fileExcludePattern;
    }

    @DataBoundSetter
    public void setFileExcludePattern(String fileExcludePattern) {
        this.fileExcludePattern = fileExcludePattern;
    }

    public String getJsonReportDirectory() {
        return this.jsonReportDirectory;
    }

    @DataBoundSetter
    public void setJsonReportDirectory(String jsonReportDirectory) {
        this.jsonReportDirectory = jsonReportDirectory;
    }

    public String getReportTitle() {
        return this.reportTitle;
    }

    @DataBoundSetter
    public void setReportTitle(String reportTitle) {
        this.reportTitle = StringUtils.isEmpty((CharSequence)reportTitle) ? "" : reportTitle.trim();
    }

    public String getDirectorySuffix() {
        return StringUtils.isEmpty((CharSequence)this.reportTitle) ? "" : UUID.nameUUIDFromBytes(this.reportTitle.getBytes(StandardCharsets.UTF_8)).toString();
    }

    public String getDirectorySuffixWithSeparator() {
        return StringUtils.isEmpty((CharSequence)this.reportTitle) ? "" : "_" + this.getDirectorySuffix();
    }

    public int getFailedStepsNumber() {
        return this.failedStepsNumber;
    }

    @DataBoundSetter
    public void setFailedStepsNumber(int failedStepsNumber) {
        this.failedStepsNumber = failedStepsNumber;
    }

    public int getSkippedStepsNumber() {
        return this.skippedStepsNumber;
    }

    @DataBoundSetter
    public void setSkippedStepsNumber(int skippedStepsNumber) {
        this.skippedStepsNumber = skippedStepsNumber;
    }

    public int getPendingStepsNumber() {
        return this.pendingStepsNumber;
    }

    @DataBoundSetter
    public void setPendingStepsNumber(int pendingStepsNumber) {
        this.pendingStepsNumber = pendingStepsNumber;
    }

    public int getUndefinedStepsNumber() {
        return this.undefinedStepsNumber;
    }

    @DataBoundSetter
    public void setUndefinedStepsNumber(int undefinedStepsNumber) {
        this.undefinedStepsNumber = undefinedStepsNumber;
    }

    public int getFailedScenariosNumber() {
        return this.failedScenariosNumber;
    }

    @DataBoundSetter
    public void setFailedScenariosNumber(int failedScenariosNumber) {
        this.failedScenariosNumber = failedScenariosNumber;
    }

    public int getFailedFeaturesNumber() {
        return this.failedFeaturesNumber;
    }

    @DataBoundSetter
    public void setFailedFeaturesNumber(int failedFeaturesNumber) {
        this.failedFeaturesNumber = failedFeaturesNumber;
    }

    public double getFailedStepsPercentage() {
        return this.failedStepsPercentage;
    }

    @DataBoundSetter
    public void setFailedStepsPercentage(double failedStepsPercentage) {
        this.failedStepsPercentage = failedStepsPercentage;
    }

    public double getSkippedStepsPercentage() {
        return this.skippedStepsPercentage;
    }

    @DataBoundSetter
    public void setSkippedStepsPercentage(double skippedStepsPercentage) {
        this.skippedStepsPercentage = skippedStepsPercentage;
    }

    public double getPendingStepsPercentage() {
        return this.pendingStepsPercentage;
    }

    @DataBoundSetter
    public void setPendingStepsPercentage(double pendingStepsPercentage) {
        this.pendingStepsPercentage = pendingStepsPercentage;
    }

    public double getUndefinedStepsPercentage() {
        return this.undefinedStepsPercentage;
    }

    @DataBoundSetter
    public void setUndefinedStepsPercentage(double undefinedStepsPercentage) {
        this.undefinedStepsPercentage = undefinedStepsPercentage;
    }

    public double getFailedScenariosPercentage() {
        return this.failedScenariosPercentage;
    }

    @DataBoundSetter
    public void setFailedScenariosPercentage(double failedScenariosPercentage) {
        this.failedScenariosPercentage = failedScenariosPercentage;
    }

    public double getFailedFeaturesPercentage() {
        return this.failedFeaturesPercentage;
    }

    @DataBoundSetter
    public void setFailedFeaturesPercentage(double failedFeaturesPercentage) {
        this.failedFeaturesPercentage = failedFeaturesPercentage;
    }

    public String getBuildStatus() {
        return this.buildStatus;
    }

    @DataBoundSetter
    public void setBuildStatus(String buildStatus) {
        this.buildStatus = buildStatus;
    }

    @DataBoundSetter
    public void setStopBuildOnFailedReport(boolean stopBuildOnFailedReport) {
        this.stopBuildOnFailedReport = stopBuildOnFailedReport;
    }

    public boolean getStopBuildOnFailedReport() {
        return this.stopBuildOnFailedReport;
    }

    @DataBoundSetter
    public void setFailedAsNotFailingStatus(boolean failedAsNotFailingStatus) {
        this.failedAsNotFailingStatus = failedAsNotFailingStatus;
    }

    public boolean getFailedAsNotFailingStatus() {
        return this.failedAsNotFailingStatus;
    }

    @DataBoundSetter
    public void setSkippedAsNotFailingStatus(boolean skippedAsNotFailingStatus) {
        this.skippedAsNotFailingStatus = skippedAsNotFailingStatus;
    }

    public boolean getSkippedAsNotFailingStatus() {
        return this.skippedAsNotFailingStatus;
    }

    @DataBoundSetter
    public void setPendingAsNotFailingStatus(boolean pendingAsNotFailingStatus) {
        this.pendingAsNotFailingStatus = pendingAsNotFailingStatus;
    }

    public boolean getPendingAsNotFailingStatus() {
        return this.pendingAsNotFailingStatus;
    }

    @DataBoundSetter
    public void setUndefinedAsNotFailingStatus(boolean undefinedAsNotFailingStatus) {
        this.undefinedAsNotFailingStatus = undefinedAsNotFailingStatus;
    }

    public boolean getUndefinedAsNotFailingStatus() {
        return this.undefinedAsNotFailingStatus;
    }

    @DataBoundSetter
    public void setSortingMethod(String sortingMethod) {
        this.sortingMethod = sortingMethod;
    }

    public String getSortingMethod() {
        return this.sortingMethod;
    }

    @DataBoundSetter
    public void setClassificationsFilePattern(String classificationsFilePattern) {
        this.classificationsFilePattern = classificationsFilePattern;
    }

    public String getClassificationsFilePattern() {
        return this.classificationsFilePattern;
    }

    @DataBoundSetter
    public void setMaxStreamStringLength(int maxStreamStringLength) {
        this.maxStreamStringLength = maxStreamStringLength;
    }

    public int getMaxStreamStringLength() {
        return this.maxStreamStringLength;
    }

    @DataBoundSetter
    public void setMergeFeaturesById(boolean mergeFeaturesById) {
        this.mergeFeaturesById = mergeFeaturesById;
    }

    public boolean getMergeFeaturesById() {
        return this.mergeFeaturesById;
    }

    @DataBoundSetter
    public void setMergeFeaturesWithRetest(boolean mergeFeaturesWithRetest) {
        this.mergeFeaturesWithRetest = mergeFeaturesWithRetest;
    }

    public boolean getMergeFeaturesWithRetest() {
        return this.mergeFeaturesWithRetest;
    }

    @DataBoundSetter
    public void setHideEmptyHooks(boolean hideEmptyHooks) {
        this.hideEmptyHooks = hideEmptyHooks;
    }

    public boolean getHideEmptyHooks() {
        return this.hideEmptyHooks;
    }

    @DataBoundSetter
    public void setSkipEmptyJSONFiles(boolean skipEmptyJSONFiles) {
        this.skipEmptyJSONFiles = skipEmptyJSONFiles;
    }

    public boolean getSkipEmptyJSONFiles() {
        return this.skipEmptyJSONFiles;
    }

    @DataBoundSetter
    public void setExpandAllSteps(boolean expandAllSteps) {
        this.expandAllSteps = expandAllSteps;
    }

    public boolean getExpandAllSteps() {
        return this.expandAllSteps;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        this.keepBackwardCompatibility();
        this.generateReport(run, workspace, listener);
        SafeArchiveServingRunAction caa = new SafeArchiveServingRunAction(run, new File(run.getRootDir(), "cucumber-html-reports" + this.getDirectorySuffixWithSeparator()), "cucumber-html-reports" + this.getDirectorySuffixWithSeparator(), "overview-features.html", "/plugin/cucumber-reports/icon.png", this.getActionName(), this.getDirectorySuffixWithSeparator(), new String[0]);
        run.addAction((Action)caa);
    }

    private String getActionName() {
        return StringUtils.isEmpty((CharSequence)this.reportTitle) ? Messages.SidePanel_DisplayNameNoTitle() : String.format(Messages.SidePanel_DisplayName(), this.reportTitle);
    }

    private void generateReport(Run<?, ?> build, FilePath workspace, TaskListener listener) throws InterruptedException, IOException {
        List<String> classificationFiles;
        CucumberReportPublisher.log(listener, "Using Cucumber Reports version " + this.getPomVersion(listener));
        File trendsDir = new File(build.getParent().getRootDir(), TRENDS_DIR + this.getDirectorySuffixWithSeparator());
        if (!trendsDir.exists() && !trendsDir.mkdirs()) {
            throw new IllegalStateException("Could not create directory for trends: " + String.valueOf(trendsDir));
        }
        String parsedJsonReportDirectory = this.evaluateMacro(build, workspace, listener, this.jsonReportDirectory);
        CucumberReportPublisher.log(listener, String.format("JSON report directory is \"%s\"", parsedJsonReportDirectory));
        FilePath inputReportDirectory = new FilePath(workspace, parsedJsonReportDirectory);
        File directoryForReport = build.getRootDir();
        File directoryCache = new File(directoryForReport, "cucumber-html-reports" + this.getDirectorySuffixWithSeparator() + File.separatorChar + ".cache");
        if (directoryCache.exists()) {
            throw new IllegalStateException("Cache directory " + String.valueOf(directoryCache) + " already exists. Another report with the same title already generated?");
        }
        if (!directoryCache.mkdirs()) {
            throw new IllegalStateException("Could not create directory for cache: " + String.valueOf(directoryCache));
        }
        int copiedFilesProperties = inputReportDirectory.copyRecursiveTo(DEFAULT_FILE_INCLUDE_PATTERN_CLASSIFICATIONS, new FilePath(directoryCache));
        CucumberReportPublisher.log(listener, String.format("Copied %d properties files from workspace \"%s\" to reports directory \"%s\"", copiedFilesProperties, inputReportDirectory.getRemote(), directoryCache));
        ArrayList<String> cachedCustomJsFiles = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)this.customJsFiles)) {
            cachedCustomJsFiles.addAll(this.copyFilesAndGetList(listener, workspace, directoryCache, this.customJsFiles, null));
        }
        ArrayList<String> cachedCustomCssFiles = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)this.customCssFiles)) {
            cachedCustomCssFiles.addAll(this.copyFilesAndGetList(listener, workspace, directoryCache, this.customCssFiles, null));
        }
        List<String> jsonFilesToProcess = this.copyFilesAndGetList(listener, inputReportDirectory, directoryCache, this.fileIncludePattern, this.fileExcludePattern);
        CucumberReportPublisher.log(listener, String.format("Processing %d json files:", jsonFilesToProcess.size()));
        for (String jsonFile : jsonFilesToProcess) {
            CucumberReportPublisher.log(listener, jsonFile);
        }
        String buildNumber = Integer.toString(build.getNumber());
        String projectName = build.getParent().getDisplayName();
        Configuration configuration = new Configuration(directoryForReport, projectName);
        configuration.setBuildNumber(buildNumber);
        configuration.setDirectorySuffix(this.getDirectorySuffix());
        configuration.setTrends(new File(trendsDir, TRENDS_FILE), this.trendsLimit);
        configuration.setSortingMethod(SortingMethod.valueOf((String)this.sortingMethod));
        if (this.mergeFeaturesById) {
            configuration.addReducingMethod(ReducingMethod.MERGE_FEATURES_BY_ID);
        }
        if (this.mergeFeaturesWithRetest) {
            configuration.addReducingMethod(ReducingMethod.MERGE_FEATURES_WITH_RETEST);
        }
        if (this.skipEmptyJSONFiles) {
            configuration.addReducingMethod(ReducingMethod.SKIP_EMPTY_JSON_FILES);
        }
        if (this.hideEmptyHooks) {
            configuration.addReducingMethod(ReducingMethod.HIDE_EMPTY_HOOKS);
        }
        if (this.expandAllSteps) {
            configuration.addPresentationModes(PresentationMode.EXPAND_ALL_STEPS);
        }
        configuration.addPresentationModes(PresentationMode.RUN_WITH_JENKINS);
        if (CollectionUtils.isNotEmpty(this.classifications)) {
            CucumberReportPublisher.log(listener, String.format("Adding %d classification(s)", this.classifications.size()));
            this.addClassificationsToBuildReport(build, workspace, listener, configuration, this.classifications);
        }
        if (CollectionUtils.isNotEmpty(cachedCustomJsFiles)) {
            configuration.addCustomJsFiles(cachedCustomJsFiles);
        }
        if (CollectionUtils.isNotEmpty(cachedCustomCssFiles)) {
            configuration.addCustomCssFiles(cachedCustomCssFiles);
        }
        if (CollectionUtils.isNotEmpty(classificationFiles = this.fetchPropertyFiles(directoryCache, listener))) {
            configuration.addClassificationFiles(classificationFiles);
        }
        if (this.maxStreamStringLength != 0) {
            configuration.setMaxStreamStringLength(this.maxStreamStringLength);
        }
        this.setFailingStatuses(configuration);
        ReportBuilder reportBuilder = new ReportBuilder(jsonFilesToProcess, configuration);
        Reportable result = reportBuilder.generateReports();
        if (this.hasReportFailed(result, listener)) {
            if (Result.FAILURE.toString().equals(this.buildStatus) || Result.UNSTABLE.toString().equals(this.buildStatus)) {
                CucumberReportPublisher.log(listener, "Build status is changed to " + this.buildStatus);
                build.setResult(Result.fromString((String)this.buildStatus));
            } else {
                CucumberReportPublisher.log(listener, "Build status is left unchanged");
            }
            if (this.stopBuildOnFailedReport) {
                throw new AbortException(Messages.StopBuildOnFailedReport_FailNote());
            }
        }
        FileUtils.deleteQuietly((File)directoryCache);
    }

    private List<String> copyFilesAndGetList(TaskListener listener, FilePath inputDirectory, File directoryJsonCache, String includePattern, String excludePattern) throws IOException, InterruptedException {
        int count = inputDirectory.copyRecursiveTo(includePattern, new FilePath(directoryJsonCache));
        CucumberReportPublisher.log(listener, String.format("Copied %d files from workspace \"%s\" to reports directory \"%s\"", count, inputDirectory.getRemote(), directoryJsonCache));
        String[] copiedFiles = this.findFilesByPattern(directoryJsonCache, includePattern, excludePattern);
        return this.getFullPath(copiedFiles, directoryJsonCache);
    }

    private String getPomVersion(TaskListener listener) {
        String string;
        block8: {
            Properties properties = new Properties();
            InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("plugin.properties");
            try {
                properties.load(inputStream);
                string = properties.getProperty("plugin.version");
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    CucumberReportPublisher.log(listener, e.getMessage());
                    return "";
                }
            }
            inputStream.close();
        }
        return string;
    }

    private String[] findFilesByPattern(File targetDirectory, String fileIncludePattern, String fileExcludePattern) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(targetDirectory);
        if (StringUtils.isEmpty((CharSequence)fileIncludePattern)) {
            scanner.setIncludes(new String[]{DEFAULT_FILE_INCLUDE_PATTERN_JSONS});
        } else {
            scanner.setIncludes(fileIncludePattern.split(",\\s*"));
        }
        if (StringUtils.isNotEmpty((CharSequence)fileExcludePattern)) {
            scanner.setExcludes(fileExcludePattern.split(",\\s*"));
        }
        scanner.setBasedir(targetDirectory);
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private List<String> getFullPath(String[] jsonFiles, File targetBuildDirectory) {
        ArrayList<String> fullPathList = new ArrayList<String>();
        for (String file : jsonFiles) {
            fullPathList.add(new File(targetBuildDirectory, file).getAbsolutePath());
        }
        return fullPathList;
    }

    private boolean hasReportFailed(Reportable result, TaskListener listener) {
        if (result == null) {
            CucumberReportPublisher.log(listener, "Missing report result - report was not successfully completed");
            return true;
        }
        if (this.failedStepsNumber != -1 && result.getFailedSteps() > this.failedStepsNumber) {
            CucumberReportPublisher.log(listener, String.format("Found %d failed steps, while expected at most %d", result.getFailedSteps(), this.failedStepsNumber));
            return true;
        }
        if (this.skippedStepsNumber != -1 && result.getSkippedSteps() > this.skippedStepsNumber) {
            CucumberReportPublisher.log(listener, String.format("Found %d skipped steps, while expected at most %d", result.getSkippedSteps(), this.skippedStepsNumber));
            return true;
        }
        if (this.pendingStepsNumber != -1 && result.getPendingSteps() > this.pendingStepsNumber) {
            CucumberReportPublisher.log(listener, String.format("Found %d pending steps, while expected at most %d", result.getPendingSteps(), this.pendingStepsNumber));
            return true;
        }
        if (this.undefinedStepsNumber != -1 && result.getUndefinedSteps() > this.undefinedStepsNumber) {
            CucumberReportPublisher.log(listener, String.format("Found %d undefined steps, while expected at most %d", result.getUndefinedSteps(), this.undefinedStepsNumber));
            return true;
        }
        if (this.failedScenariosNumber != -1 && result.getFailedScenarios() > this.failedScenariosNumber) {
            CucumberReportPublisher.log(listener, String.format("Found %d failed scenarios, while expected at most %d", result.getFailedScenarios(), this.failedScenariosNumber));
            return true;
        }
        if (this.failedFeaturesNumber != -1 && result.getFailedFeatures() > this.failedFeaturesNumber) {
            CucumberReportPublisher.log(listener, String.format("Found %d failed features, while expected at most %d", result.getFailedFeatures(), this.failedFeaturesNumber));
            return true;
        }
        double failedStepsThreshold = 100.0 * (double)result.getFailedSteps() / (double)result.getSteps();
        if (failedStepsThreshold > this.failedStepsPercentage) {
            CucumberReportPublisher.log(listener, String.format("Found %f failed steps, while expected not more than %f percent", failedStepsThreshold, this.failedStepsPercentage));
            return true;
        }
        double skippedStepsThreshold = 100.0 * (double)result.getSkippedSteps() / (double)result.getSteps();
        if (skippedStepsThreshold > this.skippedStepsPercentage) {
            CucumberReportPublisher.log(listener, String.format("Found %f skipped steps, while expected not more than %f percent", skippedStepsThreshold, this.skippedStepsPercentage));
            return true;
        }
        double pendingStepsThreshold = 100.0 * (double)result.getPendingSteps() / (double)result.getSteps();
        if (pendingStepsThreshold > this.pendingStepsPercentage) {
            CucumberReportPublisher.log(listener, String.format("Found %f pending steps, while expected not more than %f percent", pendingStepsThreshold, this.pendingStepsPercentage));
            return true;
        }
        double undefinedStepsThreshold = 100.0 * (double)result.getUndefinedSteps() / (double)result.getSteps();
        if (undefinedStepsThreshold > this.undefinedStepsPercentage) {
            CucumberReportPublisher.log(listener, String.format("Found %f undefined steps, while expected not more than %f percent", undefinedStepsThreshold, this.undefinedStepsPercentage));
            return true;
        }
        double failedScenariosThreshold = 100.0 * (double)result.getFailedScenarios() / (double)result.getScenarios();
        if (failedScenariosThreshold > this.failedScenariosPercentage) {
            CucumberReportPublisher.log(listener, String.format("Found %f failed scenarios, while expected not more than %f percent", failedScenariosThreshold, this.failedScenariosPercentage));
            return true;
        }
        double failedFeaturesThreshold = 100.0 * (double)result.getFailedFeatures() / (double)result.getFeatures();
        if (failedFeaturesThreshold > this.failedFeaturesPercentage) {
            CucumberReportPublisher.log(listener, String.format("Found %f failed features, while expected not more than %f percent", failedFeaturesThreshold, this.failedFeaturesPercentage));
            return true;
        }
        return false;
    }

    private String evaluateMacro(Run<?, ?> build, FilePath workspace, TaskListener listener, String value) throws InterruptedException, IOException {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)value);
        }
        catch (MacroEvaluationException e) {
            CucumberReportPublisher.log(listener, String.format("Could not evaluate macro '%s': %s", value, e.getMessage()));
            return value;
        }
    }

    private void addClassificationsToBuildReport(Run<?, ?> build, FilePath workspace, TaskListener listener, Configuration configuration, List<Classification> listToAdd) throws InterruptedException, IOException {
        for (Classification classification : listToAdd) {
            CucumberReportPublisher.log(listener, String.format("Adding classification - %s -> %s", classification.key, classification.value));
            configuration.addClassifications(classification.key, this.evaluateMacro(build, workspace, listener, classification.value));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.reportTitle)) {
            configuration.addClassifications(Messages.Classification_ReportTitle(), this.reportTitle);
        }
    }

    private void setFailingStatuses(Configuration configuration) {
        HashSet<Status> notFailingStatuses = new HashSet<Status>();
        if (this.failedAsNotFailingStatus) {
            notFailingStatuses.add(Status.FAILED);
        }
        if (this.skippedAsNotFailingStatus) {
            notFailingStatuses.add(Status.SKIPPED);
        }
        if (this.pendingAsNotFailingStatus) {
            notFailingStatuses.add(Status.PENDING);
        }
        if (this.undefinedAsNotFailingStatus) {
            notFailingStatuses.add(Status.UNDEFINED);
        }
        configuration.setNotFailingStatuses(notFailingStatuses);
    }

    private List<String> fetchPropertyFiles(File targetDirectory, TaskListener listener) {
        List<String> propertyFiles = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)this.classificationsFilePattern)) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setIncludes(new String[]{this.classificationsFilePattern});
            scanner.setBasedir(targetDirectory);
            scanner.setCaseSensitive(false);
            scanner.scan();
            propertyFiles = this.getFullMetaDataPath(scanner.getIncludedFiles(), targetDirectory.toString());
            for (String propertyFile : propertyFiles) {
                CucumberReportPublisher.log(listener, String.format("Found Properties File - %s ", propertyFile));
            }
        }
        return propertyFiles;
    }

    private List<String> getFullMetaDataPath(String[] files, String propertiesDirectory) {
        ArrayList<String> fullPathList = new ArrayList<String>();
        for (String file : files) {
            fullPathList.add(propertiesDirectory + File.separator + file);
        }
        return fullPathList;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public static class Classification
    extends AbstractDescribableImpl<Classification>
    implements Serializable {
        public String key;
        public String value;

        @DataBoundConstructor
        public Classification(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<Classification> {
            public String getDisplayName() {
                return "";
            }
        }
    }

    @Extension
    @Symbol(value={"cucumber"})
    public static class BuildStatusesDescriptorImpl
    extends CucumberReportDescriptor {
    }
}

