/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.jenkins;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Action;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.util.HttpResponses;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.commons.collections4.CollectionUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class SafeArchiveServingAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(SafeArchiveServingAction.class.getName());
    private Map<String, String> fileChecksums = new HashMap<String, String>();
    private final File rootDir;
    private final String urlName;
    private final String indexFile;
    private final String iconName;
    private final String title;
    private final List<String> safeExtensions;
    private Set<File> safeDirectories;

    public SafeArchiveServingAction(File rootDir, String urlName, String indexFile, String iconName, String title, String ... safeExtensions) {
        this.rootDir = rootDir;
        this.urlName = urlName;
        this.indexFile = indexFile;
        this.iconName = iconName;
        this.title = title;
        this.safeExtensions = Collections.unmodifiableList(Arrays.asList(safeExtensions));
        this.safeDirectories = Collections.unmodifiableSet(new HashSet<File>(Arrays.asList(rootDir, new File(rootDir, "css"), new File(rootDir, "fonts"), new File(rootDir, "js"), new File(rootDir, "images"))));
    }

    private void addFile(String relativePath, String checksum) {
        this.fileChecksums.put(relativePath, checksum);
    }

    private String getChecksum(String file) {
        if (file == null || !this.fileChecksums.containsKey(file)) {
            throw new IllegalArgumentException(file + " has no checksum recorded");
        }
        return this.fileChecksums.get(file);
    }

    private String calculateChecksum(@NonNull File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] bytes = new byte[1024];
            while (-1 != fis.read(bytes)) {
                sha1.update(bytes);
            }
        }
        return Util.toHexString((byte[])sha1.digest());
    }

    private void processDirectory(@NonNull File directory, @Nullable String path) throws NoSuchAlgorithmException, IOException {
        File[] files;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Scanning " + String.valueOf(this.getRootDir()));
        }
        if ((files = directory.listFiles()) == null) {
            throw new IllegalArgumentException(String.valueOf(directory) + " listing returned null");
        }
        for (File file : files) {
            Object relativePath = file.getName();
            if (path != null) {
                relativePath = path + "/" + (String)relativePath;
            }
            if (file.isDirectory()) {
                this.processDirectory(file, (String)relativePath);
            }
            if (!file.isFile() || this.isSafeFileType(file.getName())) continue;
            this.addFile((String)relativePath, this.calculateChecksum(file));
        }
    }

    public void processDirectory() throws NoSuchAlgorithmException, IOException {
        LOGGER.log(Level.FINE, "Scanning " + String.valueOf(this.getRootDir()));
        this.processDirectory(this.getRootDir(), null);
    }

    private boolean isSafeFileType(String filename) {
        for (String extension : this.safeExtensions) {
            if (!filename.endsWith("." + extension)) continue;
            return true;
        }
        return false;
    }

    public String getIconFileName() {
        return this.iconName;
    }

    public String getDisplayName() {
        return this.title;
    }

    public String getUrlName() {
        return this.urlName;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public HttpResponse doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        String actualChecksum;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Serving " + req.getRestOfPath());
        }
        if (req.getRestOfPath().isEmpty()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Redirecting to index file");
            }
            throw HttpResponses.redirectTo((String)this.indexFile);
        }
        String fileName = req.getRestOfPath();
        if (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        File file = new File(this.getRootDir(), fileName);
        if (!new File(this.getRootDir(), fileName).exists()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "File does not exist: " + fileName);
            }
            throw HttpResponses.notFound();
        }
        if (this.isSafeFileType(fileName)) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Serving safe file: " + fileName);
            }
            return this.serveFile(file);
        }
        if (!this.fileChecksums.containsKey(fileName)) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "File exists but no checksum recorded: " + fileName);
            }
            throw HttpResponses.notFound();
        }
        if (!file.getAbsolutePath().startsWith(this.getRootDir().getAbsolutePath())) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "File is outside archive directory: " + fileName);
            }
            throw HttpResponses.notFound();
        }
        try {
            actualChecksum = this.calculateChecksum(file);
        }
        catch (NoSuchAlgorithmException nse) {
            throw new IllegalStateException(nse);
        }
        String expectedChecksum = this.getChecksum(fileName);
        if (!expectedChecksum.equals(actualChecksum)) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Checksum mismatch: recorded: " + expectedChecksum + ", actual: " + actualChecksum + " for file: " + fileName);
            }
            throw HttpResponses.forbidden();
        }
        return this.serveFile(file);
    }

    private HttpResponse serveFile(File file) throws IOException, ServletException {
        if (CollectionUtils.isEmpty(this.safeDirectories)) {
            return new UnsafeDirectoryBrowserSupport(file);
        }
        if (this.safeDirectories.contains(file.getParentFile())) {
            return new UnsafeDirectoryBrowserSupport(file);
        }
        return new DirectoryBrowserSupport((ModelObject)this, new FilePath(this.rootDir), this.title, this.iconName, false);
    }

    private static final class UnsafeDirectoryBrowserSupport
    implements HttpResponse {
        private final File file;

        UnsafeDirectoryBrowserSupport(File file) {
            this.file = file;
        }

        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            long lastModified = this.file.lastModified();
            long length = this.file.length();
            try (FileInputStream in = new FileInputStream(this.file);){
                rsp.serveFile(req, (InputStream)in, lastModified, -1L, length, this.file.getName());
            }
        }
    }
}

