/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.jenkins.avatar.user;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Failure;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import jakarta.servlet.ServletException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload2.core.FileItem;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;

public class AvatarProperty
extends UserProperty
implements Action {
    public static final int MAX_AVATAR_IMAGE_SIZE = 0xA00000;
    private static final Logger LOGGER = Logger.getLogger(AvatarProperty.class.getName());
    private AvatarImage avatarImage;

    @DataBoundConstructor
    public AvatarProperty() {
    }

    @Exported
    public String getAvatarUrl() {
        if (this.isHasAvatar()) {
            return this.getAvatarImageUrl();
        }
        return null;
    }

    private String getAvatarImageUrl() {
        return Jenkins.get().getRootUrl() + this.user.getUrl() + "/avatar/image";
    }

    public boolean isHasAvatar() {
        return this.avatarImage != null && this.avatarImage.isValid();
    }

    public void doImage(StaplerRequest2 req, StaplerResponse2 rsp) {
        if (this.avatarImage == null) {
            LOGGER.log(Level.WARNING, "No image set for user '" + this.user.getId() + "'");
            return;
        }
        File file = new File(this.user.getUserFolder(), "avatar." + this.avatarImage.filenameSuffix);
        if (!file.exists()) {
            LOGGER.log(Level.WARNING, "Avatar image for user '" + this.user.getId() + "' does not exist");
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            rsp.setContentType(this.avatarImage.mimeType);
            rsp.serveFile(req, (InputStream)fileInputStream, file.lastModified(), file.length(), "avatar." + this.avatarImage.filenameSuffix);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to write image for user '" + this.user.getId() + "'", e);
        }
    }

    public UserProperty reconfigure(StaplerRequest2 req, JSONObject form) {
        block14: {
            req.bindJSON((Object)this, form);
            try {
                FileItem file = req.getFileItem2("avatar");
                if (file != null && !file.getName().isEmpty()) {
                    if (file.getSize() > 0xA00000L) {
                        throw new Failure("Uploaded image is too large.");
                    }
                    byte[] bytes = file.get();
                    AvatarImage replacementImage = AvatarImage.fromBytes(bytes);
                    if (replacementImage == null) {
                        throw new Failure("Unsupported image format " + file.getName());
                    }
                    if (replacementImage.isValid()) {
                        File fileToSave = new File(this.user.getUserFolder(), "avatar." + replacementImage.filenameSuffix);
                        try (FileOutputStream fos = new FileOutputStream(fileToSave);){
                            fos.write(bytes);
                        }
                        this.avatarImage = replacementImage;
                        break block14;
                    }
                    this.avatarImage = null;
                    break block14;
                }
                if (!req.getParameter("existingAvatar").equals("present")) {
                    if (this.avatarImage != null && this.avatarImage.filenameSuffix != null) {
                        File fileToDelete = new File(this.user.getUserFolder(), "avatar." + this.avatarImage.filenameSuffix);
                        Files.deleteIfExists(fileToDelete.toPath());
                    }
                    this.avatarImage = null;
                }
            }
            catch (ServletException | IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public String getDisplayName() {
        return "Avatar";
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "avatar";
    }

    public static class AvatarImage {
        private String mimeType;
        private String filenameSuffix;

        static AvatarImage fromBytes(byte[] bytes) throws IOException {
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
            Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageInputStream);
            if (imageReaders.hasNext()) {
                ImageReader imageReader = imageReaders.next();
                String[] mimeTypes = imageReader.getOriginatingProvider().getMIMETypes();
                String[] fileSuffixes = imageReader.getOriginatingProvider().getFileSuffixes();
                if (mimeTypes.length > 0 && fileSuffixes.length > 0) {
                    AvatarImage avatarImage = new AvatarImage();
                    avatarImage.mimeType = mimeTypes[0];
                    avatarImage.filenameSuffix = fileSuffixes[0];
                    LOGGER.log(Level.FINE, "Avatar image interpreted as " + avatarImage.mimeType + " ." + avatarImage.filenameSuffix);
                    return avatarImage;
                }
            }
            return null;
        }

        public boolean isValid() {
            return this.filenameSuffix != null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends UserPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Avatar";
        }

        public UserProperty newInstance(User user) {
            return new AvatarProperty();
        }
    }
}

