/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.discardbuild;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.RunList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.discardbuild.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class DiscardBuildPublisher
extends Recorder {
    private final int daysToKeep;
    private final int numToKeep;
    private final Set<Result> resultsToDiscard;
    private final long minLogFileSize;
    private final long maxLogFileSize;
    private final int intervalDaysToKeep;
    private final int intervalNumToKeep;
    private final boolean keepLastBuilds;
    private final boolean holdMaxBuilds;
    private final String regexp;

    @DataBoundConstructor
    public DiscardBuildPublisher(String daysToKeep, String intervalDaysToKeep, String numToKeep, String intervalNumToKeep, boolean discardSuccess, boolean discardUnstable, boolean discardFailure, boolean discardNotBuilt, boolean discardAborted, String minLogFileSize, String maxLogFileSize, String regexp, boolean keepLastBuilds, boolean holdMaxBuilds) {
        this.daysToKeep = DiscardBuildPublisher.parse(daysToKeep);
        this.intervalDaysToKeep = DiscardBuildPublisher.parse(intervalDaysToKeep);
        this.numToKeep = DiscardBuildPublisher.parse(numToKeep);
        this.intervalNumToKeep = DiscardBuildPublisher.parse(intervalNumToKeep);
        this.resultsToDiscard = new HashSet<Result>();
        if (discardSuccess) {
            this.resultsToDiscard.add(Result.SUCCESS);
        }
        if (discardUnstable) {
            this.resultsToDiscard.add(Result.UNSTABLE);
        }
        if (discardFailure) {
            this.resultsToDiscard.add(Result.FAILURE);
        }
        if (discardNotBuilt) {
            this.resultsToDiscard.add(Result.NOT_BUILT);
        }
        if (discardAborted) {
            this.resultsToDiscard.add(Result.ABORTED);
        }
        this.minLogFileSize = DiscardBuildPublisher.parseLong(minLogFileSize);
        this.maxLogFileSize = DiscardBuildPublisher.parseLong(maxLogFileSize);
        this.regexp = regexp;
        this.keepLastBuilds = keepLastBuilds;
        this.holdMaxBuilds = holdMaxBuilds;
    }

    private static int parse(String p) {
        if (p == null) {
            return -1;
        }
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static long parseLong(String p) {
        if (p == null) {
            return -1L;
        }
        try {
            return Long.parseLong(p);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Replace in Java 11 with two argument FileReader call")
    private static boolean isRegexpMatch(File logFile, String regexp) throws IOException, InterruptedException {
        if (regexp == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(regexp);
        try (BufferedReader reader = new BufferedReader(new FileReader(logFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static String intToString(int i) {
        if (i == -1) {
            return "";
        }
        return Integer.toString(i);
    }

    private static String longToString(long i) {
        if (i == -1L) {
            return "";
        }
        return Long.toString(i);
    }

    private ArrayList<Run<?, ?>> keepLastBuilds(AbstractBuild<?, ?> build, BuildListener listener, RunList<Run<?, ?>> builds) {
        Job job = build.getParent();
        ExtendRunList newList = new ExtendRunList();
        Run lastBuild = job.getLastBuild();
        Run lastCompletedBuild = job.getLastCompletedBuild();
        Run lastFailedBuild = job.getLastFailedBuild();
        Run lastStableBuild = job.getLastStableBuild();
        Run lastSuccessfulBuild = job.getLastSuccessfulBuild();
        Run lastUnstableBuild = job.getLastUnstableBuild();
        Run lastUnsuccessfulBuild = job.getLastUnsuccessfulBuild();
        for (Run r : builds) {
            if (r.isBuilding() || r == lastBuild || r == lastCompletedBuild || r == lastFailedBuild || r == lastStableBuild || r == lastSuccessfulBuild || r == lastUnstableBuild || r == lastUnsuccessfulBuild) continue;
            newList.add(r);
        }
        return newList.getNewList();
    }

    private ArrayList<Run<?, ?>> discardLastBuilds(AbstractBuild<?, ?> build, BuildListener listener, RunList<Run<?, ?>> builds) {
        ExtendRunList newList = new ExtendRunList();
        for (Run r : builds) {
            newList.add(r);
        }
        return newList.getNewList();
    }

    private ArrayList<Run<?, ?>> processHoldMaxBuilds(ArrayList<Run<?, ?>> listIn, BuildListener listener, int maxCount) {
        ArrayList<Run<?, ?>> listUpdt = listIn;
        int listCnt = listUpdt.size();
        if (listCnt < maxCount || listCnt == maxCount) {
            listener.getLogger().println("Too few builds present to remove any, clearing discard list.");
            listUpdt.clear();
        } else if (listCnt > maxCount) {
            listener.getLogger().println("Removing builds from discard list to maintain max quantity:");
            for (int i = 0; i < maxCount; ++i) {
                listener.getLogger().println(listUpdt.get(0));
                listUpdt.remove(0);
            }
        }
        return listUpdt;
    }

    private void deleteOldBuildsByRegexp(AbstractBuild<?, ?> build, BuildListener listener, String regexp) {
        ArrayList<Run<?, ?>> list = this.updateBuildsList(build, listener);
        if (regexp == null || regexp.equals("")) {
            return;
        }
        try {
            for (Run<?, ?> r : list) {
                if (!DiscardBuildPublisher.isRegexpMatch(r.getLogFile(), regexp)) continue;
                this.discardBuild(r, "match regular expression", listener);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void deleteOldBuildsByLogfileSize(AbstractBuild<?, ?> build, BuildListener listener, long minLogFileSize, long maxLogFileSize) {
        ArrayList<Run<?, ?>> list = this.updateBuildsList(build, listener);
        try {
            if (minLogFileSize != -1L || maxLogFileSize != -1L) {
                for (Run<?, ?> r : list) {
                    long size = r.getLogFile().length();
                    if (minLogFileSize == -1L && size > maxLogFileSize) {
                        this.discardBuild(r, "log file size=" + size + " which is too big", listener);
                        continue;
                    }
                    if (maxLogFileSize == -1L && size < minLogFileSize) {
                        this.discardBuild(r, "log file size=" + size + " which is too small", listener);
                        continue;
                    }
                    if (minLogFileSize == -1L || maxLogFileSize == -1L || size >= minLogFileSize && size <= maxLogFileSize) continue;
                    this.discardBuild(r, "log file size=" + size + " which is too small or too big", listener);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deleteOldBuildsByDays(AbstractBuild<?, ?> build, BuildListener listener, int daysToKeep) {
        ArrayList<Run<?, ?>> list = this.updateBuildsList(build, listener);
        if (daysToKeep == -1) {
            return;
        }
        if (this.numToKeep != -1 && this.isHoldMaxBuilds()) {
            list = this.processHoldMaxBuilds(list, listener, this.numToKeep);
        }
        try {
            Calendar cal = this.getCurrentCalendar();
            cal.add(6, -daysToKeep);
            for (Run<?, ?> r : list) {
                if (!r.getTimestamp().before(cal)) continue;
                this.discardBuild(r, "it is older than daysToKeep", listener);
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error(""));
        }
    }

    private void deleteOldBuildsByIntervalDays(AbstractBuild<?, ?> build, BuildListener listener, int intervalDaysToKeep) {
        ArrayList<Run<?, ?>> list = this.updateBuildsList(build, listener);
        if (intervalDaysToKeep == -1) {
            return;
        }
        try {
            Run<?, ?> prev = null;
            for (Run<?, ?> r : list) {
                if (prev == null) {
                    prev = r;
                    continue;
                }
                Calendar prevCal = this.getCurrentCalendar();
                prevCal.setTime(prev.getTimestamp().getTime());
                prevCal.add(6, -intervalDaysToKeep);
                if (r.getTimestamp().after(prevCal)) {
                    this.discardBuild(r, "it is old and within build days interval", listener);
                    continue;
                }
                prev = r;
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error(""));
        }
    }

    private void deleteOldBuildsByNum(AbstractBuild<?, ?> build, BuildListener listener, int numToKeep) {
        ArrayList<Run<?, ?>> list = this.updateBuildsList(build, listener);
        if (numToKeep == -1) {
            return;
        }
        int index = 0;
        if (this.daysToKeep != -1 && this.isHoldMaxBuilds()) {
            return;
        }
        try {
            for (Run<?, ?> r : list) {
                if (index >= numToKeep) {
                    this.discardBuild(r, "old than numToKeep", listener);
                }
                ++index;
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error(""));
        }
    }

    private void deleteOldBuildsByIntervalNum(AbstractBuild<?, ?> build, BuildListener listener, int intervalNumToKeep) {
        ArrayList<Run<?, ?>> list = this.updateBuildsList(build, listener);
        if (intervalNumToKeep == -1) {
            return;
        }
        int index = 0;
        try {
            if (intervalNumToKeep == 1) {
                intervalNumToKeep = 2;
            }
            for (Run<?, ?> r : list) {
                if (index % intervalNumToKeep != 0) {
                    this.discardBuild(r, "it is old and within build number interval", listener);
                }
                ++index;
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error(""));
        }
    }

    private void deleteOldBuildsByStatus(AbstractBuild<?, ?> build, BuildListener listener, Set<Result> resultsToDiscard) {
        ArrayList<Run<?, ?>> list = this.updateBuildsList(build, listener);
        try {
            for (Run<?, ?> r : list) {
                this.discardByStatus(r, resultsToDiscard, listener);
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error(""));
        }
    }

    private ArrayList<Run<?, ?>> updateBuildsList(AbstractBuild<?, ?> build, BuildListener listener) {
        Job job = build.getParent();
        RunList builds = job.getBuilds();
        ArrayList<Run<?, ?>> list = this.isKeepLastBuilds() ? this.keepLastBuilds(build, listener, builds) : this.discardLastBuilds(build, listener, builds);
        return list;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        listener.getLogger().println("Discard old builds...");
        this.deleteOldBuildsByDays(build, listener, this.daysToKeep);
        this.deleteOldBuildsByNum(build, listener, this.numToKeep);
        this.deleteOldBuildsByIntervalDays(build, listener, this.intervalDaysToKeep);
        this.deleteOldBuildsByIntervalNum(build, listener, this.intervalNumToKeep);
        this.deleteOldBuildsByStatus(build, listener, this.resultsToDiscard);
        this.deleteOldBuildsByLogfileSize(build, listener, this.minLogFileSize, this.maxLogFileSize);
        this.deleteOldBuildsByRegexp(build, listener, this.regexp);
        return true;
    }

    private boolean discardByStatus(Run<?, ?> history, Set<Result> resultSet, BuildListener listener) throws IOException {
        if (!resultSet.isEmpty() && resultSet.contains(history.getResult())) {
            this.discardBuild(history, "status %s is not to be kept".formatted(history.getResult()), listener);
            return true;
        }
        return false;
    }

    private void discardBuild(Run<?, ?> history, String reason, BuildListener listener) throws IOException {
        listener.getLogger().printf("#%d is removed because %s%n", history.getNumber(), reason);
        history.delete();
    }

    public String getDaysToKeep() {
        return DiscardBuildPublisher.intToString(this.daysToKeep);
    }

    public String getNumToKeep() {
        return DiscardBuildPublisher.intToString(this.numToKeep);
    }

    public String getMinLogFileSize() {
        return DiscardBuildPublisher.longToString(this.minLogFileSize);
    }

    public String getMaxLogFileSize() {
        return DiscardBuildPublisher.longToString(this.maxLogFileSize);
    }

    public String getIntervalDaysToKeep() {
        return DiscardBuildPublisher.intToString(this.intervalDaysToKeep);
    }

    public String getRegexp() {
        return this.regexp;
    }

    public String getIntervalNumToKeep() {
        return DiscardBuildPublisher.intToString(this.intervalNumToKeep);
    }

    public boolean isDiscardSuccess() {
        return this.resultsToDiscard.contains(Result.SUCCESS);
    }

    public boolean isDiscardUnstable() {
        return this.resultsToDiscard.contains(Result.UNSTABLE);
    }

    public boolean isDiscardFailure() {
        return this.resultsToDiscard.contains(Result.FAILURE);
    }

    public boolean isDiscardNotBuilt() {
        return this.resultsToDiscard.contains(Result.NOT_BUILT);
    }

    public boolean isDiscardAborted() {
        return this.resultsToDiscard.contains(Result.ABORTED);
    }

    public boolean isKeepLastBuilds() {
        return this.keepLastBuilds;
    }

    public boolean isHoldMaxBuilds() {
        return this.holdMaxBuilds;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    protected Calendar getCurrentCalendar() {
        return Calendar.getInstance();
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="Evaluate later if interest in the plugin rises")
    class ExtendRunList
    extends RunList<Run<?, ?>> {
        private ArrayList<Run<?, ?>> newList = new ArrayList();

        ExtendRunList() {
        }

        ArrayList<Run<?, ?>> getNewList() {
            return this.newList;
        }

        public boolean add(Run<?, ?> run) {
            this.newList.add(run);
            return true;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.DiscardHistoryBuilder_description();
        }
    }
}

