/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.updatesitesmanager;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.model.UpdateSite;
import hudson.util.FormApply;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import jenkins.model.Jenkins;
import jp.ikedam.jenkins.plugins.updatesitesmanager.DescribedUpdateSite;
import jp.ikedam.jenkins.plugins.updatesitesmanager.DescribedUpdateSiteDescriptor;
import jp.ikedam.jenkins.plugins.updatesitesmanager.Messages;
import jp.ikedam.jenkins.plugins.updatesitesmanager.internal.Sites;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension(ordinal=2.147483237E9)
public class UpdateSitesManager
extends ManagementLink {
    public static final String URL = "updatesites";

    public String getDisplayName() {
        return Messages.UpdateSitesManager_DisplayName();
    }

    public String getIconFileName() {
        return "/plugin/update-sites-manager/images/update-sites-manager.svg";
    }

    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.CONFIGURATION;
    }

    public String getDescription() {
        return Messages.UpdateSitesManager_Description();
    }

    public String getUrlName() {
        return URL;
    }

    public List<UpdateSite> getManagedUpdateSiteList() {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)Jenkins.get().getUpdateCenter().getSites(), (Predicate)new IsSiteManaged()));
    }

    public List<UpdateSite> getNotManagedUpdateSiteList() {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)Jenkins.get().getUpdateCenter().getSites(), (Predicate)Predicates.not((Predicate)new IsSiteManaged())));
    }

    public List<DescribedUpdateSiteDescriptor> getUpdateSiteDescriptorList() {
        return DescribedUpdateSite.all();
    }

    @RequirePOST
    public void doUpdate(StaplerRequest2 req, StaplerResponse2 rsp, @Sites List<UpdateSite> managed) throws IOException, Descriptor.FormException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        ArrayList newSitesList = Lists.newArrayList((Iterable)Iterables.concat(this.getNotManagedUpdateSiteList(), managed));
        UpdateSitesManager.shouldNotContainDuplicatedIds(newSitesList);
        UpdateSitesManager.shouldNotContainBlankIds(newSitesList);
        Jenkins.get().getUpdateCenter().getSites().replaceBy((Collection)newSitesList);
        Jenkins.get().getUpdateCenter().save();
        FormApply.success((String)(req.getContextPath() + "/manage")).generateResponse(req, rsp, null);
    }

    private static void shouldNotContainDuplicatedIds(List<UpdateSite> sites) throws Descriptor.FormException {
        HashSet set = Sets.newHashSet((Iterable)Iterables.transform(sites, (Function)new IdExtractor()));
        if (set.size() != sites.size()) {
            throw new Descriptor.FormException("id is duplicated", "id");
        }
    }

    private static void shouldNotContainBlankIds(List<UpdateSite> sites) throws Descriptor.FormException {
        if (Iterables.tryFind(sites, (Predicate)new WithBlankId()).isPresent()) {
            throw new Descriptor.FormException("id is empty", "id");
        }
    }

    public static class IsSiteManaged
    implements Predicate<UpdateSite> {
        public boolean apply(@Nullable UpdateSite input) {
            return input instanceof DescribedUpdateSite;
        }
    }

    public static class IdExtractor
    implements Function<UpdateSite, String> {
        public String apply(UpdateSite site) {
            return site.getId();
        }
    }

    public static class WithBlankId
    implements Predicate<UpdateSite> {
        public boolean apply(UpdateSite input) {
            return StringUtils.isBlank((String)input.getId());
        }
    }
}

