/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.updatesitesmanager;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.JSONSignatureValidator;
import jp.ikedam.jenkins.plugins.updatesitesmanager.DescribedUpdateSite;
import jp.ikedam.jenkins.plugins.updatesitesmanager.DescribedUpdateSiteDescriptor;
import jp.ikedam.jenkins.plugins.updatesitesmanager.Messages;
import jp.ikedam.jenkins.plugins.updatesitesmanager.internal.ExtendedCertJsonSignValidator;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ManagedUpdateSite
extends DescribedUpdateSite {
    private static final Logger LOGGER = Logger.getLogger(ManagedUpdateSite.class.getName());
    private String caCertificate;
    private final boolean disabled;
    private final String note;

    public String getCaCertificate() {
        return this.caCertificate;
    }

    public void setCaCertificate(String caCertificate) {
        this.caCertificate = caCertificate;
    }

    public boolean isUseCaCertificate() {
        return this.getCaCertificate() != null;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @DataBoundConstructor
    public ManagedUpdateSite(String id, String url, boolean useCaCertificate, String caCertificate, String note, boolean disabled) {
        super(id, url);
        this.caCertificate = useCaCertificate ? StringUtils.trim((String)caCertificate) : null;
        this.note = note;
        this.disabled = disabled;
    }

    @NonNull
    protected JSONSignatureValidator getJsonSignatureValidator(@CheckForNull String name) {
        if (this.isUseCaCertificate()) {
            return new ExtendedCertJsonSignValidator(name, this.getCaCertificate());
        }
        return super.getJsonSignatureValidator(name);
    }

    @Extension
    public static class DescriptorImpl
    extends DescribedUpdateSiteDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.ManagedUpdateSite_DisplayName();
        }

        @RequirePOST
        public FormValidation doCheckCaCertificate(@QueryParameter boolean useCaCertificate, @QueryParameter String caCertificate) {
            if (!useCaCertificate) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)caCertificate)) {
                return FormValidation.error((String)Messages.ManagedUpdateSite_caCertificate_required());
            }
            CertificateFactory cf = null;
            try {
                cf = CertificateFactory.getInstance("X509");
            }
            catch (CertificateException e) {
                LOGGER.log(Level.WARNING, "Failed to retrieve CertificateFactory for X509", e);
            }
            if (cf != null) {
                try {
                    cf.generateCertificate(new ByteArrayInputStream(StringUtils.trim((String)caCertificate).getBytes(StandardCharsets.UTF_8)));
                }
                catch (CertificateException e) {
                    return FormValidation.error((String)Messages.ManagedUpdateSite_caCertificate_invalid(e.getLocalizedMessage()));
                }
            }
            return FormValidation.ok();
        }
    }
}

