/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.updatesitesmanager;

import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.net.URI;
import java.net.URISyntaxException;
import jp.ikedam.jenkins.plugins.updatesitesmanager.DescribedUpdateSite;
import jp.ikedam.jenkins.plugins.updatesitesmanager.Messages;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public abstract class DescribedUpdateSiteDescriptor
extends Descriptor<DescribedUpdateSite> {
    @RequirePOST
    public FormValidation doCheckId(@QueryParameter String id) {
        if (StringUtils.isBlank((String)id)) {
            return FormValidation.error((String)Messages.DescribedupdateSite_id_required());
        }
        return FormValidation.ok();
    }

    @RequirePOST
    public FormValidation doCheckUrl(@QueryParameter String url) {
        URI uri;
        if (StringUtils.isBlank((String)url)) {
            return FormValidation.error((String)Messages.DescribedupdateSite_url_required());
        }
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            return FormValidation.error((String)Messages.DescribedupdateSite_url_invalid(e.getLocalizedMessage()));
        }
        if (StringUtils.isBlank((String)uri.getScheme()) || StringUtils.isBlank((String)uri.getHost())) {
            return FormValidation.error((String)Messages.DescribedupdateSite_url_invalid("incomplete URI"));
        }
        return FormValidation.ok();
    }
}

