/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.updatesitesmanager;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import jenkins.model.Jenkins;
import jp.ikedam.jenkins.plugins.updatesitesmanager.DescribedUpdateSiteDescriptor;
import jp.ikedam.jenkins.plugins.updatesitesmanager.ManagedUpdateSite;
import jp.ikedam.jenkins.plugins.updatesitesmanager.Messages;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.core.Authentication;

public class CredentialRequiredUpdateSite
extends ManagedUpdateSite {
    private String credentialsId;

    @DataBoundConstructor
    public CredentialRequiredUpdateSite(String id, String url, boolean useCaCertificate, String caCertificate, String note, boolean disabled) {
        super(id, url, useCaCertificate, caCertificate, note, disabled);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @Nullable
    private StandardUsernamePasswordCredentials getCredential() {
        List credentials = CredentialsProvider.lookupCredentialsInItem(StandardUsernamePasswordCredentials.class, null, (Authentication)ACL.SYSTEM2, null);
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)credentials, (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
    }

    @NonNull
    public FormValidation updateDirectlyNow(boolean signatureCheck) throws IOException {
        URL url = new URL(this.getUrl());
        if (this.credentialsId == null) {
            return FormValidation.error((String)Messages.CredentialRequiredUpdateSite_credentialsNotFound());
        }
        StandardUsernamePasswordCredentials credential = this.getCredential();
        if (credential != null) {
            HttpRequest httpRequest;
            String token = String.format("%s:%s", credential.getUsername(), credential.getPassword().getPlainText());
            String basicAuth = String.format("Basic %s", Base64.getEncoder().encodeToString(token.getBytes(StandardCharsets.UTF_8)));
            HttpClient httpClient = ProxyConfiguration.newHttpClient();
            try {
                httpRequest = ProxyConfiguration.newHttpRequestBuilder((URI)url.toURI()).headers("Accept", "application/json", "Authorization", basicAuth).GET().build();
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                return FormValidation.error((String)e.getMessage());
            }
            try {
                HttpResponse<String> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
                String jsonp = response.body();
                String json = "";
                int start = jsonp.indexOf(123);
                int end = jsonp.lastIndexOf(125);
                if (start < 0 || end <= start) {
                    throw new IOException("Could not find JSON in " + String.valueOf(url));
                }
                json = jsonp.substring(start, end + 1);
                return this.updateData(json, signatureCheck);
            }
            catch (IOException | InterruptedException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
        return FormValidation.error((String)Messages.CredentialRequiredUpdateSite_invalidCredentials(this.credentialsId));
    }

    public URLConnection connect(URL src) throws IOException {
        URLConnection connection = ProxyConfiguration.open((URL)src);
        StandardUsernamePasswordCredentials credential = this.getCredential();
        if (credential == null) {
            throw new IOException(Messages.CredentialRequiredUpdateSite_invalidCredentials(this.credentialsId));
        }
        String token = credential.getUsername() + ":" + credential.getPassword().getPlainText();
        String basicAuth = "Basic " + Base64.getEncoder().encodeToString(token.getBytes(StandardCharsets.UTF_8));
        connection.setRequestProperty("Authorization", basicAuth);
        return connection;
    }

    @Extension
    public static class DescriptorImpl
    extends DescribedUpdateSiteDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.CredentialRequiredUpdateSite_DisplayName();
        }

        @RequirePOST
        public FormValidation doCheckCredentialsId(@AncestorInPath @CheckForNull Item item, @QueryParameter String credentialsId, @QueryParameter String serverUrl) {
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (!StringUtils.isBlank((String)credentialsId)) {
                List domainRequirement = URIRequirementBuilder.fromUri((String)serverUrl).build();
                if (CredentialsProvider.listCredentialsInItem(StandardUsernameCredentials.class, (Item)item, (Authentication)this.getAuthentication(item), (List)domainRequirement, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId)).isEmpty()) {
                    return FormValidation.error((String)"invalid credentials");
                }
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId, @QueryParameter String url) {
            StandardListBoxModel result = new StandardListBoxModel();
            credentialsId = StringUtils.trimToEmpty((String)credentialsId);
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            Authentication authentication = this.getAuthentication(item);
            List build = URIRequirementBuilder.fromUri((String)url).build();
            CredentialsMatcher always = CredentialsMatchers.always();
            Class<StandardUsernameCredentials> type = StandardUsernameCredentials.class;
            result.includeEmptyValue();
            if (item != null) {
                result.includeMatchingAs(authentication, item, type, build, always);
            } else {
                result.includeMatchingAs(authentication, (ItemGroup)Jenkins.get(), type, build, always);
            }
            return result;
        }

        protected Authentication getAuthentication(Item item) {
            return item instanceof Queue.Task ? Tasks.getAuthenticationOf2((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM2;
        }
    }
}

