/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.scoringloadbalancer;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.LoadBalancer;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.MappingWorksheet;
import hudson.model.queue.SubTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.Messages;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.ScoringRule;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class ScoringLoadBalancer
extends LoadBalancer
implements Describable<ScoringLoadBalancer> {
    private static final Logger LOGGER = Logger.getLogger(ScoringLoadBalancer.class.getName());
    private LoadBalancer fallback;
    private long lastEvaluation = -1L;

    @Initializer(after=InitMilestone.PLUGINS_STARTED, fatal=false)
    public static void installLoadBalancer() {
        LOGGER.info("Replace LoadBalancer to ScoringLoadBalancer");
        Queue q = Jenkins.get().getQueue();
        LoadBalancer fallback = q.getLoadBalancer();
        q.setLoadBalancer((LoadBalancer)new ScoringLoadBalancer(fallback));
    }

    public LoadBalancer getFallback() {
        return this.fallback;
    }

    public List<ScoringRule> getScoringRuleList() {
        return this.getDescriptor().getScoringRuleList();
    }

    public boolean isEnabled() {
        return this.getDescriptor().isEnabled();
    }

    public boolean isReportScoresEnabled() {
        return this.getDescriptor().isReportScoresEnabled();
    }

    public boolean isSimultaneousBuildsWorkaroundEnabled() {
        return this.getDescriptor().isSimultaneousBuildsWorkaroundEnabled();
    }

    public int getSimultaneousBuildsWorkaroundThrottleTime() {
        return this.getDescriptor().getSimultaneousBuildsWorkaroundThrottleTime();
    }

    public ScoringLoadBalancer(LoadBalancer fallback) {
        this.fallback = fallback;
    }

    public MappingWorksheet.Mapping map(Queue.Task task, MappingWorksheet worksheet) {
        if (this.isSimultaneousBuildsWorkaroundEnabled()) {
            if (this.lastEvaluation > System.currentTimeMillis() - (long)this.getSimultaneousBuildsWorkaroundThrottleTime()) {
                return null;
            }
            this.lastEvaluation = System.currentTimeMillis();
        }
        MappingWorksheet.Mapping m = new MappingWorksheet.Mapping(worksheet);
        List<ScoringRule> scoringRuleList = this.getScoringRuleList();
        if (this.isEnabled()) {
            try {
                if (this.assignGreedily(m, task, worksheet, scoringRuleList)) {
                    return m;
                }
                return null;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to load balance with scores: fallback to preconfigured LoadBalancer", e);
            }
        }
        if (this.getFallback() != null) {
            return this.getFallback().map(task, worksheet);
        }
        LOGGER.severe("No LoadBalancer to fall back is defined: Builds are NEVER launched.");
        return null;
    }

    private boolean assignGreedily(MappingWorksheet.Mapping m, Queue.Task task, MappingWorksheet worksheet, List<ScoringRule> scoringRuleList) throws Exception {
        return this.assignGreedily(m, task, worksheet, scoringRuleList, 0);
    }

    private boolean assignGreedily(MappingWorksheet.Mapping m, Queue.Task task, MappingWorksheet worksheet, List<ScoringRule> scoringRuleList, int targetWorkChunk) throws Exception {
        if (targetWorkChunk >= worksheet.works.size()) {
            return m.isCompletelyValid();
        }
        MappingWorksheet.WorkChunk wc = worksheet.works(targetWorkChunk);
        ArrayList<MappingWorksheet.ExecutorChunk> executors = new ArrayList<MappingWorksheet.ExecutorChunk>(wc.applicableExecutorChunks());
        NodesScore nodesScore = new NodesScore(executors);
        for (ScoringRule scoringRule : this.getScoringRuleList()) {
            if (!scoringRule.updateScores(task, wc, m, nodesScore)) break;
        }
        this.sortExecutors(executors, nodesScore);
        if (this.isReportScoresEnabled()) {
            this.reportScores(wc, executors, nodesScore);
        }
        for (MappingWorksheet.ExecutorChunk ec : executors) {
            if (nodesScore.isInvalid(ec)) continue;
            m.assign(targetWorkChunk, ec);
            if (!m.isPartiallyValid() || !this.assignGreedily(m, task, worksheet, scoringRuleList, targetWorkChunk + 1)) continue;
            return true;
        }
        m.assign(targetWorkChunk, null);
        return false;
    }

    protected void sortExecutors(List<MappingWorksheet.ExecutorChunk> executors, NodesScore nodesScore) {
        Collections.shuffle(executors);
        Collections.sort(executors, nodesScore.new NodesScore.ExecutorComparator());
    }

    protected void reportScores(MappingWorksheet.WorkChunk wc, List<MappingWorksheet.ExecutorChunk> executors, NodesScore nodesScore) {
        ArrayList<String> lines = new ArrayList<String>();
        List wcs = wc.stream().map(SubTask::toString).collect(Collectors.toList());
        lines.add(String.format("Scoring for %s:", String.join((CharSequence)",", wcs)));
        for (MappingWorksheet.ExecutorChunk ec : executors) {
            lines.add(String.format("  %20s: %4d", ec.getName(), nodesScore.getScore(ec)));
        }
        LOGGER.info(String.join((CharSequence)System.getProperty("line.separator"), lines));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    @Symbol(value={"scoringLoadBalancer"})
    public static class DescriptorImpl
    extends Descriptor<ScoringLoadBalancer> {
        private boolean enabled = true;
        private boolean reportScoresEnabled = false;
        private boolean simultaneousBuildsWorkaroundEnabled = false;
        private int simultaneousBuildsWorkaroundThrottleTime = 1000;
        private List<ScoringRule> scoringRuleList = Collections.emptyList();

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isReportScoresEnabled() {
            return this.reportScoresEnabled;
        }

        public boolean isSimultaneousBuildsWorkaroundEnabled() {
            return this.simultaneousBuildsWorkaroundEnabled;
        }

        public int getSimultaneousBuildsWorkaroundThrottleTime() {
            return this.simultaneousBuildsWorkaroundThrottleTime;
        }

        public List<ScoringRule> getScoringRuleList() {
            return this.scoringRuleList;
        }

        public DescriptorImpl() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.enabled = true;
            this.reportScoresEnabled = false;
            this.simultaneousBuildsWorkaroundEnabled = false;
            this.simultaneousBuildsWorkaroundThrottleTime = 1000;
            req.bindJSON((Object)this, json);
            this.save();
            return true;
        }

        public boolean configure(boolean enabled, boolean reportScoresEnabled, boolean simultaneousBuildsWorkaroundEnabled, int simultaneousBuildsWorkaroundThrottleTime, List<ScoringRule> scoringRuleList) {
            this.enabled = enabled;
            this.reportScoresEnabled = reportScoresEnabled;
            this.simultaneousBuildsWorkaroundEnabled = simultaneousBuildsWorkaroundEnabled;
            this.simultaneousBuildsWorkaroundThrottleTime = simultaneousBuildsWorkaroundThrottleTime;
            this.scoringRuleList = scoringRuleList;
            this.save();
            return true;
        }

        public boolean configure(boolean enabled, boolean reportScoresEnabled, boolean simultaneousBuildsWorkaroundEnabled, int simultaneousBuildsWorkaroundThrottleTime, ScoringRule ... scoringRules) {
            return this.configure(enabled, reportScoresEnabled, simultaneousBuildsWorkaroundEnabled, simultaneousBuildsWorkaroundThrottleTime, Arrays.asList(scoringRules));
        }

        @DataBoundSetter
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @DataBoundSetter
        public void setReportScoresEnabled(boolean reportScoresEnabled) {
            this.reportScoresEnabled = reportScoresEnabled;
        }

        @DataBoundSetter
        public void setSimultaneousBuildsWorkaroundEnabled(boolean simultaneousBuildsWorkaroundEnabled) {
            this.simultaneousBuildsWorkaroundEnabled = simultaneousBuildsWorkaroundEnabled;
        }

        @DataBoundSetter
        public void setSimultaneousBuildsWorkaroundThrottleTime(int simultaneousBuildsWorkaroundThrottleTime) {
            this.simultaneousBuildsWorkaroundThrottleTime = simultaneousBuildsWorkaroundThrottleTime;
        }

        @DataBoundSetter
        public void setScoringRuleList(List<ScoringRule> scoringRuleList) {
            this.scoringRuleList = scoringRuleList;
        }

        public String getDisplayName() {
            return Messages.ScoringLoadBalancer_DisplayName();
        }

        public DescriptorExtensionList<ScoringRule, Descriptor<ScoringRule>> getAllScoringRuleList() {
            return ScoringRule.all();
        }
    }

    public static class NodesScore {
        private Map<Node, MappingWorksheet.ExecutorChunk> nodeExecutorMap;
        private Map<MappingWorksheet.ExecutorChunk, Integer> executorScoreMap;
        private Set<MappingWorksheet.ExecutorChunk> invalidExecutors;

        public NodesScore(Collection<MappingWorksheet.ExecutorChunk> executors) {
            this.nodeExecutorMap = new HashMap<Node, MappingWorksheet.ExecutorChunk>(executors.size());
            this.executorScoreMap = new HashMap<MappingWorksheet.ExecutorChunk, Integer>(executors.size());
            this.invalidExecutors = new HashSet<MappingWorksheet.ExecutorChunk>();
            for (MappingWorksheet.ExecutorChunk executor : executors) {
                this.nodeExecutorMap.put(executor.node, executor);
                this.executorScoreMap.put(executor, 0);
            }
        }

        public Collection<Node> getNodes() {
            return this.nodeExecutorMap.keySet();
        }

        public Collection<MappingWorksheet.ExecutorChunk> getExecutorChunks() {
            return this.executorScoreMap.keySet();
        }

        public void addScore(Node node, int score) {
            this.addScore(this.nodeExecutorMap.get(node), score);
        }

        public void addScore(MappingWorksheet.ExecutorChunk executor, int score) {
            this.executorScoreMap.put(executor, this.executorScoreMap.get(executor) + score);
        }

        public void resetScore(Node node) {
            this.resetScore(this.nodeExecutorMap.get(node));
        }

        public void resetScore(MappingWorksheet.ExecutorChunk executor) {
            this.executorScoreMap.put(executor, 0);
        }

        public int getScore(Node node) {
            return this.getScore(this.nodeExecutorMap.get(node));
        }

        public int getScore(MappingWorksheet.ExecutorChunk executor) {
            return this.executorScoreMap.get(executor);
        }

        public void markInvalid(MappingWorksheet.ExecutorChunk executor) {
            this.invalidExecutors.add(executor);
        }

        public void markInvalid(Node node) {
            this.markInvalid(this.nodeExecutorMap.get(node));
        }

        public void resetInvalid() {
            this.invalidExecutors.clear();
        }

        public void markAllInvalid() {
            this.invalidExecutors.addAll(this.executorScoreMap.keySet());
        }

        public boolean isInvalid(MappingWorksheet.ExecutorChunk executor) {
            return this.invalidExecutors.contains(executor);
        }

        public boolean isInvalid(Node node) {
            return this.isInvalid(this.nodeExecutorMap.get(node));
        }

        public class ExecutorComparator
        implements Comparator<MappingWorksheet.ExecutorChunk> {
            @Override
            public int compare(MappingWorksheet.ExecutorChunk o1, MappingWorksheet.ExecutorChunk o2) {
                return NodesScore.this.getScore(o2) - NodesScore.this.getScore(o1);
            }
        }
    }
}

