// CHECKSTYLE:OFF

package jp.ikedam.jenkins.plugins.scoringloadbalancer.rules;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code BuildResultScoringRule.numberOfBuilds.required}: {@code
     * Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static String BuildResultScoringRule_numberOfBuilds_required() {
        return holder.format("BuildResultScoringRule.numberOfBuilds.required");
    }

    /**
     * Key {@code BuildResultScoringRule.numberOfBuilds.required}: {@code
     * Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static Localizable _BuildResultScoringRule_numberOfBuilds_required() {
        return new Localizable(holder, "BuildResultScoringRule.numberOfBuilds.required");
    }

    /**
     * Key {@code BuildResultScoringRule.DisplayName}: {@code Scoring by
     * Build Results}.
     * 
     * @return
     *     {@code Scoring by Build Results}
     */
    public static String BuildResultScoringRule_DisplayName() {
        return holder.format("BuildResultScoringRule.DisplayName");
    }

    /**
     * Key {@code BuildResultScoringRule.DisplayName}: {@code Scoring by
     * Build Results}.
     * 
     * @return
     *     {@code Scoring by Build Results}
     */
    public static Localizable _BuildResultScoringRule_DisplayName() {
        return new Localizable(holder, "BuildResultScoringRule.DisplayName");
    }

    /**
     * Key {@code NodePreferenceScoringRule.DisplayName}: {@code Scoring by
     * Node Preferences}.
     * 
     * @return
     *     {@code Scoring by Node Preferences}
     */
    public static String NodePreferenceScoringRule_DisplayName() {
        return holder.format("NodePreferenceScoringRule.DisplayName");
    }

    /**
     * Key {@code NodePreferenceScoringRule.DisplayName}: {@code Scoring by
     * Node Preferences}.
     * 
     * @return
     *     {@code Scoring by Node Preferences}
     */
    public static Localizable _NodePreferenceScoringRule_DisplayName() {
        return new Localizable(holder, "NodePreferenceScoringRule.DisplayName");
    }

    /**
     * Key {@code BuildResultScoringRule.numberOfBuilds.invalid}: {@code
     * Invalid value. This must be a positive integer.}.
     * 
     * @return
     *     {@code Invalid value. This must be a positive integer.}
     */
    public static String BuildResultScoringRule_numberOfBuilds_invalid() {
        return holder.format("BuildResultScoringRule.numberOfBuilds.invalid");
    }

    /**
     * Key {@code BuildResultScoringRule.numberOfBuilds.invalid}: {@code
     * Invalid value. This must be a positive integer.}.
     * 
     * @return
     *     {@code Invalid value. This must be a positive integer.}
     */
    public static Localizable _BuildResultScoringRule_numberOfBuilds_invalid() {
        return new Localizable(holder, "BuildResultScoringRule.numberOfBuilds.invalid");
    }

    /**
     * Key {@code NodeLoadScoringRule.DisplayName}: {@code Scoring by Node
     * Loads}.
     * 
     * @return
     *     {@code Scoring by Node Loads}
     */
    public static String NodeLoadScoringRule_DisplayName() {
        return holder.format("NodeLoadScoringRule.DisplayName");
    }

    /**
     * Key {@code NodeLoadScoringRule.DisplayName}: {@code Scoring by Node
     * Loads}.
     * 
     * @return
     *     {@code Scoring by Node Loads}
     */
    public static Localizable _NodeLoadScoringRule_DisplayName() {
        return new Localizable(holder, "NodeLoadScoringRule.DisplayName");
    }

}
