/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.scoringloadbalancer.rules;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Queue;
import hudson.model.queue.MappingWorksheet;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.ScoringLoadBalancer;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.ScoringRule;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.rules.Messages;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.util.ValidationUtil;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class NodeLoadScoringRule
extends ScoringRule {
    private int scale;
    private int scoreForIdleExecutor;
    private int scoreForBusyExecutor;

    public int getScale() {
        return this.scale;
    }

    public int getScoreForIdleExecutor() {
        return this.scoreForIdleExecutor;
    }

    public int getScoreForBusyExecutor() {
        return this.scoreForBusyExecutor;
    }

    @DataBoundConstructor
    public NodeLoadScoringRule(int scale, int scoreForIdleExecutor, int scoreForBusyExecutor) {
        this.scale = scale;
        this.scoreForIdleExecutor = scoreForIdleExecutor;
        this.scoreForBusyExecutor = scoreForBusyExecutor;
    }

    @Override
    public boolean updateScores(Queue.Task task, MappingWorksheet.WorkChunk wc, MappingWorksheet.Mapping m, ScoringLoadBalancer.NodesScore nodesScore) {
        for (MappingWorksheet.ExecutorChunk ec : nodesScore.getExecutorChunks()) {
            int idle = ec.capacity();
            for (int i = 0; i < m.size(); ++i) {
                if (!ec.equals((Object)m.assigned(i))) continue;
                idle -= m.get(i).size();
            }
            int busy = ec.computer.countExecutors() - idle;
            int busyScore = busy * this.getScoreForBusyExecutor();
            int idleScore = idle * this.getScoreForIdleExecutor();
            nodesScore.addScore(ec, (busyScore + idleScore) * this.getScale());
        }
        return true;
    }

    @Extension
    @Symbol(value={"nodeLoadScoringRule"})
    public static class DescriptorImpl
    extends Descriptor<ScoringRule> {
        public String getDisplayName() {
            return Messages.NodeLoadScoringRule_DisplayName();
        }

        @POST
        public FormValidation doCheckScale(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return ValidationUtil.doCheckInteger(value);
        }

        @POST
        public FormValidation doCheckScoreForIdleExecutor(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return ValidationUtil.doCheckInteger(value);
        }

        @POST
        public FormValidation doCheckScoreForBusyExecutor(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return ValidationUtil.doCheckInteger(value);
        }
    }
}

