/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.scoringloadbalancer.rules;

import hudson.Extension;
import hudson.Util;
import hudson.matrix.MatrixConfiguration;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.labels.LabelExpression;
import hudson.model.queue.MappingWorksheet;
import hudson.model.queue.SubTask;
import hudson.util.FormValidation;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.ScoringLoadBalancer;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.ScoringRule;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.preferences.BuildPreference;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.preferences.BuildPreferenceJobProperty;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.preferences.BuildPreferenceNodeProperty;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.rules.Messages;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.util.ValidationUtil;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class NodePreferenceScoringRule
extends ScoringRule {
    private static Logger LOGGER = Logger.getLogger(NodePreferenceScoringRule.class.getName());
    private int nodesPreferenceScale;
    private int projectPreferenceScale;

    public int getNodesPreferenceScale() {
        return this.nodesPreferenceScale;
    }

    public int getProjectPreferenceScale() {
        return this.projectPreferenceScale;
    }

    @DataBoundConstructor
    public NodePreferenceScoringRule(int nodesPreferenceScale, int projectPreferenceScale) {
        this.nodesPreferenceScale = nodesPreferenceScale;
        this.projectPreferenceScale = projectPreferenceScale;
    }

    @Override
    public boolean updateScores(Queue.Task task, MappingWorksheet.WorkChunk wc, MappingWorksheet.Mapping m, ScoringLoadBalancer.NodesScore nodesScore) {
        for (Node node : nodesScore.getNodes()) {
            List prefList = Util.filter((List)node.getNodeProperties(), BuildPreferenceNodeProperty.class);
            if (prefList == null || prefList.isEmpty()) continue;
            BuildPreferenceNodeProperty pref = (BuildPreferenceNodeProperty)((Object)prefList.get(0));
            nodesScore.addScore(node, pref.getPreference() * this.getNodesPreferenceScale());
        }
        for (SubTask subtask : wc) {
            BuildPreferenceJobProperty prefs = this.getBuildPreferenceJobProperty(subtask);
            if (prefs == null || prefs.getBuildPreferenceList() == null) continue;
            for (BuildPreference pref : prefs.getBuildPreferenceList()) {
                try {
                    Label l = LabelExpression.parseExpression((String)pref.getLabelExpression());
                    for (Node node : nodesScore.getNodes()) {
                        if (!l.contains(node)) continue;
                        nodesScore.addScore(node, pref.getPreference() * this.getProjectPreferenceScale());
                    }
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(Level.WARNING, String.format("Skipped an invalid label: %s (configured in %s)", pref.getLabelExpression(), subtask.toString()), e);
                }
            }
        }
        return true;
    }

    private BuildPreferenceJobProperty getBuildPreferenceJobProperty(SubTask subtask) {
        if (!(subtask instanceof Job)) {
            return null;
        }
        if (subtask instanceof MatrixConfiguration) {
            MatrixConfiguration conf = (MatrixConfiguration)subtask;
            return (BuildPreferenceJobProperty)conf.getParent().getProperty(BuildPreferenceJobProperty.class);
        }
        Job job = (Job)subtask;
        return (BuildPreferenceJobProperty)job.getProperty(BuildPreferenceJobProperty.class);
    }

    @Extension
    @Symbol(value={"nodePreferenceScoringRule"})
    public static class DescriptorImpl
    extends Descriptor<ScoringRule> {
        public String getDisplayName() {
            return Messages.NodePreferenceScoringRule_DisplayName();
        }

        @POST
        public FormValidation doCheckNodesPreferenceScale(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return ValidationUtil.doCheckInteger(value);
        }

        @POST
        public FormValidation doCheckProjectPreferenceScale(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return ValidationUtil.doCheckInteger(value);
        }
    }
}

