/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.scoringloadbalancer.preferences;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Label;
import hudson.model.labels.LabelExpression;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.StringTokenizer;
import jenkins.model.Jenkins;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.preferences.Messages;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.util.ValidationUtil;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class BuildPreference
extends AbstractDescribableImpl<BuildPreference> {
    private String labelExpression;
    private int preference;

    public String getLabelExpression() {
        return this.labelExpression;
    }

    public int getPreference() {
        return this.preference;
    }

    @DataBoundConstructor
    public BuildPreference(String labelExpression, int preference) {
        this.labelExpression = labelExpression == null ? null : labelExpression.trim();
        this.preference = preference;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<BuildPreference> {
        public String getDisplayName() {
            return "Preference for Nodes used in Building";
        }

        @POST
        public AutoCompletionCandidates doAutoCompleteLabelExpression(@QueryParameter String value, @AncestorInPath Item item) {
            if (item == null) {
                Jenkins.get().checkPermission(Item.CONFIGURE);
            } else {
                item.checkPermission(Item.CONFIGURE);
            }
            AutoCompletionCandidates c = new AutoCompletionCandidates();
            if (value == null || value.length() == 0) {
                return c;
            }
            Set labels = Jenkins.get().getLabels();
            StringTokenizer t = new StringTokenizer(value);
            String currentValue = null;
            while (t.hasMoreTokens()) {
                currentValue = t.nextToken();
            }
            if (currentValue == null || currentValue.length() == 0) {
                return c;
            }
            ArrayList<String> cands = new ArrayList<String>();
            for (Label l : labels) {
                if (!l.getName().startsWith(currentValue)) continue;
                cands.add(l.getName());
            }
            Collections.sort(cands);
            for (String s : cands) {
                c.add(s);
            }
            return c;
        }

        @POST
        public FormValidation doCheckLabelExpression(@QueryParameter String value, @AncestorInPath Item item) {
            if (item == null) {
                Jenkins.get().checkPermission(Item.CONFIGURE);
            } else {
                item.checkPermission(Item.CONFIGURE);
            }
            if (value == null || value.isBlank()) {
                return FormValidation.error((String)Messages.BuildPreference_labelExpression_requied());
            }
            try {
                Label l = LabelExpression.parseExpression((String)value);
                if (l.getNodes().isEmpty()) {
                    return FormValidation.warning((String)Messages.BuildPreference_labelExpression_empty());
                }
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((Throwable)e, (String)Messages.BuildPreference_labelExpression_invalid());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckPreference(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return ValidationUtil.doCheckInteger(value);
        }
    }
}

