/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.extensible_choice_parameter;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.util.FormValidation;
import hudson.util.VariableResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ChoiceListProvider;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ChoiceListProviderDescriptor;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.Messages;
import net.sf.json.JSONObject;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.export.Exported;

public class ExtensibleChoiceParameterDefinition
extends SimpleParameterDefinition {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ExtensibleChoiceParameterDefinition.class.getName());
    private static final Pattern namePattern = Pattern.compile("[A-Za-z_][A-Za-z_0-9]*");
    private boolean editable = false;
    private EditableType editableType;
    private ChoiceListProvider choiceListProvider = null;

    @Deprecated
    public static Pattern getNamePattern() {
        return namePattern;
    }

    public boolean isEditable() {
        return this.editable;
    }

    @NonNull
    public EditableType getEditableType() {
        return this.editableType != null ? this.editableType : EditableType.NoFilter;
    }

    @DataBoundSetter
    public void setEditableType(EditableType editableType) {
        this.editableType = editableType;
    }

    public ChoiceListProvider getChoiceListProvider() {
        return this.choiceListProvider;
    }

    public ChoiceListProvider getEnabledChoiceListProvider() {
        ChoiceListProvider p = this.getChoiceListProvider();
        if (p == null) {
            return null;
        }
        List testList = DescriptorVisibilityFilter.apply((Object)this.getDescriptor(), Arrays.asList(p.getDescriptor()));
        if (testList.isEmpty()) {
            LOGGER.log(Level.WARNING, "{0} is configured but disabled in the system configuration.", p.getDescriptor().getDisplayName());
            return null;
        }
        return p;
    }

    public List<String> getChoiceList() {
        ChoiceListProvider provider = this.getEnabledChoiceListProvider();
        ArrayList choiceList = provider != null ? provider.getChoiceList() : null;
        return choiceList != null ? choiceList : new ArrayList(0);
    }

    @Restricted(value={DoNotUse.class})
    @Exported(name="choices")
    public List<String> getChoicesForRestApi() {
        Job job;
        boolean requiresBuildPermission;
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req == null) {
            return null;
        }
        ChoiceListProvider provider = this.getEnabledChoiceListProvider();
        boolean bl = requiresBuildPermission = provider != null && provider.requiresBuildPermission();
        if (requiresBuildPermission && ((job = (Job)req.findAncestorObject(Job.class)) == null || !job.hasPermission(Item.BUILD))) {
            return Collections.emptyList();
        }
        return this.getChoiceList();
    }

    @DataBoundConstructor
    public ExtensibleChoiceParameterDefinition(String name, ChoiceListProvider choiceListProvider, boolean editable, String description) {
        super(name != null ? name.trim() : "", description);
        this.choiceListProvider = choiceListProvider;
        this.editable = editable;
    }

    protected ParameterValue createValueCommon(StringParameterValue value) {
        if (!this.isEditable() && !this.getChoiceList().contains(value.getValue())) {
            throw new IllegalArgumentException(String.format("Illegal choice '%s' in parameter '%s'", value.getValue(), value.getName()));
        }
        return value;
    }

    public ParameterValue createValue(StaplerRequest2 request, JSONObject jo) {
        StringParameterValue value = (StringParameterValue)request.bindJSON(StringParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return this.createValueCommon(value);
    }

    public ParameterValue createValue(String value) throws IllegalArgumentException {
        return this.createValueCommon(new StringParameterValue(this.getName(), value, this.getDescription()));
    }

    public ParameterValue getDefaultParameterValue() {
        List<String> choiceList;
        String defaultChoice;
        ChoiceListProvider p = this.getEnabledChoiceListProvider();
        String string = defaultChoice = p != null ? p.getDefaultChoice() : null;
        if (defaultChoice != null) {
            try {
                return this.createValue(defaultChoice);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.WARNING, "Illegal choice for the default value. Ignore and use the value in the top of the list instead.", e);
            }
        }
        return (choiceList = this.getChoiceList()).size() <= 0 ? null : new StringParameterValue(this.getName(), choiceList.get(0), this.getDescription());
    }

    public static enum EditableType {
        NoFilter(Messages._ExtensibleChoiceParameterDefinition_EditableType_NoFilter()),
        Filter(Messages._ExtensibleChoiceParameterDefinition_EditableType_Filter());

        private final Localizable displayName;

        private EditableType(Localizable displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName.toString();
        }
    }

    @Extension
    public static class DescriptorVisibilityFilterImpl
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, Descriptor descriptor) {
            if (!(context instanceof DescriptorImpl)) {
                return true;
            }
            return ((DescriptorImpl)((Object)context)).isProviderEnabled(descriptor);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        private Map<String, Boolean> choiceListEnabledMap;

        public DescriptorImpl() {
            this.setChoiceListEnabledMap(Collections.emptyMap());
            this.load();
        }

        protected void setChoiceListEnabledMap(Map<String, Boolean> choiceListEnabledMap) {
            this.choiceListEnabledMap = choiceListEnabledMap;
        }

        protected Map<String, Boolean> getChoiceListEnabledMap() {
            return this.choiceListEnabledMap;
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            HashMap<String, Boolean> configuredChoiceListEnableMap = new HashMap<String, Boolean>();
            for (Descriptor d : this.getChoiceListProviderList()) {
                String name = d.getJsonSafeClassName();
                JSONObject o = json.optJSONObject(name);
                if (o != null) {
                    configuredChoiceListEnableMap.put(d.getId(), true);
                    if (!(d instanceof ChoiceListProviderDescriptor)) continue;
                    d.configure(req, o);
                    continue;
                }
                configuredChoiceListEnableMap.put(d.getId(), false);
            }
            this.setChoiceListEnabledMap(configuredChoiceListEnableMap);
            this.save();
            return super.configure(req, json);
        }

        public boolean isProviderEnabled(Descriptor<?> d) {
            Boolean b = this.getChoiceListEnabledMap().get(d.getId());
            if (b != null) {
                return b;
            }
            if (!(d instanceof ChoiceListProviderDescriptor)) {
                return true;
            }
            return ((ChoiceListProviderDescriptor)d).isEnabledByDefault();
        }

        public ExtensibleChoiceParameterDefinition newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            ExtensibleChoiceParameterDefinition def = new ExtensibleChoiceParameterDefinition(formData.getString("name"), this.bindJSONWithDescriptor(req, formData, "choiceListProvider", ChoiceListProvider.class), formData.getBoolean("editable"), formData.getString("description"));
            if (formData.containsKey((Object)"editableType")) {
                def.setEditableType(EditableType.valueOf(formData.getString("editableType")));
            }
            return def;
        }

        private <T extends Describable<?>> T bindJSONWithDescriptor(StaplerRequest2 req, JSONObject formData, String fieldName, Class<T> clazz) throws Descriptor.FormException {
            if ((formData = formData.getJSONObject(fieldName)) == null || formData.isNullObject()) {
                return null;
            }
            String staplerClazzName = formData.optString("$class", null);
            if (staplerClazzName == null) {
                staplerClazzName = formData.optString("stapler-class", null);
            }
            if (staplerClazzName == null) {
                throw new Descriptor.FormException("No $stapler nor stapler-class is specified", fieldName);
            }
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                throw new IllegalStateException("Jenkins instance is unavailable.");
            }
            try {
                Class<?> staplerClass = jenkins.getPluginManager().uberClassLoader.loadClass(staplerClazzName);
                Descriptor d = jenkins.getDescriptorOrDie(staplerClass);
                Describable instance = d.newInstance(req, formData);
                return (T)instance;
            }
            catch (ClassNotFoundException e) {
                throw new Descriptor.FormException(String.format("Failed to instantiate %s", staplerClazzName), (Throwable)e, fieldName);
            }
        }

        public String getDisplayName() {
            return Messages._ExtensibleChoiceParameterDefinition_DisplayName().toString();
        }

        public DescriptorExtensionList<ChoiceListProvider, Descriptor<ChoiceListProvider>> getChoiceListProviderList() {
            return ChoiceListProvider.all();
        }

        public List<Descriptor<ChoiceListProvider>> getEnabledChoiceListProviderList() {
            return DescriptorVisibilityFilter.apply((Object)((Object)this), ChoiceListProvider.all());
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            if (name == null || name.trim().isEmpty()) {
                return FormValidation.error((String)Messages.ExtensibleChoiceParameterDefinition_Name_empty());
            }
            final String trimmedName = name.trim();
            String EXPANDED = "GOOD";
            String expanded = Util.replaceMacro((String)String.format("${%s}", trimmedName), (VariableResolver)new VariableResolver<String>(){
                final /* synthetic */ DescriptorImpl this$0;
                {
                    this.this$0 = this$0;
                }

                public String resolve(String name) {
                    if (trimmedName.equals(name)) {
                        return "GOOD";
                    }
                    return null;
                }
            });
            if (!"GOOD".equals(expanded)) {
                return FormValidation.warning((String)Messages.ExtensibleChoiceParameterDefinition_Name_invalid());
            }
            return FormValidation.ok();
        }
    }
}

