/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.extensible_choice_parameter;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.AddEditedChoiceListProvider;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ChoiceListProviderDescriptor;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ExtensibleChoiceParameterDefinition;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.GlobalTextareaChoiceListEntry;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.Messages;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class GlobalTextareaChoiceListProvider
extends AddEditedChoiceListProvider {
    private static final long serialVersionUID = 2L;
    private static final String NoDefaultChoice = "###NODEFAULTCHOICE###";
    private static final Logger LOGGER = Logger.getLogger(GlobalTextareaChoiceListProvider.class.getName());
    private String name = null;
    private String defaultChoice = null;

    public String getName() {
        return this.name;
    }

    @Override
    public String getDefaultChoice() {
        return this.defaultChoice;
    }

    @Override
    public List<String> getChoiceList() {
        return ((DescriptorImpl)this.getDescriptor()).getChoiceList(this.getName());
    }

    @DataBoundConstructor
    public GlobalTextareaChoiceListProvider(String name, String defaultChoice, boolean addEditedValue, AddEditedChoiceListProvider.WhenToAdd whenToAdd) {
        super(addEditedValue, whenToAdd);
        this.name = name;
        this.defaultChoice = !NoDefaultChoice.equals(defaultChoice) ? defaultChoice : null;
    }

    @Override
    protected void addEditedValue(AbstractProject<?, ?> project, ExtensibleChoiceParameterDefinition def, String value) {
        DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
        GlobalTextareaChoiceListEntry entry = descriptor.getChoiceListEntry(this.getName());
        if (entry == null) {
            LOGGER.warning(String.format("Requested to add a new value %s to parameter %s(%s) in project %s, but the choice list does not exist.", value, def.getName(), this.getName(), project.getName()));
            return;
        }
        if (!entry.isAllowAddEditedValue()) {
            LOGGER.warning(String.format("Requested to add a new value %s to parameter %s(%s) in project %s, but the choice list is not configured to allow that.", value, def.getName(), this.getName(), project.getName()));
            return;
        }
        LOGGER.info(String.format("Add a new value %s to parameter %s(%s) in project %s", value, def.getName(), this.getName(), project.getName()));
        entry.addEditedValue(value);
        try {
            descriptor.save();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to add choice value", e);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ChoiceListProviderDescriptor {
        private List<GlobalTextareaChoiceListEntry> choiceListEntryList;

        public DescriptorImpl() {
            this.load();
        }

        public List<GlobalTextareaChoiceListEntry> getChoiceListEntryList() {
            return this.choiceListEntryList;
        }

        public void setChoiceListEntryList(List<GlobalTextareaChoiceListEntry> choiceListEntryList) {
            this.choiceListEntryList = choiceListEntryList == null ? new ArrayList<GlobalTextareaChoiceListEntry>(0) : (List)CollectionUtils.select(choiceListEntryList, (Predicate)new Predicate(){

                public boolean evaluate(Object entry) {
                    return ((GlobalTextareaChoiceListEntry)entry).isValid();
                }
            });
        }

        public ListBoxModel doFillNameItems() {
            ListBoxModel m = new ListBoxModel();
            if (this.getChoiceListEntryList() != null) {
                for (GlobalTextareaChoiceListEntry e : this.getChoiceListEntryList()) {
                    m.add(e.getName());
                }
            }
            return m;
        }

        public ListBoxModel doFillDefaultChoiceItems(@QueryParameter String name) {
            ListBoxModel ret = new ListBoxModel();
            ret.add(Messages.ExtensibleChoiceParameterDefinition_NoDefaultChoice(), GlobalTextareaChoiceListProvider.NoDefaultChoice);
            List<String> choices = this.getChoiceList(name);
            for (String choice : choices) {
                ret.add(choice);
            }
            return ret;
        }

        public String getNoDefaultChoice() {
            return GlobalTextareaChoiceListProvider.NoDefaultChoice;
        }

        public GlobalTextareaChoiceListEntry getChoiceListEntry(String name) {
            if (this.getChoiceListEntryList() == null) {
                return null;
            }
            for (GlobalTextareaChoiceListEntry e : this.getChoiceListEntryList()) {
                if (!e.getName().equals(name)) continue;
                return e;
            }
            return null;
        }

        public List<String> getChoiceList(String name) {
            GlobalTextareaChoiceListEntry e = this.getChoiceListEntry(name);
            return e != null ? e.getChoiceList() : new ArrayList<String>();
        }

        public String getDisplayName() {
            return Messages._GlobalTextareaChoiceListProvider_DisplayName().toString();
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            this.setChoiceListEntryList(req.bindJSONToList(GlobalTextareaChoiceListEntry.class, formData.get("choiceListEntryList")));
            this.save();
            return super.configure(req, formData);
        }
    }
}

