/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.extensible_choice_parameter;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.Messages;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.utility.TextareaStringListUtility;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class GlobalTextareaChoiceListEntry
extends AbstractDescribableImpl<GlobalTextareaChoiceListEntry>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern namePattern = Pattern.compile("[A-Za-z_][A-Za-z_0-9]*");
    private String name = null;
    private List<String> choiceList = null;
    private boolean allowAddEditedValue;

    public static Pattern getNamePattern() {
        return namePattern;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getChoiceList() {
        return this.choiceList;
    }

    public String getChoiceListText() {
        return TextareaStringListUtility.textareaFromStringList(this.getChoiceList());
    }

    protected void setChoiceList(List<String> choiceList) {
        this.choiceList = choiceList;
    }

    public boolean isAllowAddEditedValue() {
        return this.allowAddEditedValue;
    }

    @DataBoundConstructor
    public GlobalTextareaChoiceListEntry(String name, String choiceListText, boolean allowAddEditedValue) {
        this.name = name != null ? name.trim() : "";
        this.choiceList = TextareaStringListUtility.stringListFromTextarea(choiceListText);
        this.allowAddEditedValue = allowAddEditedValue;
    }

    public boolean isValid() {
        DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
        FormValidation v = descriptor.doCheckName(this.name);
        return v.kind != FormValidation.Kind.ERROR;
    }

    public void addEditedValue(String value) {
        ArrayList<String> newChoiceList = new ArrayList<String>(this.getChoiceList());
        newChoiceList.add(value);
        this.setChoiceList(newChoiceList);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GlobalTextareaChoiceListEntry)) {
            return false;
        }
        GlobalTextareaChoiceListEntry entry = (GlobalTextareaChoiceListEntry)o;
        if (this.name == null ? entry.name != null : !this.name.equals(entry.name)) {
            return false;
        }
        return !(this.choiceList == null ? entry.choiceList != null : !this.choiceList.equals(entry.choiceList));
    }

    public int hashCode() {
        int r = this.name != null ? this.name.hashCode() : 0;
        r = r * 31 + (this.choiceList != null ? this.choiceList.hashCode() : 0);
        return r;
    }

    public String toString() {
        return String.format("[%s: name=%s, choiceList=%s]", this.getClass().getName(), this.getName(), StringUtils.join(this.getChoiceList(), (String)","));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<GlobalTextareaChoiceListEntry> {
        public String getDisplayName() {
            return "GlobalTextareaChoiceListEntry";
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            if (StringUtils.isBlank((String)name)) {
                return FormValidation.error((String)Messages.GlobalTextareaChoiceListEntry_Name_empty());
            }
            if (!GlobalTextareaChoiceListEntry.getNamePattern().matcher(name.trim()).matches()) {
                return FormValidation.error((String)Messages.GlobalTextareaChoiceListEntry_Name_invalid());
            }
            return FormValidation.ok();
        }
    }
}

