/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.extensible_choice_parameter;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ChoiceListProvider;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.Messages;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FilenameChoiceListProvider
extends ChoiceListProvider {
    private static final long serialVersionUID = 1329937323978223039L;
    private final String baseDirPath;
    private final String includePattern;
    private final ScanType scanType;
    private final String excludePattern;
    private final boolean reverseOrder;
    private final EmptyChoiceType emptyChoiceType;

    public String getBaseDirPath() {
        return this.baseDirPath;
    }

    protected static File getBaseDir(String baseDirPath) {
        File rawDir = new File(baseDirPath);
        if (rawDir.isAbsolute()) {
            return rawDir;
        }
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins instance is unavailable.");
        }
        return new File(jenkins.getRootDir(), baseDirPath);
    }

    protected File getBaseDir() {
        return FilenameChoiceListProvider.getBaseDir(this.getBaseDirPath());
    }

    public String getIncludePattern() {
        return this.includePattern;
    }

    public ScanType getScanType() {
        return this.scanType;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public boolean isReverseOrder() {
        return this.reverseOrder;
    }

    public EmptyChoiceType getEmptyChoiceType() {
        return this.emptyChoiceType;
    }

    @DataBoundConstructor
    public FilenameChoiceListProvider(String baseDirPath, String includePattern, String excludePattern, ScanType scanType, boolean reverseOrder, EmptyChoiceType emptyChoiceType) {
        this.baseDirPath = StringUtils.trim((String)baseDirPath);
        this.includePattern = StringUtils.trim((String)includePattern);
        this.excludePattern = StringUtils.trim((String)excludePattern);
        this.scanType = scanType;
        this.reverseOrder = reverseOrder;
        this.emptyChoiceType = emptyChoiceType;
    }

    @Deprecated
    public FilenameChoiceListProvider(String baseDirPath, String includePattern, String excludePattern, ScanType scanType, boolean reverseOrder) {
        this(baseDirPath, includePattern, excludePattern, scanType, reverseOrder, EmptyChoiceType.None);
    }

    @Deprecated
    public FilenameChoiceListProvider(String baseDirPath, String includePattern, String excludePattern, ScanType scanType) {
        this(baseDirPath, includePattern, excludePattern, scanType, false);
    }

    protected static List<String> getFileList(File baseDir, String includePattern, String excludePattern, ScanType scanType, boolean reverseOrder, EmptyChoiceType emptyChoiceType) {
        if (baseDir == null || !baseDir.exists() || !baseDir.isDirectory()) {
            return new ArrayList<String>(0);
        }
        if (StringUtils.isBlank((String)includePattern)) {
            return new ArrayList<String>(0);
        }
        if (scanType == null) {
            scanType = ScanType.File;
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(baseDir);
        ds.setIncludes(includePattern.split("\\s*,(?:\\s*,)*\\s*"));
        if (!StringUtils.isBlank((String)excludePattern)) {
            ds.setExcludes(excludePattern.split("\\s*,(?:\\s*,)*\\s*"));
        }
        ds.scan();
        ArrayList<String> ret = null;
        switch (scanType) {
            case FileAndDirectory: {
                ret = new ArrayList(ds.getIncludedDirsCount() + ds.getIncludedFilesCount());
                for (String file : ds.getIncludedFiles()) {
                    ret.add(file);
                }
                for (String dir : ds.getIncludedDirectories()) {
                    ret.add(dir);
                }
                Collections.sort(ret);
                break;
            }
            case Directory: {
                ret = new ArrayList<String>(Arrays.asList(ds.getIncludedDirectories()));
                break;
            }
            default: {
                ret = new ArrayList<String>(Arrays.asList(ds.getIncludedFiles()));
            }
        }
        if (reverseOrder) {
            Collections.reverse(ret);
        }
        if (emptyChoiceType == null) {
            emptyChoiceType = EmptyChoiceType.None;
        }
        switch (emptyChoiceType) {
            case None: {
                break;
            }
            case AtTop: {
                ret.add(0, "");
                break;
            }
            case AtEnd: {
                ret.add("");
            }
        }
        return ret;
    }

    @Deprecated
    protected static List<String> getFileList(File baseDir, String includePattern, String excludePattern, ScanType scanType, boolean reverseOrder) {
        return FilenameChoiceListProvider.getFileList(baseDir, includePattern, excludePattern, scanType, reverseOrder, EmptyChoiceType.None);
    }

    @Deprecated
    protected static List<String> getFileList(File baseDir, String includePattern, String excludePattern, ScanType scanType) {
        return FilenameChoiceListProvider.getFileList(baseDir, includePattern, excludePattern, scanType, false);
    }

    @Override
    public List<String> getChoiceList() {
        return FilenameChoiceListProvider.getFileList(this.getBaseDir(), this.getIncludePattern(), this.getExcludePattern(), this.getScanType(), this.isReverseOrder(), this.getEmptyChoiceType());
    }

    public static enum ScanType {
        File(Messages._FilenameChoiceListProvider_ScanType_File()),
        Directory(Messages._FilenameChoiceListProvider_ScanType_Directory()),
        FileAndDirectory(Messages._FilenameChoiceListProvider_ScanType_FileAndDirectory());

        private Localizable name;

        private ScanType(Localizable name) {
            this.name = name;
        }

        public String toString() {
            return this.name.toString();
        }
    }

    public static enum EmptyChoiceType {
        None(Messages._FilenameChoiceListProvider_EmptyChoiceType_None()),
        AtTop(Messages._FilenameChoiceListProvider_EmptyChoiceType_AtTop()),
        AtEnd(Messages._FilenameChoiceListProvider_EmptyChoiceType_AtEnd());

        private Localizable name;

        private EmptyChoiceType(Localizable name) {
            this.name = name;
        }

        public String toString() {
            return this.name.toString();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ChoiceListProvider> {
        public String getDisplayName() {
            return Messages.FilenameChoiceListProvider_DisplayName();
        }

        public FormValidation doCheckBaseDirPath(@QueryParameter String baseDirPath) {
            if (StringUtils.isBlank((String)baseDirPath)) {
                return FormValidation.error((String)Messages.FilenameChoiceListProvider_BaseDirPath_empty());
            }
            File baseDir = FilenameChoiceListProvider.getBaseDir(baseDirPath);
            if (!baseDir.exists() || !baseDir.isDirectory()) {
                return FormValidation.warning((String)Messages.FilenameChoiceListProvider_BaseDirPath_empty());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIncludePattern(@QueryParameter String includePattern) {
            if (StringUtils.isBlank((String)includePattern)) {
                return FormValidation.error((String)Messages.FilenameChoiceListProvider_IncludePattern_empty());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckExcludePattern(@QueryParameter String excludePattern) {
            return FormValidation.ok();
        }

        public FormValidation doTest(@QueryParameter String baseDirPath, @QueryParameter String includePattern, @QueryParameter String excludePattern, @QueryParameter ScanType scanType, @QueryParameter boolean reverseOrder, @QueryParameter EmptyChoiceType emptyChoiceType) {
            List<String> fileList = FilenameChoiceListProvider.getFileList(FilenameChoiceListProvider.getBaseDir(baseDirPath), includePattern, excludePattern, scanType, reverseOrder, emptyChoiceType);
            if (fileList.isEmpty()) {
                return FormValidation.ok((String)"(No file matched)");
            }
            return FormValidation.ok((String)StringUtils.join(fileList, (char)'\n'));
        }
    }
}

