/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.extensible_choice_parameter;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.AddEditedChoiceListProvider;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ChoiceListProvider;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ExtensibleChoiceParameterDefinition;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.Messages;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.utility.TextareaStringListUtility;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TextareaChoiceListProvider
extends AddEditedChoiceListProvider {
    private static final long serialVersionUID = 2L;
    private static final String NoDefaultChoice = "###NODEFAULTCHOICE###";
    private static final Logger LOGGER = Logger.getLogger(TextareaChoiceListProvider.class.getName());
    private List<String> choiceList = null;
    private String defaultChoice = null;

    @Override
    public List<String> getChoiceList() {
        return this.choiceList;
    }

    protected void setChoiceList(List<String> choiceList) {
        this.choiceList = choiceList;
    }

    public String getChoiceListText() {
        return TextareaStringListUtility.textareaFromStringList(this.getChoiceList());
    }

    @Override
    public String getDefaultChoice() {
        return this.defaultChoice;
    }

    @Override
    public boolean requiresBuildPermission() {
        return false;
    }

    @DataBoundConstructor
    public TextareaChoiceListProvider(String choiceListText, String defaultChoice, boolean addEditedValue, AddEditedChoiceListProvider.WhenToAdd whenToAdd) {
        super(addEditedValue, whenToAdd);
        this.setChoiceList(TextareaStringListUtility.stringListFromTextarea(choiceListText));
        this.defaultChoice = !NoDefaultChoice.equals(defaultChoice) ? defaultChoice : null;
    }

    @Override
    protected void addEditedValue(AbstractProject<?, ?> project, ExtensibleChoiceParameterDefinition def, String value) {
        LOGGER.info(String.format("Add new value %s to parameter %s in project %s", value, def.getName(), project.getName()));
        ArrayList<String> newChoiceList = new ArrayList<String>(this.getChoiceList());
        newChoiceList.add(value);
        this.setChoiceList(newChoiceList);
        try {
            project.save();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to add choice value", e);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ChoiceListProvider> {
        public String getDisplayName() {
            return Messages._TextareaChoiceListProvider_DisplayName().toString();
        }

        public ListBoxModel doFillDefaultChoiceItems(@QueryParameter String choiceListText) {
            ListBoxModel ret = new ListBoxModel();
            ret.add(Messages.ExtensibleChoiceParameterDefinition_NoDefaultChoice(), TextareaChoiceListProvider.NoDefaultChoice);
            List<String> choices = TextareaStringListUtility.stringListFromTextarea(choiceListText);
            for (String choice : choices) {
                ret.add(choice);
            }
            return ret;
        }

        public String getNoDefaultChoice() {
            return TextareaChoiceListProvider.NoDefaultChoice;
        }
    }
}

