/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.exclusive.label;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.labels.LabelAtom;
import hudson.model.labels.LabelVisitor;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.exclusive.label.ExclusiveLabelVisitor;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class ExclusiveLabels
extends QueueTaskDispatcher
implements Describable<ExclusiveLabels> {
    public List<LabelAtom> getExclusiveLabels() {
        return ((DescriptorImpl)this.getDescriptor()).getLabels();
    }

    public CauseOfBlockage canTake(Node node, Queue.BuildableItem item) {
        Label assignedLabel = item.task.getAssignedLabel();
        if (assignedLabel != null && !assignedLabel.contains(node)) {
            return null;
        }
        boolean containsExclusive = false;
        ArrayList<LabelAtom> exclusives = new ArrayList<LabelAtom>();
        for (LabelAtom atom : node.getAssignedLabels()) {
            if (!this.getExclusiveLabels().contains(atom)) continue;
            exclusives.add(atom);
            if (assignedLabel == null) {
                return new NotExclusiveLabel(node);
            }
            if (containsExclusive) continue;
            containsExclusive = assignedLabel.getName().contains(atom.getName());
        }
        if (exclusives.size() < 1) {
            return null;
        }
        if (!containsExclusive) {
            return new NotExclusiveLabel(node);
        }
        ExclusiveLabelVisitor visitor = new ExclusiveLabelVisitor();
        HashSet<LabelAtom> atoms = new HashSet<LabelAtom>();
        atoms.addAll(exclusives);
        if (!((Boolean)item.task.getAssignedLabel().accept((LabelVisitor)visitor, atoms)).booleanValue()) {
            return new NotExclusiveLabel(node);
        }
        return null;
    }

    public Descriptor<ExclusiveLabels> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ExclusiveLabels> {
        private transient List<LabelAtom> exclusiveLabels = new ArrayList<LabelAtom>();
        private String labelsInString;

        public DescriptorImpl() {
            this.load();
            this.exclusiveLabels = DescriptorImpl.parseLabels(this.labelsInString);
        }

        public List<LabelAtom> getLabels() {
            return this.exclusiveLabels;
        }

        public static List<LabelAtom> parseLabels(String token) {
            String[] labels;
            ArrayList<LabelAtom> atomLabels = new ArrayList<LabelAtom>();
            if (token == null || token.isEmpty()) {
                return atomLabels;
            }
            for (String label : labels = token.split(" ")) {
                atomLabels.add(new LabelAtom(label));
            }
            return atomLabels;
        }

        public String getLabelsInString() {
            return this.labelsInString;
        }

        public String getDisplayName() {
            return "Exclusive labels";
        }

        public boolean configure(StaplerRequest req, JSONObject res) {
            this.labelsInString = req.getParameter("exclusiveLabels");
            this.exclusiveLabels = DescriptorImpl.parseLabels(this.labelsInString);
            this.save();
            return true;
        }
    }

    public static class NotExclusiveLabel
    extends CauseOfBlockage {
        private Node node;

        public NotExclusiveLabel(Node node) {
            this.node = node;
        }

        public String getShortDescription() {
            return "Node " + this.node.getDisplayName() + " has exclusive label(s)";
        }
    }
}

