/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.maven.jellydoc;

import com.sun.source.doctree.BlockTagTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.util.DocTrees;
import com.sun.xml.txw2.TXW;
import com.sun.xml.txw2.TypedXmlWriter;
import com.sun.xml.txw2.output.StreamSerializer;
import com.sun.xml.txw2.output.XmlSerializer;
import java.beans.Introspector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import org.cyberneko.html.parsers.SAXParser;
import org.jvnet.maven.jellydoc.Attribute;
import org.jvnet.maven.jellydoc.Item;
import org.jvnet.maven.jellydoc.Library;
import org.jvnet.maven.jellydoc.Tag;
import org.jvnet.maven.jellydoc.Tags;
import org.jvnet.maven.jellydoc.annotation.NoContent;
import org.jvnet.maven.jellydoc.annotation.Required;
import org.jvnet.maven.jellydoc.annotation.TagLibUri;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TagXMLDoclet
implements Doclet {
    private DocTrees docTrees;
    private Reporter reporter;
    private String targetFileName = null;
    private String encodingFormat;

    private void main(DocletEnvironment root) throws Exception {
        File targetFile = new File(this.targetFileName);
        targetFile.getParentFile().mkdirs();
        FileOutputStream writer = new FileOutputStream(this.targetFileName);
        Tags tw = (Tags)TXW.create(Tags.class, (XmlSerializer)new StreamSerializer((OutputStream)writer));
        this.javadocXML(root, tw);
        tw.commit();
    }

    @Override
    public void init(Locale locale, Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public String getName() {
        return "TagXMLDoclet";
    }

    public Set<? extends Option> getSupportedOptions() {
        return Set.of(new Option("-d", "target directory", "<dir>", 1){

            @Override
            public boolean process(String opt, List<String> args) {
                TagXMLDoclet.this.targetFileName = args.get(0) + "/taglib.xml";
                return true;
            }
        });
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void javadocXML(DocletEnvironment root, Tags tw) throws SAXException {
        this.docTrees = root.getDocTrees();
        for (PackageElement pkg : ElementFilter.packagesIn(root.getIncludedElements())) {
            this.packageXML(pkg, tw);
        }
    }

    private void packageXML(PackageElement packageDoc, Tags tw) throws SAXException {
        System.out.println("processing package: " + String.valueOf(packageDoc.getQualifiedName()));
        boolean foundTag = false;
        for (TypeElement classDoc : ElementFilter.typesIn(packageDoc.getEnclosedElements())) {
            if (!this.isTag(classDoc)) continue;
            foundTag = true;
            break;
        }
        if (!foundTag) {
            return;
        }
        Library library = tw.library();
        library.name(packageDoc.getQualifiedName().toString());
        String name = packageDoc.getQualifiedName().toString();
        int idx = name.lastIndexOf(46);
        if (idx > 0) {
            name = name.substring(idx + 1);
        }
        library.prefix(name);
        Object uri = this.findUri(packageDoc.getAnnotationMirrors());
        if (uri == null) {
            uri = "jelly:" + name;
        }
        library.uri((String)uri);
        this.docXML(packageDoc, (Item)library);
        for (TypeElement c : ElementFilter.typesIn(packageDoc.getEnclosedElements())) {
            if (!this.isTag(c) || c.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            this.tagXML(c, library.tag());
        }
    }

    private String findUri(List<? extends AnnotationMirror> an) {
        for (AnnotationMirror annotationMirror : an) {
            if (!(annotationMirror.getAnnotationType().asElement() instanceof TypeElement) || !((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals(TagLibUri.class.getName())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                if (!e.getKey().getSimpleName().toString().equals("value")) continue;
                return e.getValue().toString();
            }
        }
        return null;
    }

    private boolean has(Element doc, Class<? extends Annotation> type) {
        for (AnnotationMirror annotationMirror : doc.getAnnotationMirrors()) {
            if (!(annotationMirror.getAnnotationType().asElement() instanceof TypeElement) || !((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isTag(TypeElement classDoc) {
        DeclaredType declaredType;
        Element element;
        List<? extends TypeMirror> interfaceArray = classDoc.getInterfaces();
        for (TypeMirror typeMirror : interfaceArray) {
            if (!"org.apache.commons.jelly.Tag".equals(typeMirror.toString())) continue;
            return true;
        }
        TypeMirror base = classDoc.getSuperclass();
        if (base instanceof DeclaredType && (element = (declaredType = (DeclaredType)base).asElement()) instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            return this.isTag(typeElement);
        }
        return false;
    }

    private void tagXML(TypeElement classDoc, Tag tag) throws SAXException {
        String name = classDoc.getSimpleName().toString();
        tag.className(name);
        if (name.endsWith("Tag")) {
            name = name.substring(0, name.length() - 3);
        }
        name = Introspector.decapitalize(name);
        System.out.println("processing tag: " + name);
        tag.name(name);
        if (this.has(classDoc, NoContent.class)) {
            tag.noContent(true);
        }
        this.docXML(classDoc, (Item)tag);
        this.propertiesXML(classDoc, tag);
    }

    private void propertiesXML(TypeElement classDoc, Tag tag) throws SAXException {
        DeclaredType declaredType;
        Element element;
        for (ExecutableElement m : ElementFilter.methodsIn(classDoc.getEnclosedElements())) {
            this.propertyXML(m, tag);
        }
        TypeMirror base = classDoc.getSuperclass();
        if (base instanceof DeclaredType && (element = (declaredType = (DeclaredType)base).asElement()) instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            this.propertiesXML(typeElement, tag);
        }
    }

    private void propertyXML(ExecutableElement methodDoc, Tag tag) throws SAXException {
        if (!methodDoc.getModifiers().contains((Object)Modifier.PUBLIC) || methodDoc.getModifiers().contains((Object)Modifier.STATIC)) {
            return;
        }
        String name = methodDoc.getSimpleName().toString();
        if (!name.startsWith("set")) {
            return;
        }
        List<? extends VariableElement> parameterArray = methodDoc.getParameters();
        if (parameterArray == null || parameterArray.size() != 1) {
            return;
        }
        VariableElement parameter = parameterArray.get(0);
        name = name.substring(3);
        if ((name = Introspector.decapitalize(name)).equals("body") || name.equals("context") || name.equals("parent")) {
            return;
        }
        Attribute a = tag.attribute();
        a.name(name);
        a.type(parameter.asType().toString());
        if (this.has(methodDoc, Required.class)) {
            a.use("required");
        }
        this.docXML(methodDoc, (Item)a);
    }

    private void docXML(Element doc, Item w) throws SAXException {
        TypedXmlWriter d = w.doc();
        DocCommentTree docCommentTree = this.docTrees.getDocCommentTree(doc);
        if (docCommentTree != null) {
            StringBuilder sb = new StringBuilder();
            for (DocTree docTree : docCommentTree.getFullBody()) {
                if (docTree instanceof LinkTree) {
                    LinkTree linkTree = (LinkTree)docTree;
                    List<? extends DocTree> label = linkTree.getLabel();
                    if (label == null || label.isEmpty()) {
                        ReferenceTree reference = linkTree.getReference();
                        sb.append(reference.toString());
                        continue;
                    }
                    for (DocTree docTree2 : label) {
                        sb.append(docTree2.toString());
                    }
                    continue;
                }
                if (docTree instanceof LiteralTree) {
                    sb.append(((LiteralTree)docTree).getBody().getBody());
                    continue;
                }
                sb.append(docTree.toString());
            }
            this.parseHTML(sb.toString(), d);
            for (DocTree docTree : docCommentTree.getBlockTags()) {
                if (!(docTree instanceof BlockTagTree)) continue;
                this.javadocTagXML((BlockTagTree)docTree, w);
            }
        }
    }

    protected void parseHTML(String text, final TypedXmlWriter d) throws SAXException {
        SAXParser parser = new SAXParser();
        parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
        parser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"lower");
        parser.setContentHandler((ContentHandler)new DefaultHandler(this){
            private Stack<TypedXmlWriter> w = new Stack();
            final /* synthetic */ TagXMLDoclet this$0;
            {
                this.this$0 = this$0;
                this.w.push(d);
            }

            @Override
            public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                if (this.this$0.validDocElementName(localName)) {
                    this.w.push(this.w.peek()._element(localName, TypedXmlWriter.class));
                }
            }

            @Override
            public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
                if (this.this$0.validDocElementName(localName)) {
                    this.w.pop();
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                this.w.peek()._pcdata((Object)new String(ch, start, length));
            }
        });
        try {
            parser.parse(new InputSource(new StringReader(text)));
        }
        catch (IOException e) {
            System.err.println("This should never happen!" + String.valueOf(e));
        }
    }

    protected boolean validDocElementName(String name) {
        return !name.equalsIgnoreCase("html") && !name.equalsIgnoreCase("body");
    }

    private void javadocTagXML(BlockTagTree tag, Item w) throws SAXException {
        String name = tag.getTagName() + "tag";
        String text = tag.toString().substring(tag.getTagName().length() + 2);
        if (!text.isEmpty()) {
            w._element(name, TypedXmlWriter.class)._pcdata((Object)text);
        }
    }

    @Override
    public boolean run(DocletEnvironment root) {
        if (this.targetFileName == null) {
            this.reporter.print(Diagnostic.Kind.ERROR, "Usage: javadoc -d <directory> -doclet TagXMLDoclet ...");
            return false;
        }
        try {
            this.main(root);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return false;
        }
    }

    private static abstract class Option
    implements Doclet.Option {
        private final String[] names;
        private final String parameters;
        private final String description;
        private final int argCount;

        protected Option(String name, String description, String parameters, int argCount) {
            this.names = name.trim().split("\\s+");
            this.description = description;
            this.parameters = parameters;
            this.argCount = argCount;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Doclet.Option.Kind getKind() {
            return Doclet.Option.Kind.STANDARD;
        }

        @Override
        public List<String> getNames() {
            return List.of(this.names);
        }

        @Override
        public String getParameters() {
            return this.parameters;
        }

        public String toString() {
            return Arrays.toString(this.names);
        }

        @Override
        public int getArgumentCount() {
            return this.argCount;
        }
    }
}

