/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.maven.jellydoc;

import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.MarkupParser;
import net.java.textilej.parser.builder.HtmlDocumentBuilder;
import net.java.textilej.parser.markup.Dialect;
import net.java.textilej.parser.markup.confluence.ConfluenceDialect;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ReferenceRenderer
extends AbstractMavenReportRenderer {
    private final Document taglibXml;
    private static final Comparator<Element> SORT_BY_NAME = Comparator.comparing(o -> o.attributeValue("name"));
    private static final Set<String> HIDDEN_ATTRIBUTES = new HashSet<String>(Arrays.asList("escapeText", "trim"));

    public ReferenceRenderer(Sink sink, URL taglibXml) throws DocumentException {
        super(sink);
        this.taglibXml = new SAXReader().read(taglibXml);
    }

    public String getTitle() {
        return "Jelly Taglib references";
    }

    protected void renderBody() {
        List<Element> libraries = this.sortByName(this.taglibXml.getRootElement().elements("library"));
        this.paragraph("The following Jelly tag libraries are defined in this project.");
        if (libraries.size() > 1) {
            this.startTable();
            this.tableHeader(new String[]{"Namespace URI", "Description"});
            for (Element library : libraries) {
                this.sink.tableRow();
                this.sink.tableCell();
                this.sink.rawText(String.format("<a href='#%s'>%s</a>", library.attributeValue("prefix"), library.attributeValue("uri")));
                this.sink.tableCell_();
                this.docCell(library);
                this.sink.tableRow_();
            }
            this.endTable();
        }
        for (Element library : libraries) {
            String prefix = library.attributeValue("prefix");
            this.anchor(prefix);
            this.startSection(library.attributeValue("uri"));
            this.doc(library);
            this.paragraphHtml("This tag library is <a href='taglib-" + prefix + ".xsd'>also available as an XML Schema</a>");
            this.renderSummaryTable(library, prefix);
            for (Element tag : this.sortByName(library.elements("tag"))) {
                this.renderTagReference(prefix, tag);
            }
            this.endSection();
        }
    }

    private void paragraphHtml(String rawText) {
        this.sink.paragraph();
        this.sink.rawText(rawText);
        this.sink.paragraph_();
    }

    private void renderSummaryTable(Element library, String prefix) {
        this.startTable();
        this.tableHeader(new String[]{"Tag Name", "Description"});
        List<Element> tags = this.sortByName(library.elements("tag"));
        for (Element tag : tags) {
            this.sink.tableRow();
            this.sink.tableCell();
            String name = tag.attributeValue("name");
            this.sink.rawText("<a href='#" + prefix + ".3A" + name + "'>" + name + "</a>");
            this.sink.tableCell_();
            this.docCell(tag);
            this.sink.tableRow_();
        }
        this.endTable();
    }

    private List<Element> sortByName(List<Element> list) {
        ArrayList<Element> tags = new ArrayList<Element>(list);
        tags.sort(SORT_BY_NAME);
        return tags;
    }

    private void renderTagReference(String taglibPrefix, Element tag) {
        String name = tag.attributeValue("name");
        this.anchor(taglibPrefix + ":" + name);
        this.startSection(name);
        this.doc(tag);
        if (this.hasVisibleAttributes(tag)) {
            this.startTable();
            this.tableHeader(new String[]{"Attribute Name", "Type", "Description"});
            for (Element att : this.sortByName(tag.elements("attribute"))) {
                this.renderAttribute(att);
            }
            this.endTable();
        }
        if (tag.attributeValue("no-content", "false").equals("true")) {
            this.paragraph("This tag does not accept any child elements/text.");
        } else {
            Element body = tag.element("body");
            if (body != null) {
                this.startSection("body");
                this.doc(body);
                this.endSection();
            }
        }
        this.endSection();
    }

    private boolean hasVisibleAttributes(Element tag) {
        for (Element att : tag.elements("attribute")) {
            String name = att.attributeValue("name");
            if (HIDDEN_ATTRIBUTES.contains(name)) continue;
            return true;
        }
        return false;
    }

    private void anchor(String name) {
        this.sink.anchor(name);
        this.sink.anchor_();
    }

    private void renderAttribute(Element att) {
        String name = att.attributeValue("name");
        if (HIDDEN_ATTRIBUTES.contains(name)) {
            return;
        }
        this.sink.tableRow();
        Object suffix = "";
        if (att.attributeValue("use", "optional").equals("required")) {
            suffix = (String)suffix + " (required)";
        }
        if (att.attributeValue("deprecated", "false").equals("true")) {
            suffix = (String)suffix + " (deprecated)";
        }
        this.tableCell(name + (String)suffix);
        this.tableCell(att.attributeValue("type"));
        this.docCell(att);
        this.sink.tableRow_();
    }

    private void doc(Element tag) {
        this.sink.rawText(this.docXml(tag));
    }

    private void docCell(Element tag) {
        this.sink.tableCell();
        this.sink.rawText(this.docXml(tag));
        this.sink.tableCell_();
    }

    private String docXml(Element parent) {
        Element doc = parent.element("doc");
        doc.content().removeAll(doc.elements("authortag"));
        String xml = doc.getText();
        StringWriter w = new StringWriter();
        MarkupParser parser = new MarkupParser((Dialect)new ConfluenceDialect());
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder(this, w){

            public void lineBreak() {
            }
        };
        builder.setEmitAsDocument(false);
        parser.setBuilder((DocumentBuilder)builder);
        parser.parse(xml);
        return w.toString();
    }
}

