/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.maven.jellydoc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.reporting.MavenMultiPageReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javadoc;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.codehaus.plexus.util.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultDocument;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.jvnet.maven.jellydoc.ReferenceRenderer;
import org.jvnet.maven.jellydoc.TagXMLDoclet;

@Mojo(name="jellydoc", requiresDependencyResolution=ResolutionScope.COMPILE)
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class JellydocMojo
extends AbstractMojo
implements MavenMultiPageReport {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    public MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    public MavenSession session;
    @Parameter(defaultValue="${plugin.artifacts}", required=true, readonly=true)
    public List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${plugin.version}", required=true, readonly=true)
    public String pluginVersion;
    @Component
    public ArtifactFactory factory;
    @Component
    public RepositorySystem repositorySystem;
    @Component
    public MavenProjectHelper helper;
    private File outputDirectory;

    public void execute() throws MojoExecutionException {
        Artifact self;
        Project p = new Project();
        DefaultLogger logger = new DefaultLogger();
        logger.setErrorPrintStream(System.err);
        logger.setOutputPrintStream(System.out);
        logger.setMessageOutputLevel(this.getLog().isDebugEnabled() ? 4 : 2);
        p.addBuildListener((BuildListener)logger);
        Javadoc javadoc = new Javadoc();
        javadoc.setTaskName("jellydoc");
        javadoc.setProject(p);
        boolean foundDir = false;
        for (Object dir : this.project.getCompileSourceRoots()) {
            File dirFile = new File(dir.toString());
            if (!dirFile.exists()) continue;
            FileSet fs = new FileSet();
            fs.setProject(p);
            fs.setDir(dirFile);
            javadoc.addFileset(fs);
            foundDir = true;
        }
        if (!foundDir) {
            return;
        }
        javadoc.setClasspath(this.makePath(p, this.project.getArtifacts()));
        Javadoc.DocletInfo d = javadoc.createDoclet();
        d.setProject(p);
        d.setName(TagXMLDoclet.class.getName());
        this.setParam(d, "-d", this.targetDir().getAbsolutePath());
        Path docletPath = this.makePath(p, this.pluginArtifacts);
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        List remoteRepositories = RepositoryUtils.toRepos((List)buildingRequest.getRemoteRepositories());
        Artifact artifact = this.factory.createArtifact("io.jenkins.tools.maven", "jellydoc-maven-plugin", this.pluginVersion, null, "maven-plugin");
        ArtifactRequest request = new ArtifactRequest(RepositoryUtils.toArtifact((Artifact)artifact), remoteRepositories, null);
        try {
            self = RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)this.repositorySystem.resolveArtifact(buildingRequest.getRepositorySession(), request).getArtifact());
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to resolve plugin from within itself", (Exception)((Object)e));
        }
        docletPath.createPathElement().setLocation(self.getFile());
        d.setPath(docletPath);
        javadoc.execute();
        this.generateSchema();
    }

    public void generateSchema() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"Generating XML Schema");
            TransformerFactory tf = TransformerFactory.newInstance();
            Templates templates = tf.newTemplates(new StreamSource(JellydocMojo.class.getResource("xsdgen.xsl").toExternalForm()));
            File source = new File(this.project.getBasedir(), "target/taglib.xml");
            for (Node node : new SAXReader().read(source).selectNodes("/tags/library")) {
                Element lib = (Element)node;
                String prefix = lib.attributeValue("prefix");
                File schema = new File(this.project.getBasedir(), "target/taglib-" + prefix + ".xsd");
                lib.getParent().remove(lib);
                DefaultDocument newDoc = new DefaultDocument();
                newDoc.setRootElement(lib);
                templates.newTransformer().transform((Source)new DocumentSource((Document)newDoc), new StreamResult(new FileOutputStream(schema)));
                this.helper.attachArtifact(this.project, "xsd", "taglib-" + prefix, schema);
            }
        }
        catch (FileNotFoundException | TransformerException | DocumentException e) {
            throw new MojoExecutionException("Failed to generate schema", (Exception)e);
        }
    }

    private Path makePath(Project p, Collection<Artifact> artifacts) {
        Path docletPath = new Path(p);
        for (Artifact artifact : artifacts) {
            docletPath.createPathElement().setLocation(artifact.getFile());
        }
        return docletPath;
    }

    private File targetDir() {
        return new File(this.project.getBasedir(), "target");
    }

    private void setParam(Javadoc.DocletInfo d, String name, String value) {
        Javadoc.DocletParam dp = d.createParam();
        dp.setName(name);
        dp.setValue(value);
    }

    @Deprecated
    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.generate(sink, null, locale);
    }

    public void generate(Sink sink, SinkFactory sinkFactory, Locale locale) throws MavenReportException {
        try {
            this.execute();
            File libFile = new File(this.targetDir(), "taglib.xml");
            if (libFile.exists()) {
                new ReferenceRenderer(sink, libFile.toURI().toURL()).render();
                FileUtils.copyDirectory((File)this.targetDir(), (File)new File(this.targetDir(), "site"), (String)"taglib-*.xsd", null);
            }
        }
        catch (IOException | AbstractMojoExecutionException | DocumentException e) {
            throw new MavenReportException("Failed to generate report", (Exception)e);
        }
    }

    public String getOutputName() {
        return "jelly-taglib-ref";
    }

    public String getName(Locale locale) {
        return "Jelly taglib reference";
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getDescription(Locale locale) {
        return "Jelly taglib reference";
    }

    public void setReportOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return true;
    }
}

