/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.utils;

import hudson.AbortException;
import hudson.model.TaskListener;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.kotlinsdk.zowe.client.sdk.zosfiles.ZosDsnList;
import org.zowe.kotlinsdk.zowe.client.sdk.zosfiles.input.ListParams;
import org.zowe.zdevops.Messages;
import org.zowe.zdevops.config.ZOSConnectionList;
import org.zowe.zdevops.model.ResolvedZOSConnection;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\n"}, d2={"getTestDatasetList", "", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "getZoweZosConnection", "connectionName", "", "listener", "Lhudson/model/TaskListener;", "validateConnection", "zdevops"})
public final class ConnectionValidationKt {
    public static final void getTestDatasetList(@NotNull ZOSConnection zosConnection) {
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        ZosDsnList zosDsnList = new ZosDsnList(zosConnection, null, 2, null);
        String string = Messages.zdevops_config_ZOSConnection_validation_testDS();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zdevops_config_ZOSConnec\u2026on_validation_testDS(...)");
        zosDsnList.listDsn(string, new ListParams(null, null, null, null, null, null, null, false, 255, null));
    }

    public static final void validateConnection(@NotNull ZOSConnection zosConnection) {
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        try {
            ConnectionValidationKt.getTestDatasetList(zosConnection);
        }
        catch (Exception connectException) {
            String connExMessage = "Failed to connect to z/OS (" + zosConnection.getUser() + "@" + zosConnection.getHost() + ":" + zosConnection.getZosmfPort() + "): " + connectException.getMessage();
            throw new AbortException(connExMessage);
        }
    }

    @NotNull
    public static final ZOSConnection getZoweZosConnection(@NotNull String connectionName, @Nullable TaskListener listener) {
        Intrinsics.checkNotNullParameter((Object)connectionName, (String)"connectionName");
        ResolvedZOSConnection resolvedZOSConnection = ZOSConnectionList.Companion.resolve(connectionName);
        if (resolvedZOSConnection == null) {
            boolean bl = false;
            IllegalArgumentException exception = new IllegalArgumentException(Messages.zdevops_config_ZOSConnection_resolve_unknown(connectionName));
            StringWriter sw = new StringWriter();
            exception.printStackTrace(new PrintWriter(sw));
            Object object = listener;
            if (object != null && (object = object.getLogger()) != null) {
                ((PrintStream)object).println(sw.toString());
            }
            throw exception;
        }
        ResolvedZOSConnection connection = resolvedZOSConnection;
        URL connURL = new URL(connection.getUrl());
        String string = connURL.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        String string2 = String.valueOf(connURL.getPort());
        String string3 = connection.getUsername();
        String string4 = connection.getPassword();
        String string5 = connURL.getProtocol();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getProtocol(...)");
        return new ZOSConnection(string, string2, string3, string4, string5, null, null, 0L, 0L, null, 992, null);
    }
}

