/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.logic;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import hudson.AbortException;
import hudson.FilePath;
import hudson.console.HyperlinkNote;
import hudson.model.TaskListener;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zowe.kotlinsdk.Job;
import org.zowe.kotlinsdk.SpoolFile;
import org.zowe.kotlinsdk.SubmitJobRequest;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.kotlinsdk.zowe.client.sdk.zosjobs.GetJobs;
import org.zowe.kotlinsdk.zowe.client.sdk.zosjobs.MonitorJobs;
import org.zowe.kotlinsdk.zowe.client.sdk.zosjobs.SubmitJobs;
import org.zowe.zdevops.Messages;
import org.zowe.zdevops.utils.SimpleMFExceptionMessageExtractorKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001aT\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032 \u0010\f\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r\u00a8\u0006\u000e"}, d2={"submitJob", "Lorg/zowe/kotlinsdk/SubmitJobRequest;", "fileToSubmit", "", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "listener", "Lhudson/model/TaskListener;", "submitJobSync", "workspacePath", "Lhudson/FilePath;", "buildUrl", "linkBuilder", "Lkotlin/Function3;", "zdevops"})
@SourceDebugExtension(value={"SMAP\nSubmitJobOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubmitJobOperation.kt\norg/zowe/zdevops/logic/SubmitJobOperationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SimpleMFExceptionMessageExtractor.kt\norg/zowe/zdevops/utils/SimpleMFExceptionMessageExtractorKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1#2:108\n25#3,17:109\n42#3,5:128\n25#3,17:133\n42#3,5:152\n1855#4,2:126\n1855#4,2:150\n*S KotlinDebug\n*F\n+ 1 SubmitJobOperation.kt\norg/zowe/zdevops/logic/SubmitJobOperationKt\n*L\n81#1:109,17\n81#1:128,5\n88#1:133,17\n88#1:152,5\n81#1:126,2\n88#1:150,2\n*E\n"})
public final class SubmitJobOperationKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final SubmitJobRequest submitJob(@NotNull String fileToSubmit, @NotNull ZOSConnection zosConnection, @NotNull TaskListener listener) {
        Intrinsics.checkNotNullParameter((Object)fileToSubmit, (String)"fileToSubmit");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        SubmitJobRequest submitJobRsp = null;
        try {
            listener.getLogger().println(Messages.zdevops_declarative_ZOSJobs_submitting(fileToSubmit, zosConnection.getHost(), zosConnection.getZosmfPort()));
            submitJobRsp = new SubmitJobs(zosConnection, null, 2, null).submitJob(fileToSubmit);
            listener.getLogger().println(Messages.zdevops_declarative_ZOSJobs_submitted_success(submitJobRsp.getJobid(), submitJobRsp.getJobname(), submitJobRsp.getOwner()));
        }
        catch (Exception e) {
            String string;
            PrintStream printStream = listener.getLogger();
            String string2 = e.getMessage();
            if (string2 != null) {
                void it;
                String string3 = string2;
                PrintStream printStream2 = printStream;
                boolean bl = false;
                string = SimpleMFExceptionMessageExtractorKt.extractSubmitJobMessage((String)it);
                printStream = printStream2;
            } else {
                string = null;
            }
            printStream.println(string);
            throw new AbortException(Messages.zdevops_classic_ZOSJobs_submitted_fail(fileToSubmit));
        }
        return submitJobRsp;
    }

    @Nullable
    public static final String submitJobSync(@NotNull String fileToSubmit, @NotNull ZOSConnection zosConnection, @NotNull TaskListener listener, @NotNull FilePath workspacePath, @Nullable String buildUrl, @NotNull Function3<? super String, ? super String, ? super String, String> linkBuilder2) {
        Intrinsics.checkNotNullParameter((Object)fileToSubmit, (String)"fileToSubmit");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)workspacePath, (String)"workspacePath");
        Intrinsics.checkNotNullParameter(linkBuilder2, (String)"linkBuilder");
        SubmitJobRequest submitJobRsp = SubmitJobOperationKt.submitJob(fileToSubmit, zosConnection, listener);
        listener.getLogger().println(Messages.zdevops_declarative_ZOSJobs_submitted_waiting());
        Object object = submitJobRsp;
        if (object == null || (object = object.getJobid()) == null) {
            throw new IllegalStateException("System response doesn't contain JOB ID.");
        }
        Object jobId = object;
        String string = submitJobRsp.getJobname();
        if (string == null) {
            throw new IllegalStateException("System response doesn't contain JOB name.");
        }
        String jobName = string;
        Job finalResult = null;
        boolean $i$f$runMFTryCatchWrappedQuery = false;
        try {
            boolean bl = false;
            finalResult = new MonitorJobs(zosConnection, null, 2, null).waitForJobOutputStatus(jobName, (String)jobId);
            Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Exception e$iv) {
            Map responseMap$iv;
            block26: {
                responseMap$iv = null;
                try {
                    Object object2 = new Gson().fromJson(e$iv.getMessage(), new TypeToken<Map<String, ? extends Object>>(){}.getType());
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fromJson(...)");
                    responseMap$iv = (Map)object2;
                }
                catch (Exception eInternal$iv) {
                    CharSequence charSequence;
                    String string2 = eInternal$iv.getMessage();
                    boolean bl = string2 != null ? new Regex("Expected .* but was STRING").containsMatchIn(charSequence = (CharSequence)string2) : false;
                    if (bl) {
                        listener.getLogger().println(e$iv.getMessage());
                        break block26;
                    }
                    listener.getLogger().println(eInternal$iv.getMessage());
                }
            }
            Object errorContent$iv = null;
            try {
                Map map = responseMap$iv;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"responseMap");
                    map = null;
                }
                Object v = map.get("details");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type java.util.ArrayList<*>{ kotlin.collections.TypeAliasesKt.ArrayList<*> }");
                errorContent$iv = (ArrayList)v;
                Iterable $this$forEach$iv$iv = (Iterable)errorContent$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv;
                    Object it$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    listener.getLogger().println(it$iv);
                }
            }
            catch (NullPointerException e$iv2) {
                Map map = responseMap$iv;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"responseMap");
                    map = null;
                }
                Object v = map.get("message");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                errorContent$iv = (String)v;
                listener.getLogger().println((String)errorContent$iv);
            }
            throw new Exception(e$iv);
        }
        PrintStream printStream = listener.getLogger();
        Job job = finalResult;
        if (job == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"finalResult");
            job = null;
        }
        printStream.println(Messages.zdevops_declarative_ZOSJobs_submitted_executed(job.getReturnedCode()));
        listener.getLogger().println(Messages.zdevops_declarative_ZOSJobs_getting_log());
        List spoolFiles = null;
        boolean $i$f$runMFTryCatchWrappedQuery2 = false;
        try {
            boolean bl = false;
            spoolFiles = new GetJobs(zosConnection, null, 2, null).getSpoolFilesForJob(finalResult);
            Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Exception e$iv) {
            Map responseMap$iv;
            block27: {
                responseMap$iv = null;
                try {
                    Object object3 = new Gson().fromJson(e$iv.getMessage(), new /* invalid duplicate definition of identical inner class */.getType());
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"fromJson(...)");
                    responseMap$iv = (Map)object3;
                }
                catch (Exception eInternal$iv) {
                    CharSequence e$iv2;
                    String string3 = eInternal$iv.getMessage();
                    boolean bl = string3 != null ? new Regex("Expected .* but was STRING").containsMatchIn(e$iv2 = (CharSequence)string3) : false;
                    if (bl) {
                        listener.getLogger().println(e$iv.getMessage());
                        break block27;
                    }
                    listener.getLogger().println(eInternal$iv.getMessage());
                }
            }
            Object errorContent$iv = null;
            try {
                Map map = responseMap$iv;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"responseMap");
                    map = null;
                }
                Object v = map.get("details");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type java.util.ArrayList<*>{ kotlin.collections.TypeAliasesKt.ArrayList<*> }");
                errorContent$iv = (ArrayList)v;
                Iterable $this$forEach$iv$iv = (Iterable)errorContent$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv;
                    Object it$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    listener.getLogger().println(it$iv);
                }
            }
            catch (NullPointerException e$iv3) {
                Map map = responseMap$iv;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"responseMap");
                    map = null;
                }
                Object v = map.get("message");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                errorContent$iv = (String)v;
                listener.getLogger().println((String)errorContent$iv);
            }
            throw new Exception(e$iv);
        }
        List list = spoolFiles;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"spoolFiles");
            list = null;
        }
        if (!((Collection)list).isEmpty()) {
            String fullLog2 = CollectionsKt.joinToString$default((Iterable)spoolFiles, null, null, null, (int)0, null, (Function1)((Function1)new Function1<SpoolFile, CharSequence>(zosConnection){
                final /* synthetic */ ZOSConnection $zosConnection;
                {
                    this.$zosConnection = $zosConnection;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull SpoolFile it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new GetJobs(this.$zosConnection, null, 2, null).getSpoolContent(it);
                }
            }), (int)31, null);
            String logPath = workspacePath + "/" + finalResult.getJobName() + "." + finalResult.getJobId();
            File file = new File(logPath);
            FilesKt.writeText$default((File)file, (String)fullLog2, null, (int)2, null);
            listener.getLogger().println(Messages.zdevops_declarative_ZOSJobs_got_log(HyperlinkNote.encodeTo((String)((String)linkBuilder2.invoke((Object)buildUrl, (Object)finalResult.getJobName(), (Object)finalResult.getJobId())), (String)(finalResult.getJobName() + "." + finalResult.getJobId()))));
        } else {
            listener.getLogger().println(Messages.zdevops_no_spool_files(submitJobRsp.getJobid()));
        }
        return finalResult.getReturnedCode();
    }
}

