/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.logic;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import hudson.AbortException;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zowe.kotlinsdk.DataSetsList;
import org.zowe.kotlinsdk.Dataset;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.kotlinsdk.zowe.client.sdk.zosfiles.ZosDsn;
import org.zowe.kotlinsdk.zowe.client.sdk.zosfiles.ZosDsnList;
import org.zowe.kotlinsdk.zowe.client.sdk.zosfiles.input.ListParams;
import org.zowe.zdevops.Messages;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a&\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"successMessage", "", "deleteDatasetOrMember", "", "dsn", "member", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "listener", "Lhudson/model/TaskListener;", "failOnNotExist", "", "deleteDatasetsByMask", "mask", "isMemberNameValid", "zdevops"})
@SourceDebugExtension(value={"SMAP\nDeleteOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeleteOperation.kt\norg/zowe/zdevops/logic/DeleteOperationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SimpleMFExceptionMessageExtractor.kt\norg/zowe/zdevops/utils/SimpleMFExceptionMessageExtractorKt\n*L\n1#1,103:1\n1855#2:104\n1855#2,2:122\n1856#2:129\n25#3,17:105\n42#3,5:124\n*S KotlinDebug\n*F\n+ 1 DeleteOperation.kt\norg/zowe/zdevops/logic/DeleteOperationKt\n*L\n42#1:104\n43#1:122,2\n42#1:129\n43#1:105,17\n43#1:124,5\n*E\n"})
public final class DeleteOperationKt {
    @NotNull
    private static final String successMessage;

    public static final void deleteDatasetsByMask(@NotNull String mask, @NotNull ZOSConnection zosConnection, @NotNull TaskListener listener, boolean failOnNotExist) {
        Intrinsics.checkNotNullParameter((Object)mask, (String)"mask");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (((CharSequence)mask).length() == 0) {
            throw new AbortException(Messages.zdevops_deleting_datasets_by_mask_but_mask_is_empty());
        }
        listener.getLogger().println(Messages.zdevops_deleting_ds_by_mask(mask));
        try {
            DataSetsList dsnList = new ZosDsnList(zosConnection, null, 2, null).listDsn(mask, new ListParams(null, null, null, null, null, null, null, false, 255, null));
            if (dsnList.getItems().isEmpty()) {
                throw new AbortException(Messages.zdevops_deleting_ds_fail_no_matching_mask());
            }
            Iterable $this$forEach$iv = dsnList.getItems();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Dataset it = (Dataset)element$iv;
                boolean bl = false;
                boolean $i$f$runMFTryCatchWrappedQuery = false;
                try {
                    boolean bl2 = false;
                    listener.getLogger().println(Messages.zdevops_deleting_ds(it.getName(), zosConnection.getHost(), zosConnection.getZosmfPort()));
                    Result.constructor-impl((Object)new ZosDsn(zosConnection, null, 2, null).deleteDsn(it.getName()));
                }
                catch (Exception e$iv) {
                    Map responseMap$iv;
                    block16: {
                        responseMap$iv = null;
                        try {
                            Object object = new Gson().fromJson(e$iv.getMessage(), new TypeToken<Map<String, ? extends Object>>(){}.getType());
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                            responseMap$iv = (Map)object;
                        }
                        catch (Exception eInternal$iv) {
                            CharSequence charSequence;
                            String string = eInternal$iv.getMessage();
                            boolean bl3 = string != null ? new Regex("Expected .* but was STRING").containsMatchIn(charSequence = (CharSequence)string) : false;
                            if (bl3) {
                                listener.getLogger().println(e$iv.getMessage());
                                break block16;
                            }
                            listener.getLogger().println(eInternal$iv.getMessage());
                        }
                    }
                    Object errorContent$iv = null;
                    try {
                        Map map = responseMap$iv;
                        if (map == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"responseMap");
                            map = null;
                        }
                        Object v = map.get("details");
                        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type java.util.ArrayList<*>{ kotlin.collections.TypeAliasesKt.ArrayList<*> }");
                        errorContent$iv = (ArrayList)v;
                        Iterable $this$forEach$iv$iv = (Iterable)errorContent$iv;
                        boolean $i$f$forEach2 = false;
                        Iterator iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv$iv;
                            Object it$iv = element$iv$iv = iterator.next();
                            boolean bl4 = false;
                            listener.getLogger().println(it$iv);
                        }
                    }
                    catch (NullPointerException e$iv2) {
                        Map map = responseMap$iv;
                        if (map == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"responseMap");
                            map = null;
                        }
                        Object v = map.get("message");
                        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                        errorContent$iv = (String)v;
                        listener.getLogger().println((String)errorContent$iv);
                    }
                    throw new Exception(e$iv);
                }
            }
            listener.getLogger().println(successMessage);
        }
        catch (Exception doesNotExistEx) {
            if (failOnNotExist) {
                throw doesNotExistEx;
            }
            listener.getLogger().println("Reason: " + doesNotExistEx);
            listener.getLogger().println("Dataset deletion failed, but the `failOnNotExist` option is set to false. Continuing with execution.");
        }
    }

    public static final void deleteDatasetOrMember(@NotNull String dsn, @Nullable String member, @NotNull ZOSConnection zosConnection, @NotNull TaskListener listener, boolean failOnNotExist) {
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (((CharSequence)dsn).length() == 0) {
            throw new AbortException(Messages.zdevops_deleting_ds_fail_dsn_param_empty());
        }
        CharSequence charSequence = member;
        String logMessage = !(charSequence == null || charSequence.length() == 0) ? Messages.zdevops_deleting_ds_member(member, dsn, zosConnection.getHost(), zosConnection.getZosmfPort()) : Messages.zdevops_deleting_ds(dsn, zosConnection.getHost(), zosConnection.getZosmfPort());
        listener.getLogger().println(logMessage);
        try {
            charSequence = member;
            if (!(charSequence == null || charSequence.length() == 0)) {
                DeleteOperationKt.isMemberNameValid(member);
                new ZosDsn(zosConnection, null, 2, null).deleteDsn(dsn, member);
            } else {
                new ZosDsn(zosConnection, null, 2, null).deleteDsn(dsn);
            }
            listener.getLogger().println(successMessage);
        }
        catch (Exception doesNotExistEx) {
            if (failOnNotExist) {
                throw doesNotExistEx;
            }
            listener.getLogger().println("Reason: " + doesNotExistEx);
            listener.getLogger().println("Dataset deletion failed, but the `failOnNotExist` option is set to false. Continuing with execution.");
        }
    }

    private static final void isMemberNameValid(String member) {
        if (member.length() > 8 || ((CharSequence)member).length() == 0) {
            throw new Exception(Messages.zdevops_member_name_invalid());
        }
    }

    static {
        String string = Messages.zdevops_deleting_ds_success();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zdevops_deleting_ds_success(...)");
        successMessage = string;
    }
}

