/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.declarative.jobs;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jenkinsci.Symbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.zdevops.Messages;
import org.zowe.zdevops.declarative.AbstractZosmfAction;
import org.zowe.zdevops.logic.WriteOperationKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J@\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/zowe/zdevops/declarative/jobs/WriteToFileDeclarative;", "Lorg/zowe/zdevops/declarative/AbstractZosmfAction;", "destFile", "", "text", "(Ljava/lang/String;Ljava/lang/String;)V", "binary", "", "Ljava/lang/Boolean;", "exceptionMessage", "getExceptionMessage", "()Ljava/lang/String;", "perform", "", "run", "Lhudson/model/Run;", "workspace", "Lhudson/FilePath;", "env", "Lhudson/EnvVars;", "launcher", "Lhudson/Launcher;", "listener", "Lhudson/model/TaskListener;", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "setBinary", "DescriptorImpl", "zdevops"})
public final class WriteToFileDeclarative
extends AbstractZosmfAction {
    @NotNull
    private final String destFile;
    @NotNull
    private final String text;
    @Nullable
    private Boolean binary;
    @NotNull
    private final String exceptionMessage;

    @DataBoundConstructor
    public WriteToFileDeclarative(@NotNull String destFile, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)destFile, (String)"destFile");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.destFile = destFile;
        this.text = text;
        this.binary = false;
        String string = Messages.zdevops_declarative_writing_file_fail(this.destFile);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zdevops_declarative_writing_file_fail(...)");
        this.exceptionMessage = string;
    }

    @DataBoundSetter
    public final void setBinary(boolean binary) {
        this.binary = binary;
    }

    @Override
    @NotNull
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public void perform(@NotNull Run<?, ?> run, @NotNull FilePath workspace, @NotNull EnvVars env, @NotNull Launcher launcher, @NotNull TaskListener listener, @NotNull ZOSConnection zosConnection) {
        Intrinsics.checkNotNullParameter(run, (String)"run");
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        listener.getLogger().println(Messages.zdevops_declarative_writing_file_from_input(this.destFile, zosConnection.getHost(), zosConnection.getZosmfPort()));
        String string = this.text;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] textBytes = byArray;
        WriteOperationKt.writeToFile(listener, zosConnection, this.destFile, textBytes, this.binary);
    }

    @Symbol(value={"writeToFile"})
    @Extension
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/zowe/zdevops/declarative/jobs/WriteToFileDeclarative$DescriptorImpl;", "Lorg/zowe/zdevops/declarative/AbstractZosmfAction$Companion$DefaultBuildDescriptor;", "()V", "zdevops"})
    public static final class DescriptorImpl
    extends AbstractZosmfAction.Companion.DefaultBuildDescriptor {
        public DescriptorImpl() {
            super("Write to Unix file Declarative");
        }
    }
}

