/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.declarative.jobs;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jenkinsci.Symbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.zdevops.Messages;
import org.zowe.zdevops.declarative.AbstractZosmfAction;
import org.zowe.zdevops.logic.WriteOperationKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001dB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\r\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\rJ@\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/zowe/zdevops/declarative/jobs/WriteFileToFileDeclarative;", "Lorg/zowe/zdevops/declarative/AbstractZosmfAction;", "destFile", "", "sourceFile", "(Ljava/lang/String;Ljava/lang/String;)V", "binary", "", "Ljava/lang/Boolean;", "exceptionMessage", "getExceptionMessage", "()Ljava/lang/String;", "getBinary", "()Ljava/lang/Boolean;", "perform", "", "run", "Lhudson/model/Run;", "workspace", "Lhudson/FilePath;", "env", "Lhudson/EnvVars;", "launcher", "Lhudson/Launcher;", "listener", "Lhudson/model/TaskListener;", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "setBinary", "DescriptorImpl", "zdevops"})
public final class WriteFileToFileDeclarative
extends AbstractZosmfAction {
    @NotNull
    private final String destFile;
    @NotNull
    private final String sourceFile;
    @Nullable
    private Boolean binary;
    @NotNull
    private final String exceptionMessage;

    @DataBoundConstructor
    public WriteFileToFileDeclarative(@NotNull String destFile, @NotNull String sourceFile) {
        Intrinsics.checkNotNullParameter((Object)destFile, (String)"destFile");
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        this.destFile = destFile;
        this.sourceFile = sourceFile;
        this.binary = false;
        String string = Messages.zdevops_declarative_writing_file_fail(this.destFile);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zdevops_declarative_writing_file_fail(...)");
        this.exceptionMessage = string;
    }

    @DataBoundSetter
    public final void setBinary(boolean binary) {
        this.binary = binary;
    }

    @Nullable
    public final Boolean getBinary() {
        return this.binary;
    }

    @Override
    @NotNull
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public void perform(@NotNull Run<?, ?> run, @NotNull FilePath workspace, @NotNull EnvVars env, @NotNull Launcher launcher, @NotNull TaskListener listener, @NotNull ZOSConnection zosConnection) {
        File file;
        Intrinsics.checkNotNullParameter(run, (String)"run");
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        listener.getLogger().println(Messages.zdevops_declarative_writing_file_from_file(this.destFile, this.sourceFile, zosConnection.getHost(), zosConnection.getZosmfPort()));
        Path filePath = Paths.get(this.sourceFile, new String[0]);
        if (filePath.isAbsolute()) {
            file = new File(this.sourceFile);
        } else {
            String string = workspace.getRemote();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRemote(...)");
            String string2 = workspace.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String workspacePath = StringsKt.replace$default((String)string, (String)string2, (String)"", (boolean)false, (int)4, null);
            file = new File(workspacePath + this.sourceFile);
        }
        File textFile = file;
        byte[] text = FilesKt.readBytes((File)textFile);
        WriteOperationKt.writeToFile(listener, zosConnection, this.destFile, text, this.binary);
    }

    @Symbol(value={"writeFileToFile"})
    @Extension
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/zowe/zdevops/declarative/jobs/WriteFileToFileDeclarative$DescriptorImpl;", "Lorg/zowe/zdevops/declarative/AbstractZosmfAction$Companion$DefaultBuildDescriptor;", "()V", "zdevops"})
    public static final class DescriptorImpl
    extends AbstractZosmfAction.Companion.DefaultBuildDescriptor {
        public DescriptorImpl() {
            super("Write file to Unix file Declarative");
        }
    }
}

