/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.classic.steps;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.zdevops.Messages;
import org.zowe.zdevops.classic.AbstractBuildStep;
import org.zowe.zdevops.logic.WriteOperationKt;
import org.zowe.zdevops.utils.FieldsValidationKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J0\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/zowe/zdevops/classic/steps/WriteToMemberStep;", "Lorg/zowe/zdevops/classic/AbstractBuildStep;", "connectionName", "", "dsn", "member", "text", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDsn", "()Ljava/lang/String;", "getMember", "getText", "perform", "", "build", "Lhudson/model/AbstractBuild;", "launcher", "Lhudson/Launcher;", "listener", "Lhudson/model/BuildListener;", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "DescriptorImpl", "zdevops"})
public final class WriteToMemberStep
extends AbstractBuildStep {
    @NotNull
    private final String dsn;
    @NotNull
    private final String member;
    @NotNull
    private final String text;

    @DataBoundConstructor
    public WriteToMemberStep(@NotNull String connectionName, @NotNull String dsn, @NotNull String member, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)connectionName, (String)"connectionName");
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(connectionName);
        this.dsn = dsn;
        this.member = member;
        this.text = text;
    }

    @NotNull
    public final String getDsn() {
        return this.dsn;
    }

    @NotNull
    public final String getMember() {
        return this.member;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Override
    public void perform(@NotNull AbstractBuild<?, ?> build, @NotNull Launcher launcher, @NotNull BuildListener listener, @NotNull ZOSConnection zosConnection) {
        Intrinsics.checkNotNullParameter(build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        listener.getLogger().println(Messages.zdevops_declarative_writing_DS_from_input(this.dsn, zosConnection.getHost(), zosConnection.getZosmfPort()));
        WriteOperationKt.writeToMember((TaskListener)listener, zosConnection, this.dsn, this.member, this.text);
    }

    @Extension
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\b\u001a\u00020\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\n\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lorg/zowe/zdevops/classic/steps/WriteToMemberStep$DescriptorImpl;", "Lorg/zowe/zdevops/classic/AbstractBuildStep$Companion$DefaultBuildDescriptor;", "()V", "doCheckDsn", "Lhudson/util/FormValidation;", "dsn", "", "doCheckMember", "member", "doCheckText", "text", "zdevops"})
    public static final class DescriptorImpl
    extends AbstractBuildStep.Companion.DefaultBuildDescriptor {
        public DescriptorImpl() {
            String string = Messages.zdevops_classic_writeToMemberStep_display_name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zdevops_classic_writeToM\u2026berStep_display_name(...)");
            super(string);
        }

        @Nullable
        public final FormValidation doCheckDsn(@QueryParameter @NotNull String dsn) {
            Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
            return FieldsValidationKt.validateDatasetName(dsn);
        }

        @Nullable
        public final FormValidation doCheckText(@QueryParameter @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return FieldsValidationKt.validateFieldIsNotEmpty(text);
        }

        @Nullable
        public final FormValidation doCheckMember(@QueryParameter @NotNull String member) {
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            FormValidation formValidation = FieldsValidationKt.validateMemberName(member);
            if (formValidation == null) {
                formValidation = FieldsValidationKt.validateFieldIsNotEmpty(member);
            }
            return formValidation;
        }
    }
}

