/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.classic.steps;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.zdevops.Messages;
import org.zowe.zdevops.classic.AbstractBuildStep;
import org.zowe.zdevops.logic.WriteOperationKt;
import org.zowe.zdevops.utils.FieldsValidationKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ0\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/zowe/zdevops/classic/steps/WriteToFileStep;", "Lorg/zowe/zdevops/classic/AbstractBuildStep;", "connectionName", "", "filePath", "text", "binary", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getBinary", "()Z", "setBinary", "(Z)V", "getFilePath", "()Ljava/lang/String;", "getText", "perform", "", "build", "Lhudson/model/AbstractBuild;", "launcher", "Lhudson/Launcher;", "listener", "Lhudson/model/BuildListener;", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "DescriptorImpl", "zdevops"})
public final class WriteToFileStep
extends AbstractBuildStep {
    @NotNull
    private final String filePath;
    @NotNull
    private final String text;
    private boolean binary;

    @DataBoundConstructor
    public WriteToFileStep(@NotNull String connectionName, @NotNull String filePath, @NotNull String text, boolean binary) {
        Intrinsics.checkNotNullParameter((Object)connectionName, (String)"connectionName");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(connectionName);
        this.filePath = filePath;
        this.text = text;
        this.binary = binary;
    }

    public /* synthetic */ WriteToFileStep(String string, String string2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, string2, string3, bl);
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final boolean getBinary() {
        return this.binary;
    }

    public final void setBinary(boolean bl) {
        this.binary = bl;
    }

    @Override
    public void perform(@NotNull AbstractBuild<?, ?> build, @NotNull Launcher launcher, @NotNull BuildListener listener, @NotNull ZOSConnection zosConnection) {
        Intrinsics.checkNotNullParameter(build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        listener.getLogger().println(Messages.zdevops_declarative_writing_file_from_input(this.filePath, zosConnection.getHost(), zosConnection.getZosmfPort()));
        String string = this.text;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] textBytes = byArray;
        WriteOperationKt.writeToFile((TaskListener)listener, zosConnection, this.filePath, textBytes, this.binary);
    }

    @Extension
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\b\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lorg/zowe/zdevops/classic/steps/WriteToFileStep$DescriptorImpl;", "Lorg/zowe/zdevops/classic/AbstractBuildStep$Companion$DefaultBuildDescriptor;", "()V", "doCheckFilePath", "Lhudson/util/FormValidation;", "filePath", "", "doCheckText", "text", "zdevops"})
    public static final class DescriptorImpl
    extends AbstractBuildStep.Companion.DefaultBuildDescriptor {
        public DescriptorImpl() {
            String string = Messages.zdevops_classic_writeToFileStep_display_name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zdevops_classic_writeToFileStep_display_name(...)");
            super(string);
        }

        @Nullable
        public final FormValidation doCheckFilePath(@QueryParameter @NotNull String filePath) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return FieldsValidationKt.validateFieldIsNotEmpty(filePath);
        }

        @Nullable
        public final FormValidation doCheckText(@QueryParameter @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return FieldsValidationKt.validateFieldIsNotEmpty(text);
        }
    }
}

