/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.classic.steps;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.zdevops.Messages;
import org.zowe.zdevops.classic.AbstractBuildStep;
import org.zowe.zdevops.logic.WriteOperationKt;
import org.zowe.zdevops.utils.FieldsValidationKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001eB)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003J0\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0007J\u0012\u0010\u001d\u001a\u00020\u00132\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\t\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/zowe/zdevops/classic/steps/WriteFileToMemberStep;", "Lorg/zowe/zdevops/classic/AbstractBuildStep;", "connectionName", "", "dsn", "member", "fileOption", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDsn", "()Ljava/lang/String;", "getFileOption", "setFileOption", "(Ljava/lang/String;)V", "localFilePath", "getMember", "workspacePath", "getLocalFilePath", "getWorkspacePath", "perform", "", "build", "Lhudson/model/AbstractBuild;", "launcher", "Lhudson/Launcher;", "listener", "Lhudson/model/BuildListener;", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "setLocalFilePath", "setWorkspacePath", "DescriptorImpl", "zdevops"})
@SourceDebugExtension(value={"SMAP\nWriteFileToMemberStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriteFileToMemberStep.kt\norg/zowe/zdevops/classic/steps/WriteFileToMemberStep\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n1#2:202\n*E\n"})
public final class WriteFileToMemberStep
extends AbstractBuildStep {
    @NotNull
    private final String dsn;
    @NotNull
    private final String member;
    @Nullable
    private String fileOption;
    @Nullable
    private String localFilePath;
    @Nullable
    private String workspacePath;

    @DataBoundConstructor
    public WriteFileToMemberStep(@NotNull String connectionName, @NotNull String dsn, @NotNull String member, @Nullable String fileOption) {
        Intrinsics.checkNotNullParameter((Object)connectionName, (String)"connectionName");
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        super(connectionName);
        this.dsn = dsn;
        this.member = member;
        this.fileOption = fileOption;
    }

    @NotNull
    public final String getDsn() {
        return this.dsn;
    }

    @NotNull
    public final String getMember() {
        return this.member;
    }

    @Nullable
    public final String getFileOption() {
        return this.fileOption;
    }

    public final void setFileOption(@Nullable String string) {
        this.fileOption = string;
    }

    @DataBoundSetter
    public final void setLocalFilePath(@Nullable String localFilePath) {
        this.localFilePath = localFilePath;
    }

    @DataBoundSetter
    public final void setWorkspacePath(@Nullable String workspacePath) {
        this.workspacePath = workspacePath;
    }

    @Nullable
    public final String getLocalFilePath() {
        return this.localFilePath;
    }

    @Nullable
    public final String getWorkspacePath() {
        return this.workspacePath;
    }

    @Override
    public void perform(@NotNull AbstractBuild<?, ?> build, @NotNull Launcher launcher, @NotNull BuildListener listener, @NotNull ZOSConnection zosConnection) {
        String fileContent;
        File file;
        Intrinsics.checkNotNullParameter(build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        Executor executor = build.getExecutor();
        FilePath workspace = executor != null ? executor.getCurrentWorkspace() : null;
        String string = this.fileOption;
        if (Intrinsics.areEqual((Object)string, (Object)new DescriptorImpl().getLocalFileOption())) {
            String string2 = this.localFilePath;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                file = new File(it);
            } else {
                file = null;
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)new DescriptorImpl().getWorkspaceFileOption())) {
            FilePath filePath = workspace;
            String fileWorkspacePath = (filePath != null ? filePath.getRemote() : null) + "\\" + this.workspacePath;
            file = new File(fileWorkspacePath);
        } else {
            throw new AbortException(Messages.zdevops_classic_write_options_invalid());
        }
        File file2 = file;
        File file3 = file2;
        listener.getLogger().println(Messages.zdevops_declarative_writing_DS_from_file(this.dsn, file3 != null ? file3.getName() : null, zosConnection.getHost(), zosConnection.getZosmfPort()));
        File file4 = file2;
        String string3 = fileContent = file4 != null ? FilesKt.readText$default((File)file4, null, (int)1, null) : null;
        if (fileContent != null) {
            WriteOperationKt.writeToMember((TaskListener)listener, zosConnection, this.dsn, this.member, fileContent);
        }
    }

    @Extension
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0004J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\u0013\u001a\u00020\u0004J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\u0015\u001a\u00020\u00042\b\b\u0001\u0010\u0013\u001a\u00020\u0004J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\u0017\u001a\u00020\u0004J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\u0019\u001a\u00020\u00042\b\b\u0001\u0010\u0013\u001a\u00020\u0004J\u0006\u0010\u001a\u001a\u00020\u001bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/zowe/zdevops/classic/steps/WriteFileToMemberStep$DescriptorImpl;", "Lorg/zowe/zdevops/classic/AbstractBuildStep$Companion$DefaultBuildDescriptor;", "()V", "chooseFileOption", "", "getChooseFileOption", "()Ljava/lang/String;", "lastStepId", "", "localFileOption", "getLocalFileOption", "marker", "workspaceFileOption", "getWorkspaceFileOption", "createStepId", "doCheckDsn", "Lhudson/util/FormValidation;", "dsn", "doCheckFileOption", "fileOption", "doCheckLocalFilePath", "localFilePath", "doCheckMember", "member", "doCheckWorkspacePath", "workspacePath", "doFillFileOptionItems", "Lhudson/util/ListBoxModel;", "zdevops"})
    public static final class DescriptorImpl
    extends AbstractBuildStep.Companion.DefaultBuildDescriptor {
        private int lastStepId;
        @NotNull
        private final String marker;
        @NotNull
        private final String chooseFileOption;
        @NotNull
        private final String localFileOption;
        @NotNull
        private final String workspaceFileOption;

        public DescriptorImpl() {
            String string = Messages.zdevops_classic_writeFileToMemberStep_display_name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zdevops_classic_writeFil\u2026berStep_display_name(...)");
            super(string);
            this.marker = "WFTM";
            this.chooseFileOption = "choose";
            this.localFileOption = "local";
            this.workspaceFileOption = "workspace";
        }

        @NotNull
        public final String getChooseFileOption() {
            return this.chooseFileOption;
        }

        @NotNull
        public final String getLocalFileOption() {
            return this.localFileOption;
        }

        @NotNull
        public final String getWorkspaceFileOption() {
            return this.workspaceFileOption;
        }

        @JavaScriptMethod
        @NotNull
        public final synchronized String createStepId() {
            int n = this.lastStepId;
            this.lastStepId = n + 1;
            return this.marker + n;
        }

        @NotNull
        public final ListBoxModel doFillFileOptionItems() {
            ListBoxModel result = new ListBoxModel();
            result.add(Messages.zdevops_classic_write_options_choose(), this.chooseFileOption);
            result.add(Messages.zdevops_classic_write_options_local(), this.localFileOption);
            result.add(Messages.zdevops_classic_write_options_workspace(), this.workspaceFileOption);
            return result;
        }

        @Nullable
        public final FormValidation doCheckFileOption(@QueryParameter @NotNull String fileOption) {
            Intrinsics.checkNotNullParameter((Object)fileOption, (String)"fileOption");
            if (Intrinsics.areEqual((Object)fileOption, (Object)this.chooseFileOption) || ((CharSequence)fileOption).length() == 0) {
                return FormValidation.error((String)Messages.zdevops_classic_write_options_required());
            }
            return FormValidation.ok();
        }

        @Nullable
        public final FormValidation doCheckDsn(@QueryParameter @NotNull String dsn) {
            Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
            return FieldsValidationKt.validateDatasetName(dsn);
        }

        @Nullable
        public final FormValidation doCheckMember(@QueryParameter @NotNull String member) {
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            FormValidation formValidation = FieldsValidationKt.validateMemberName(member);
            if (formValidation == null) {
                formValidation = FieldsValidationKt.validateFieldIsNotEmpty(member);
            }
            return formValidation;
        }

        @Nullable
        public final FormValidation doCheckLocalFilePath(@QueryParameter @NotNull String localFilePath, @QueryParameter @NotNull String fileOption) {
            Intrinsics.checkNotNullParameter((Object)localFilePath, (String)"localFilePath");
            Intrinsics.checkNotNullParameter((Object)fileOption, (String)"fileOption");
            return Intrinsics.areEqual((Object)fileOption, (Object)this.localFileOption) ? FieldsValidationKt.validateFieldIsNotEmpty(localFilePath) : FormValidation.ok();
        }

        @Nullable
        public final FormValidation doCheckWorkspacePath(@QueryParameter @NotNull String workspacePath, @QueryParameter @NotNull String fileOption) {
            Intrinsics.checkNotNullParameter((Object)workspacePath, (String)"workspacePath");
            Intrinsics.checkNotNullParameter((Object)fileOption, (String)"fileOption");
            return Intrinsics.areEqual((Object)fileOption, (Object)this.workspaceFileOption) ? FieldsValidationKt.validateFieldIsNotEmpty(workspacePath) : FormValidation.ok();
        }
    }
}

