/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.classic.steps;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.zdevops.Messages;
import org.zowe.zdevops.classic.AbstractBuildStep;
import org.zowe.zdevops.logic.PerformTsoCommandOperationKt;
import org.zowe.zdevops.utils.FieldsValidationKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J0\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/zowe/zdevops/classic/steps/PerformTsoCommandStep;", "Lorg/zowe/zdevops/classic/AbstractBuildStep;", "connectionName", "", "acct", "command", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAcct", "()Ljava/lang/String;", "getCommand", "perform", "", "build", "Lhudson/model/AbstractBuild;", "launcher", "Lhudson/Launcher;", "listener", "Lhudson/model/BuildListener;", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "DescriptorImpl", "zdevops"})
public final class PerformTsoCommandStep
extends AbstractBuildStep {
    @NotNull
    private final String acct;
    @NotNull
    private final String command;

    @DataBoundConstructor
    public PerformTsoCommandStep(@NotNull String connectionName, @NotNull String acct, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)connectionName, (String)"connectionName");
        Intrinsics.checkNotNullParameter((Object)acct, (String)"acct");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        super(connectionName);
        this.acct = acct;
        this.command = command;
    }

    @NotNull
    public final String getAcct() {
        return this.acct;
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    @Override
    public void perform(@NotNull AbstractBuild<?, ?> build, @NotNull Launcher launcher, @NotNull BuildListener listener, @NotNull ZOSConnection zosConnection) {
        Intrinsics.checkNotNullParameter(build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        PerformTsoCommandOperationKt.performTsoCommand(zosConnection, (TaskListener)listener, this.acct, this.command);
    }

    @Extension
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\b\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lorg/zowe/zdevops/classic/steps/PerformTsoCommandStep$DescriptorImpl;", "Lorg/zowe/zdevops/classic/AbstractBuildStep$Companion$DefaultBuildDescriptor;", "()V", "doCheckAcct", "Lhudson/util/FormValidation;", "acct", "", "doCheckCommand", "command", "zdevops"})
    public static final class DescriptorImpl
    extends AbstractBuildStep.Companion.DefaultBuildDescriptor {
        public DescriptorImpl() {
            String string = Messages.zdevops_classic_performTsoCommandStep_display_name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zdevops_classic_performT\u2026andStep_display_name(...)");
            super(string);
        }

        @Nullable
        public final FormValidation doCheckAcct(@QueryParameter @NotNull String acct) {
            Intrinsics.checkNotNullParameter((Object)acct, (String)"acct");
            return FieldsValidationKt.validateFieldIsNotEmpty(acct);
        }

        @Nullable
        public final FormValidation doCheckCommand(@QueryParameter @NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            return FieldsValidationKt.validateFieldIsNotEmpty(command);
        }
    }
}

