/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.classic.steps;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.servlet.ServletException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.zowe.kotlinsdk.AllocationUnit;
import org.zowe.kotlinsdk.DatasetOrganization;
import org.zowe.kotlinsdk.DsnameType;
import org.zowe.kotlinsdk.RecordFormat;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.zdevops.Messages;
import org.zowe.zdevops.classic.AbstractBuildStep;
import org.zowe.zdevops.logic.AllocateOperationKt;
import org.zowe.zdevops.utils.FieldsValidationKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001:\u0001SBC\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010/\u001a\u0004\u0018\u00010\u0010J\r\u00100\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u00101J\r\u00102\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u00101J\b\u00103\u001a\u0004\u0018\u00010\u0003J\r\u00104\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u00101J\b\u00105\u001a\u0004\u0018\u00010\u0003J\b\u00106\u001a\u0004\u0018\u00010\u001cJ\r\u00107\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u00101J\b\u00108\u001a\u0004\u0018\u00010\u0003J\b\u00109\u001a\u0004\u0018\u00010\u0003J\b\u0010:\u001a\u0004\u0018\u00010\u0003J\b\u0010;\u001a\u0004\u0018\u00010\u0003J0\u0010<\u001a\u00020=2\u000e\u0010>\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020=2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0017\u0010G\u001a\u00020=2\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0002\u0010HJ\u0017\u0010I\u001a\u00020=2\b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0002\u0010HJ\u0012\u0010J\u001a\u00020=2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0007J\u0017\u0010K\u001a\u00020=2\b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0002\u0010HJ\u0012\u0010L\u001a\u00020=2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0007J\u0010\u0010M\u001a\u00020=2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0017\u0010N\u001a\u00020=2\b\u0010!\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0002\u0010HJ\u0012\u0010O\u001a\u00020=2\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0007J\u0012\u0010P\u001a\u00020=2\b\u0010,\u001a\u0004\u0018\u00010\u0003H\u0007J\u0012\u0010Q\u001a\u00020=2\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0007J\u0012\u0010R\u001a\u00020=2\b\u0010.\u001a\u0004\u0018\u00010\u0003H\u0007R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0012\u0010!\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010$\"\u0004\b*\u0010+R\u0010\u0010,\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lorg/zowe/zdevops/classic/steps/AllocateDatasetStep;", "Lorg/zowe/zdevops/classic/AbstractBuildStep;", "connectionName", "", "dsn", "dsOrg", "Lorg/zowe/kotlinsdk/DatasetOrganization;", "primary", "", "secondary", "recFm", "Lorg/zowe/kotlinsdk/RecordFormat;", "failOnExist", "", "(Ljava/lang/String;Ljava/lang/String;Lorg/zowe/kotlinsdk/DatasetOrganization;IILorg/zowe/kotlinsdk/RecordFormat;Z)V", "alcUnit", "Lorg/zowe/kotlinsdk/AllocationUnit;", "avgBlk", "Ljava/lang/Integer;", "blkSize", "dataClass", "dirBlk", "dsModel", "getDsOrg", "()Lorg/zowe/kotlinsdk/DatasetOrganization;", "getDsn", "()Ljava/lang/String;", "dsnType", "Lorg/zowe/kotlinsdk/DsnameType;", "getFailOnExist", "()Z", "setFailOnExist", "(Z)V", "lrecl", "mgntClass", "getPrimary", "()I", "getRecFm", "()Lorg/zowe/kotlinsdk/RecordFormat;", "setRecFm", "(Lorg/zowe/kotlinsdk/RecordFormat;)V", "getSecondary", "setSecondary", "(I)V", "storClass", "unit", "volser", "getAlcUnit", "getAvgBlk", "()Ljava/lang/Integer;", "getBlkSize", "getDataClass", "getDirBlk", "getDsModel", "getDsnType", "getLrecl", "getMgntClass", "getStorClass", "getUnit", "getVolser", "perform", "", "build", "Lhudson/model/AbstractBuild;", "launcher", "Lhudson/Launcher;", "listener", "Lhudson/model/BuildListener;", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "setAlcUnit", "setAvgBlk", "(Ljava/lang/Integer;)V", "setBlkSize", "setDataClass", "setDirBlk", "setDsModel", "setDsnType", "setLrecl", "setMgntClass", "setStorClass", "setUnit", "setVolser", "DescriptorImpl", "zdevops"})
public final class AllocateDatasetStep
extends AbstractBuildStep {
    @NotNull
    private final String dsn;
    @NotNull
    private final DatasetOrganization dsOrg;
    private final int primary;
    private int secondary;
    @NotNull
    private RecordFormat recFm;
    private boolean failOnExist;
    @Nullable
    private String volser;
    @Nullable
    private String unit;
    @Nullable
    private AllocationUnit alcUnit;
    @Nullable
    private Integer dirBlk;
    @Nullable
    private Integer blkSize;
    @Nullable
    private Integer lrecl;
    @Nullable
    private String storClass;
    @Nullable
    private String mgntClass;
    @Nullable
    private String dataClass;
    @Nullable
    private Integer avgBlk;
    @Nullable
    private DsnameType dsnType;
    @Nullable
    private String dsModel;

    @DataBoundConstructor
    public AllocateDatasetStep(@NotNull String connectionName, @NotNull String dsn, @NotNull DatasetOrganization dsOrg, int primary, int secondary, @NotNull RecordFormat recFm, boolean failOnExist) {
        Intrinsics.checkNotNullParameter((Object)connectionName, (String)"connectionName");
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        Intrinsics.checkNotNullParameter((Object)dsOrg, (String)"dsOrg");
        Intrinsics.checkNotNullParameter((Object)recFm, (String)"recFm");
        super(connectionName);
        this.dsn = dsn;
        this.dsOrg = dsOrg;
        this.primary = primary;
        this.secondary = secondary;
        this.recFm = recFm;
        this.failOnExist = failOnExist;
        this.lrecl = 80;
    }

    public /* synthetic */ AllocateDatasetStep(String string, String string2, DatasetOrganization datasetOrganization, int n, int n2, RecordFormat recordFormat, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            n = 1;
        }
        if ((n3 & 0x40) != 0) {
            bl = false;
        }
        this(string, string2, datasetOrganization, n, n2, recordFormat, bl);
    }

    @NotNull
    public final String getDsn() {
        return this.dsn;
    }

    @NotNull
    public final DatasetOrganization getDsOrg() {
        return this.dsOrg;
    }

    public final int getPrimary() {
        return this.primary;
    }

    public final int getSecondary() {
        return this.secondary;
    }

    public final void setSecondary(int n) {
        this.secondary = n;
    }

    @NotNull
    public final RecordFormat getRecFm() {
        return this.recFm;
    }

    public final void setRecFm(@NotNull RecordFormat recordFormat) {
        Intrinsics.checkNotNullParameter((Object)recordFormat, (String)"<set-?>");
        this.recFm = recordFormat;
    }

    public final boolean getFailOnExist() {
        return this.failOnExist;
    }

    public final void setFailOnExist(boolean bl) {
        this.failOnExist = bl;
    }

    @DataBoundSetter
    public final void setVolser(@Nullable String volser) {
        CharSequence charSequence = volser;
        this.volser = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : volser;
    }

    @DataBoundSetter
    public final void setUnit(@Nullable String unit) {
        CharSequence charSequence = unit;
        this.unit = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : unit;
    }

    @DataBoundSetter
    public final void setAlcUnit(@NotNull AllocationUnit alcUnit) {
        Intrinsics.checkNotNullParameter((Object)alcUnit, (String)"alcUnit");
        this.alcUnit = alcUnit;
    }

    @DataBoundSetter
    public final void setDirBlk(@Nullable Integer dirBlk) {
        this.dirBlk = dirBlk;
    }

    @DataBoundSetter
    public final void setBlkSize(@Nullable Integer blkSize) {
        this.blkSize = blkSize;
    }

    @DataBoundSetter
    public final void setLrecl(@Nullable Integer lrecl) {
        this.lrecl = lrecl;
    }

    @DataBoundSetter
    public final void setStorClass(@Nullable String storClass) {
        CharSequence charSequence = storClass;
        this.storClass = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : storClass;
    }

    @DataBoundSetter
    public final void setMgntClass(@Nullable String mgntClass) {
        CharSequence charSequence = mgntClass;
        this.mgntClass = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : mgntClass;
    }

    @DataBoundSetter
    public final void setDataClass(@Nullable String dataClass) {
        CharSequence charSequence = dataClass;
        this.dataClass = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : dataClass;
    }

    @DataBoundSetter
    public final void setAvgBlk(@Nullable Integer avgBlk) {
        this.avgBlk = avgBlk;
    }

    @DataBoundSetter
    public final void setDsnType(@NotNull DsnameType dsnType) {
        Intrinsics.checkNotNullParameter((Object)dsnType, (String)"dsnType");
        this.dsnType = dsnType;
    }

    @DataBoundSetter
    public final void setDsModel(@Nullable String dsModel) {
        CharSequence charSequence = dsModel;
        this.dsModel = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : dsModel;
    }

    @Nullable
    public final String getVolser() {
        return this.volser;
    }

    @Nullable
    public final String getUnit() {
        return this.unit;
    }

    @Nullable
    public final AllocationUnit getAlcUnit() {
        return this.alcUnit;
    }

    @Nullable
    public final Integer getDirBlk() {
        return this.dirBlk;
    }

    @Nullable
    public final Integer getBlkSize() {
        return this.blkSize;
    }

    @Nullable
    public final Integer getLrecl() {
        return this.lrecl;
    }

    @Nullable
    public final String getStorClass() {
        return this.storClass;
    }

    @Nullable
    public final String getMgntClass() {
        return this.mgntClass;
    }

    @Nullable
    public final String getDataClass() {
        return this.dataClass;
    }

    @Nullable
    public final Integer getAvgBlk() {
        return this.avgBlk;
    }

    @Nullable
    public final DsnameType getDsnType() {
        return this.dsnType;
    }

    @Nullable
    public final String getDsModel() {
        return this.dsModel;
    }

    @Override
    public void perform(@NotNull AbstractBuild<?, ?> build, @NotNull Launcher launcher, @NotNull BuildListener listener, @NotNull ZOSConnection zosConnection) {
        Intrinsics.checkNotNullParameter(build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        AllocateOperationKt.allocateDataset((TaskListener)listener, zosConnection, this.dsn, this.volser, this.unit, this.dsOrg, this.alcUnit, this.primary, this.secondary, this.dirBlk, this.recFm, this.blkSize, this.lrecl, this.storClass, this.mgntClass, this.dataClass, this.avgBlk, this.dsnType, this.dsModel, this.failOnExist);
    }

    @Extension
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\t\u001a\u00020\u0006J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u000b\u001a\u00020\u0006J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\r\u001a\u00020\u0006J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u000f\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\u0011J\u0006\u0010\u0014\u001a\u00020\u0011\u00a8\u0006\u0015"}, d2={"Lorg/zowe/zdevops/classic/steps/AllocateDatasetStep$DescriptorImpl;", "Lorg/zowe/zdevops/classic/AbstractBuildStep$Companion$DefaultBuildDescriptor;", "()V", "convertStringAndValidateIntPositive", "Lhudson/util/FormValidation;", "value", "", "doCheckBlkSize", "lrecl", "blkSize", "doCheckDsn", "dsn", "doCheckPrimary", "primary", "doCheckSecondary", "secondary", "doFillAlcUnitItems", "Lhudson/util/ListBoxModel;", "doFillDsOrgItems", "doFillDsnTypeItems", "doFillRecFmItems", "zdevops"})
    public static final class DescriptorImpl
    extends AbstractBuildStep.Companion.DefaultBuildDescriptor {
        public DescriptorImpl() {
            String string = Messages.zdevops_classic_allocateDatasetStep_display_name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zdevops_classic_allocate\u2026setStep_display_name(...)");
            super(string);
        }

        @NotNull
        public final ListBoxModel doFillAlcUnitItems() {
            ListBoxModel result = new ListBoxModel();
            result.add("CYL");
            result.add("TRK");
            return result;
        }

        @NotNull
        public final ListBoxModel doFillRecFmItems() {
            ListBoxModel result = new ListBoxModel();
            result.add("Fixed-length (F)", "F");
            result.add("Fixed-length, blocked (FB)", "FB");
            result.add("Variable-length (V)", "V");
            result.add("Variable-length, blocked (VB)", "VB");
            result.add("Undefined-length (U)", "U");
            result.add("Variable-length, ASA print control characters (VA)", "VA");
            return result;
        }

        @NotNull
        public final ListBoxModel doFillDsnTypeItems() {
            ListBoxModel result = new ListBoxModel();
            result.add("BASIC");
            result.add("LIBRARY");
            result.add("HFS");
            result.add("PDS");
            result.add("LARGE");
            result.add("EXTREQ");
            result.add("EXTPREF");
            return result;
        }

        @NotNull
        public final ListBoxModel doFillDsOrgItems() {
            ListBoxModel result = new ListBoxModel();
            result.add("Partitioned organized (PO)", "PO");
            result.add("Partitioned Extended (POE)", "POE");
            result.add("Physical sequentia (PS)", "PS");
            return result;
        }

        @Nullable
        public final FormValidation doCheckBlkSize(@QueryParameter @NotNull String lrecl, @QueryParameter @NotNull String blkSize) throws IOException, ServletException {
            Intrinsics.checkNotNullParameter((Object)lrecl, (String)"lrecl");
            Intrinsics.checkNotNullParameter((Object)blkSize, (String)"blkSize");
            if (((CharSequence)lrecl).length() == 0) {
                return FormValidation.ok();
            }
            try {
                int lreclInt = Integer.parseInt(lrecl);
                int blkSizeInt = Integer.parseInt(blkSize);
                if (lreclInt > blkSizeInt) {
                    return FormValidation.warning((String)Messages.zdevops_classic_allocateDatasetStep_blksize_smaller_than_lrecl_validation());
                }
                return blkSizeInt % lreclInt == 0 ? FormValidation.ok() : FormValidation.warning((String)Messages.zdevops_classic_allocateDatasetStep_blksize_validation_warning());
            }
            catch (NumberFormatException e) {
                return FormValidation.warning((String)Messages.zdevops_value_is_not_number_validation());
            }
        }

        @Nullable
        public final FormValidation doCheckDsn(@QueryParameter @NotNull String dsn) {
            Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
            return FieldsValidationKt.validateDatasetName(dsn);
        }

        @Nullable
        public final FormValidation doCheckPrimary(@QueryParameter @NotNull String primary) {
            Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
            if (((CharSequence)primary).length() == 0) {
                return FormValidation.ok();
            }
            try {
                int valueInt = Integer.parseInt(primary);
                if (valueInt == 0) {
                    return FormValidation.error((String)Messages.zdevops_classic_allocateDatasetStep_primary_is_zero_validation());
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.zdevops_value_is_not_number_validation());
            }
            return this.convertStringAndValidateIntPositive(primary);
        }

        @Nullable
        public final FormValidation doCheckSecondary(@QueryParameter @NotNull String secondary) {
            Intrinsics.checkNotNullParameter((Object)secondary, (String)"secondary");
            return this.convertStringAndValidateIntPositive(secondary);
        }

        @Nullable
        public final FormValidation convertStringAndValidateIntPositive(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (((CharSequence)value).length() == 0) {
                return FormValidation.ok();
            }
            try {
                int valueInt = Integer.parseInt(value);
                return valueInt >= 0 ? FormValidation.ok() : FormValidation.error((String)Messages.zdevops_value_must_be_positive_number_validation());
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.zdevops_value_is_not_number_validation());
            }
        }
    }
}

