/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.utils;

import hudson.util.FormValidation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zowe.zdevops.Messages;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u0003\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0003\u00a8\u0006\n"}, d2={"validateDatasetName", "Lhudson/util/FormValidation;", "dsn", "", "validateDsnOrDsnMemberName", "dsnOrDsnMember", "validateFieldIsNotEmpty", "value", "validateMemberName", "member", "zdevops"})
public final class FieldsValidationKt {
    @Nullable
    public static final FormValidation validateDatasetName(@NotNull String dsn) {
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        Regex dsnPattern = new Regex("^[a-zA-Z#$@][a-zA-Z0-9#$@-]{0,7}([.][a-zA-Z#$@][a-zA-Z0-9#$@-]{0,7}){0,21}$");
        return !StringsKt.isBlank((CharSequence)dsn) ? (!dsnPattern.matches((CharSequence)dsn) ? FormValidation.warning((String)Messages.zdevops_dataset_name_is_invalid_validation()) : FormValidation.ok()) : FormValidation.error((String)Messages.zdevops_value_must_not_be_empty_validation());
    }

    @Nullable
    public static final FormValidation validateMemberName(@NotNull String member) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Regex memberPattern = new Regex("^(?:[A-Z#@$][A-Z0-9#@$]{0,7}|[a-z#@$][a-zA-Z0-9#@$]{0,7})$");
        return member.length() > 8 || ((CharSequence)member).length() == 0 ? FormValidation.error((String)Messages.zdevops_value_up_to_eight_in_length_validation()) : (!memberPattern.matches((CharSequence)member) ? FormValidation.warning((String)Messages.zdevops_member_name_is_invalid_validation()) : FormValidation.ok());
    }

    @Nullable
    public static final FormValidation validateDsnOrDsnMemberName(@NotNull String dsnOrDsnMember) {
        Intrinsics.checkNotNullParameter((Object)dsnOrDsnMember, (String)"dsnOrDsnMember");
        Regex dsnOrDsnMemberPattern = new Regex("^[a-zA-Z#$@][a-zA-Z0-9#$@-]{0,7}([.][a-zA-Z#$@][a-zA-Z0-9#$@-]{0,7}){0,21}(?:[(](?:[A-Z#@$][A-Z0-9#@$]{0,7}|[a-z#@$][a-zA-Z0-9#@$]{0,7})[)]$|)$");
        return !StringsKt.isBlank((CharSequence)dsnOrDsnMember) ? (!dsnOrDsnMemberPattern.matches((CharSequence)dsnOrDsnMember) ? FormValidation.warning((String)Messages.zdevops_dataset_name_is_invalid_validation()) : FormValidation.ok()) : FormValidation.error((String)Messages.zdevops_value_must_not_be_empty_validation());
    }

    @Nullable
    public static final FormValidation validateFieldIsNotEmpty(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Intrinsics.areEqual((Object)value, (Object)"") ? FormValidation.error((String)Messages.zdevops_value_must_not_be_empty_validation()) : FormValidation.ok();
    }
}

