/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.logic;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import hudson.AbortException;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zowe.kotlinsdk.Dataset;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.kotlinsdk.zowe.client.sdk.zosfiles.ZosDsn;
import org.zowe.kotlinsdk.zowe.client.sdk.zosuss.ZosUssFile;
import org.zowe.zdevops.Messages;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a&\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a5\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010\u001a.\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\u0013"}, d2={"validateTextForDataset", "", "listener", "Lhudson/model/TaskListener;", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "dsn", "", "text", "writeToDataset", "writeToFile", "destFile", "textBytes", "", "binary", "", "(Lhudson/model/TaskListener;Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;Ljava/lang/String;[BLjava/lang/Boolean;)V", "writeToMember", "member", "zdevops"})
@SourceDebugExtension(value={"SMAP\nWriteOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriteOperation.kt\norg/zowe/zdevops/logic/WriteOperationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SimpleMFExceptionMessageExtractor.kt\norg/zowe/zdevops/utils/SimpleMFExceptionMessageExtractorKt\n*L\n1#1,124:1\n1855#2,2:125\n1855#2,2:144\n1855#2,2:168\n1855#2,2:192\n25#3,17:127\n42#3,5:146\n25#3,17:151\n42#3,5:170\n25#3,17:175\n42#3,5:194\n*S KotlinDebug\n*F\n+ 1 WriteOperation.kt\norg/zowe/zdevops/logic/WriteOperationKt\n*L\n49#1:125,2\n75#1:144,2\n99#1:168,2\n112#1:192,2\n75#1:127,17\n75#1:146,5\n99#1:151,17\n99#1:170,5\n112#1:175,17\n112#1:194,5\n*E\n"})
public final class WriteOperationKt {
    private static final void validateTextForDataset(TaskListener listener, ZOSConnection zosConnection, String dsn, String text) {
        if (Intrinsics.areEqual((Object)text, (Object)"")) {
            listener.getLogger().println(Messages.zdevops_declarative_writing_skip());
            return;
        }
        char[] cArray = new char[]{'\n'};
        List stringList = StringsKt.split$default((CharSequence)text, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        Dataset targetDS = new ZosDsn(zosConnection, null, 2, null).getDatasetInfo(dsn);
        if (targetDS.getRecordLength() == null) {
            throw new AbortException(Messages.zdevops_declarative_writing_DS_no_info(dsn));
        }
        int ineligibleStrings = 0;
        Iterable $this$forEach$iv = stringList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            int n = it.length();
            Integer n2 = targetDS.getRecordLength();
            Intrinsics.checkNotNull((Object)n2);
            if (n <= n2) continue;
            ++ineligibleStrings;
        }
        if (ineligibleStrings > 0) {
            throw new AbortException(Messages.zdevops_declarative_writing_DS_ineligible_strings(ineligibleStrings, dsn));
        }
    }

    public static final void writeToDataset(@NotNull TaskListener listener, @NotNull ZOSConnection zosConnection, @NotNull String dsn, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        WriteOperationKt.validateTextForDataset(listener, zosConnection, dsn, text);
        String string = StringsKt.replace$default((String)text, (String)"\r", (String)"", (boolean)false, (int)4, null);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] textByteArray = byArray;
        boolean $i$f$runMFTryCatchWrappedQuery = false;
        try {
            boolean bl = false;
            Result.constructor-impl((Object)new ZosDsn(zosConnection, null, 2, null).writeDsn(dsn, textByteArray));
        }
        catch (Exception e$iv) {
            Map responseMap$iv;
            block10: {
                responseMap$iv = null;
                try {
                    Object object = new Gson().fromJson(e$iv.getMessage(), new TypeToken<Map<String, ? extends Object>>(){}.getType());
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                    responseMap$iv = (Map)object;
                }
                catch (Exception eInternal$iv) {
                    CharSequence charSequence;
                    String string2 = eInternal$iv.getMessage();
                    boolean bl = string2 != null ? new Regex("Expected .* but was STRING").containsMatchIn(charSequence = (CharSequence)string2) : false;
                    if (bl) {
                        listener.getLogger().println(e$iv.getMessage());
                        break block10;
                    }
                    listener.getLogger().println(eInternal$iv.getMessage());
                }
            }
            Object errorContent$iv = null;
            try {
                Map map = responseMap$iv;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"responseMap");
                    map = null;
                }
                Object v = map.get("details");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type java.util.ArrayList<*>{ kotlin.collections.TypeAliasesKt.ArrayList<*> }");
                errorContent$iv = (ArrayList)v;
                Iterable $this$forEach$iv$iv = (Iterable)errorContent$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv;
                    Object it$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    listener.getLogger().println(it$iv);
                }
            }
            catch (NullPointerException e$iv2) {
                Map map = responseMap$iv;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"responseMap");
                    map = null;
                }
                Object v = map.get("message");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                errorContent$iv = (String)v;
                listener.getLogger().println((String)errorContent$iv);
            }
            throw new Exception(e$iv);
        }
        listener.getLogger().println(Messages.zdevops_declarative_writing_DS_success(dsn));
    }

    public static final void writeToMember(@NotNull TaskListener listener, @NotNull ZOSConnection zosConnection, @NotNull String dsn, @NotNull String member, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        WriteOperationKt.validateTextForDataset(listener, zosConnection, dsn, text);
        String string = StringsKt.replace$default((String)text, (String)"\r", (String)"", (boolean)false, (int)4, null);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] textByteArray = byArray;
        boolean $i$f$runMFTryCatchWrappedQuery = false;
        try {
            boolean bl = false;
            Result.constructor-impl((Object)new ZosDsn(zosConnection, null, 2, null).writeDsn(dsn, member, textByteArray));
        }
        catch (Exception e$iv) {
            Map responseMap$iv;
            block10: {
                responseMap$iv = null;
                try {
                    Object object = new Gson().fromJson(e$iv.getMessage(), new /* invalid duplicate definition of identical inner class */.getType());
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                    responseMap$iv = (Map)object;
                }
                catch (Exception eInternal$iv) {
                    CharSequence charSequence;
                    String string2 = eInternal$iv.getMessage();
                    boolean bl = string2 != null ? new Regex("Expected .* but was STRING").containsMatchIn(charSequence = (CharSequence)string2) : false;
                    if (bl) {
                        listener.getLogger().println(e$iv.getMessage());
                        break block10;
                    }
                    listener.getLogger().println(eInternal$iv.getMessage());
                }
            }
            Object errorContent$iv = null;
            try {
                Map map = responseMap$iv;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"responseMap");
                    map = null;
                }
                Object v = map.get("details");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type java.util.ArrayList<*>{ kotlin.collections.TypeAliasesKt.ArrayList<*> }");
                errorContent$iv = (ArrayList)v;
                Iterable $this$forEach$iv$iv = (Iterable)errorContent$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv;
                    Object it$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    listener.getLogger().println(it$iv);
                }
            }
            catch (NullPointerException e$iv2) {
                Map map = responseMap$iv;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"responseMap");
                    map = null;
                }
                Object v = map.get("message");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                errorContent$iv = (String)v;
                listener.getLogger().println((String)errorContent$iv);
            }
            throw new Exception(e$iv);
        }
        listener.getLogger().println(Messages.zdevops_declarative_writing_DS_success(dsn));
    }

    public static final void writeToFile(@NotNull TaskListener listener, @NotNull ZOSConnection zosConnection, @NotNull String destFile, @NotNull byte[] textBytes, @Nullable Boolean binary) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        Intrinsics.checkNotNullParameter((Object)destFile, (String)"destFile");
        Intrinsics.checkNotNullParameter((Object)textBytes, (String)"textBytes");
        if (!(textBytes.length == 0)) {
            boolean $i$f$runMFTryCatchWrappedQuery = false;
            try {
                boolean bl = false;
                Result.constructor-impl((Object)(Intrinsics.areEqual((Object)binary, (Object)true) ? new ZosUssFile(zosConnection, null, 2, null).writeToFileBin(destFile, textBytes) : new ZosUssFile(zosConnection, null, 2, null).writeToFile(destFile, textBytes)));
            }
            catch (Exception e$iv) {
                Map responseMap$iv;
                block12: {
                    responseMap$iv = null;
                    try {
                        Object object = new Gson().fromJson(e$iv.getMessage(), new /* invalid duplicate definition of identical inner class */.getType());
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                        responseMap$iv = (Map)object;
                    }
                    catch (Exception eInternal$iv) {
                        CharSequence charSequence;
                        String string = eInternal$iv.getMessage();
                        boolean bl = string != null ? new Regex("Expected .* but was STRING").containsMatchIn(charSequence = (CharSequence)string) : false;
                        if (bl) {
                            listener.getLogger().println(e$iv.getMessage());
                            break block12;
                        }
                        listener.getLogger().println(eInternal$iv.getMessage());
                    }
                }
                Object errorContent$iv = null;
                try {
                    Map map = responseMap$iv;
                    if (map == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"responseMap");
                        map = null;
                    }
                    Object v = map.get("details");
                    Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type java.util.ArrayList<*>{ kotlin.collections.TypeAliasesKt.ArrayList<*> }");
                    errorContent$iv = (ArrayList)v;
                    Iterable $this$forEach$iv$iv = (Iterable)errorContent$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv$iv;
                        Object it$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        listener.getLogger().println(it$iv);
                    }
                }
                catch (NullPointerException e$iv2) {
                    Map map = responseMap$iv;
                    if (map == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"responseMap");
                        map = null;
                    }
                    Object v = map.get("message");
                    Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                    errorContent$iv = (String)v;
                    listener.getLogger().println((String)errorContent$iv);
                }
                throw new Exception(e$iv);
            }
            listener.getLogger().println(Messages.zdevops_declarative_writing_file_success(destFile));
        } else {
            listener.getLogger().println(Messages.zdevops_declarative_writing_skip());
        }
    }
}

