/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.logic;

import hudson.AbortException;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zowe.kotlinsdk.DataSetsList;
import org.zowe.kotlinsdk.Dataset;
import org.zowe.kotlinsdk.DatasetOrganization;
import org.zowe.kotlinsdk.Member;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.kotlinsdk.zowe.client.sdk.zosfiles.ZosDsnDownload;
import org.zowe.kotlinsdk.zowe.client.sdk.zosfiles.ZosDsnList;
import org.zowe.kotlinsdk.zowe.client.sdk.zosfiles.input.DownloadParams;
import org.zowe.kotlinsdk.zowe.client.sdk.zosfiles.input.ListParams;
import org.zowe.zdevops.Messages;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a?\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\r\u001a?\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"downloadDS", "", "dsn", "", "vol", "returnEtag", "", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "workspace", "Lhudson/FilePath;", "listener", "Lhudson/model/TaskListener;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;Lhudson/FilePath;Lhudson/model/TaskListener;)V", "downloadDSOrDSMemberByType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Lhudson/model/TaskListener;Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;Lhudson/FilePath;)V", "zdevops"})
@SourceDebugExtension(value={"SMAP\nDownloadOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadOperation.kt\norg/zowe/zdevops/logic/DownloadOperationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1855#2,2:101\n*S KotlinDebug\n*F\n+ 1 DownloadOperation.kt\norg/zowe/zdevops/logic/DownloadOperationKt\n*L\n92#1:101,2\n*E\n"})
public final class DownloadOperationKt {
    public static final void downloadDS(@NotNull String dsn, @Nullable String vol, @Nullable Boolean returnEtag, @NotNull ZOSConnection zosConnection, @NotNull FilePath workspace, @NotNull TaskListener listener) {
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        InputStream downloadedDSN = null;
        try {
            downloadedDSN = new ZosDsnDownload(zosConnection, null, 2, null).downloadDsn(dsn, new DownloadParams(dsn, returnEtag, vol));
        }
        catch (Exception e) {
            CharSequence charSequence = vol;
            throw new AbortException("Can't download " + dsn + " " + (String)(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "on volume " + vol : "") + " due to " + e.getMessage());
        }
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)downloadedDSN, (Writer)writer, (String)"UTF-8");
        File file = new File(workspace + "\\" + dsn);
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        listener.getLogger().println(Messages.zdevops_declarative_DSN_downloaded_success(dsn));
    }

    public static final void downloadDSOrDSMemberByType(@NotNull String dsn, @Nullable String vol, @Nullable Boolean returnEtag, @NotNull TaskListener listener, @NotNull ZOSConnection zosConnection, @NotNull FilePath workspace) {
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        listener.getLogger().println(Messages.zdevops_declarative_DSN_downloading(dsn, vol, zosConnection.getHost(), zosConnection.getZosmfPort()));
        Regex dsnMemberPattern = new Regex("[\\w#$@.-]{1,}\\([\\w#$@]{1,8}\\)");
        if (dsnMemberPattern.containsMatchIn((CharSequence)dsn)) {
            DownloadOperationKt.downloadDS(dsn, vol, returnEtag, zosConnection, workspace, listener);
        } else {
            DataSetsList dsnList = new ZosDsnList(zosConnection, null, 2, null).listDsn(dsn, new ListParams(vol, null, null, null, null, null, null, false, 254, null));
            if (dsnList.getItems().isEmpty()) {
                CharSequence charSequence = vol;
                throw new AbortException("Can't find " + dsn + " " + (String)(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "" : "on volume " + vol));
            }
            DatasetOrganization datasetOrganization = ((Dataset)CollectionsKt.first((List)dsnList.getItems())).getDatasetOrganization();
            switch (datasetOrganization == null ? -1 : WhenMappings.$EnumSwitchMapping$0[datasetOrganization.ordinal()]) {
                case 1: {
                    DownloadOperationKt.downloadDS(dsn, vol, returnEtag, zosConnection, workspace, listener);
                    break;
                }
                case 2: 
                case 3: {
                    listener.getLogger().println(Messages.zdevops_declarative_DSN_downloading_members(dsn));
                    Iterable $this$forEach$iv = new ZosDsnList(zosConnection, null, 2, null).listDsnMembers(dsn, new ListParams(vol, null, null, null, null, null, null, false, 254, null)).getItems();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Member it = (Member)element$iv;
                        boolean bl = false;
                        DownloadOperationKt.downloadDS(dsn + "(" + it.getName() + ")", vol, returnEtag, zosConnection, workspace, listener);
                    }
                    break;
                }
                default: {
                    listener.getLogger().println(Messages.zdevops_declarative_DSN_downloading_invalid_dsorg());
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatasetOrganization.values().length];
            try {
                nArray[DatasetOrganization.PS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatasetOrganization.PO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatasetOrganization.POE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

